/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.common.editor;

import de.rcenvironment.core.gui.integration.common.editor.IIntegrationEditorPage;
import de.rcenvironment.core.gui.utils.common.EditorsHelper;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;

public abstract class IntegrationEditor
extends MultiPageEditorPart
implements IWorkbenchListener,
ISaveablePart2 {
    private static final String CLOSING_DIALOG_LOST_CHANGES = "The changes in the editor '%s' will be lost on close.\nDo you really want to close the editor?";
    private static final String CLOSING_DIALOG_INTEGRATE = "Integrate '%s'? ";
    private static final String BUTTON_CANCEL = "Cancel";
    private static final String BUTTON_DON_T_INTEGRATE = "Do not Integrate";
    private static final String BUTTON_DON_T_UPDATE = "Do not Update Integration";
    private boolean isValid;

    protected IntegrationEditor() {
        PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)this);
    }

    public int promptToSaveOnClose() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getActiveWorkbenchWindow().getActivePage().bringToTop((IWorkbenchPart)this);
        String buttonDonTIntegrate = this.isEditMode() ? BUTTON_DON_T_UPDATE : BUTTON_DON_T_INTEGRATE;
        if (this.isValid) {
            switch (MessageDialog.open((int)3, (Shell)workbench.getModalDialogShellProvider().getShell(), (String)this.getDialogTitle(), (String)StringUtils.format((String)CLOSING_DIALOG_INTEGRATE, (Object[])new Object[]{this.getTitle()}), (int)0, (String[])new String[]{this.getButtonTextIntegrate(), buttonDonTIntegrate, BUTTON_CANCEL})) {
                case 0: {
                    this.integrate();
                    return 1;
                }
                case 1: {
                    return 1;
                }
            }
            return 2;
        }
        if (MessageDialog.openQuestion((Shell)workbench.getModalDialogShellProvider().getShell(), (String)this.getDialogTitle(), (String)StringUtils.format((String)CLOSING_DIALOG_LOST_CHANGES, (Object[])new Object[]{this.getTitle()}))) {
            return 1;
        }
        return 2;
    }

    public abstract String getButtonTextIntegrate();

    public abstract String getDialogTitle();

    public boolean isDirty() {
        return this.getPages().stream().anyMatch(IIntegrationEditorPage::hasChanges) || !this.isEditMode();
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public boolean preShutdown(IWorkbench workbench, boolean arg1) {
        return EditorsHelper.closeEditor((IEditorPart)this, (boolean)true);
    }

    public void postShutdown(IWorkbench workbench) {
    }

    private void setNavigationButtonActivation() {
        CTabFolder tabFolder = (CTabFolder)this.getContainer();
        Arrays.stream(tabFolder.getItems()).filter(item -> item.getData() instanceof IIntegrationEditorPage).forEach(item -> {
            int index = tabFolder.indexOf(item);
            IIntegrationEditorPage page = (IIntegrationEditorPage)item.getData();
            page.setBackButtonEnabled(index != 0);
            page.setNextButtonEnabled(index < tabFolder.getItemCount() - 1);
        });
    }

    protected void initializePageSwitching() {
        super.initializePageSwitching();
        this.setNavigationButtonActivation();
    }

    public abstract void doSave(IProgressMonitor var1);

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void updateValid() {
        this.isValid = this.getPages().stream().allMatch(IIntegrationEditorPage::isPageValid);
        this.getPages().stream().forEach(page -> page.setSaveButtonEnabled(this.isValid));
    }

    public abstract boolean isEditMode();

    public void setNextPage() {
        if (this.getActivePage() < this.getPageCount() - 1) {
            this.setActivePage(this.getActivePage() + 1);
        }
    }

    public void setPreviousPage() {
        if (this.getActivePage() > 0) {
            this.setActivePage(this.getActivePage() - 1);
        }
    }

    public void dispose() {
        PlatformUI.getWorkbench().removeWorkbenchListener((IWorkbenchListener)this);
        super.dispose();
    }

    public abstract void integrate();

    public void cancelPressed() {
        EditorsHelper.closeEditor((IEditorPart)this, (boolean)false);
    }

    public List<IIntegrationEditorPage> getPages() {
        CTabFolder tabFolder = (CTabFolder)this.getContainer();
        return Arrays.stream(tabFolder.getItems()).map(Widget::getData).filter(IIntegrationEditorPage.class::isInstance).map(IIntegrationEditorPage.class::cast).collect(Collectors.toList());
    }

    public void updateDirty() {
        this.firePropertyChange(257);
    }
}

