/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.commons;

import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.fileaccess.api.RemoteInputStream;
import de.rcenvironment.core.datamanagement.commons.DataReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;

public class DistributableInputStream
extends InputStream
implements Serializable {
    private static final long serialVersionUID = 3334370872679358011L;
    private transient InputStream inputStream;
    private URI uriToInputStream;
    private RemoteInputStream remoteInputStream;

    public DistributableInputStream(DataReference dataRef, InputStream inputStream) {
        this.inputStream = inputStream;
        try {
            LogicalNodeId nodeId = dataRef.getStorageNodeId();
            this.uriToInputStream = new URI("rce://" + nodeId.getInstanceNodeIdString() + "/" + dataRef.getDataReferenceKey());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.inputStream != null) {
            return this.inputStream.read(b, off, len);
        }
        if (this.remoteInputStream == null) {
            this.remoteInputStream = new RemoteInputStream(this.uriToInputStream);
        }
        return this.remoteInputStream.read(b, off, len);
    }

    @Override
    public int read() throws IOException {
        if (this.inputStream != null) {
            return this.inputStream.read();
        }
        if (this.remoteInputStream == null) {
            this.remoteInputStream = new RemoteInputStream(this.uriToInputStream);
        }
        return this.remoteInputStream.read();
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.inputStream != null) {
            return this.inputStream.skip(n);
        }
        if (this.remoteInputStream == null) {
            this.remoteInputStream = new RemoteInputStream(this.uriToInputStream);
        }
        return this.remoteInputStream.skip(n);
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        } else {
            if (this.remoteInputStream == null) {
                this.remoteInputStream = new RemoteInputStream(this.uriToInputStream);
            }
            this.remoteInputStream.close();
        }
    }

    public InputStream getLocalInputStream() {
        return this.inputStream;
    }
}

