/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.internal;

import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.authorization.api.AuthorizationPermissionSet;
import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.authorization.api.DefaultAuthorizationObjects;
import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.AbstractCommandParameter;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandFlag;
import de.rcenvironment.core.command.spi.CommandModifierInfo;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.command.spi.ListCommandParameter;
import de.rcenvironment.core.command.spi.MainCommandDescription;
import de.rcenvironment.core.command.spi.ParsedCommandModifiers;
import de.rcenvironment.core.command.spi.ParsedListParameter;
import de.rcenvironment.core.command.spi.ParsedStringParameter;
import de.rcenvironment.core.command.spi.StringParameter;
import de.rcenvironment.core.command.spi.SubCommandDescription;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.api.UserComponentIdMappingService;
import de.rcenvironment.core.component.authorization.api.ComponentAuthorizationSelector;
import de.rcenvironment.core.component.authorization.api.NamedComponentAuthorizationSelector;
import de.rcenvironment.core.component.authorization.impl.ComponentAuthorizationSelectorImpl;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.management.api.LocalComponentRegistrationService;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinitionsProvider;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.core.utils.incubator.formatter.Alignments;
import de.rcenvironment.core.utils.incubator.formatter.ArrayBasedDataTable;
import de.rcenvironment.core.utils.incubator.formatter.DataTable;
import de.rcenvironment.core.utils.incubator.formatter.Formatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ComponentsCommandPlugin
implements CommandPlugin {
    private static final String ROOT_COMMAND = "components";
    private static final CommandFlag LOCAL_FLAG = new CommandFlag("-l", "--local", "only list components provided by the local node");
    private static final CommandFlag REMOTE_FLAG = new CommandFlag("-r", "--remote", "only list components provided by the remote node(s)");
    private static final CommandFlag AS_TABLE_FLAG = new CommandFlag("-t", "--as-table", "format the output as a table that is especially suited for automated parsing");
    private static final StringParameter COMPONENT_ID_PARAMETER = new StringParameter(null, "component id", "A component's id as listed by the \"components list\" command, e.g. \"rce/Parametric Study\", \"common/MyIntegratedTool\", or \"cpacs/MyCpacsTool\". ");
    private static final StringParameter GROUP_PARAMETER = new StringParameter(null, "group", "A comma-separated list of user-defined authorization groups to assign. This replaces any previously assigned groups. Note that the specified groups must have been created or imported beforehand; see the \"auth create\" and \"auth import\" commands for details. Instead of a list of groups, the special value \"public\" can be used to grant access to any user within the visible network, while \"local\" revokes any previously granted access by remote users.");
    private static final ListCommandParameter GROUPS_PARAMETER = new ListCommandParameter((AbstractCommandParameter)GROUP_PARAMETER, "groups", "list of authorization groups");
    private DistributedComponentKnowledgeService componentKnowledgeService;
    private LocalComponentRegistrationService componentRegistrationService;
    private AuthorizationService authorizationService;
    private DefaultAuthorizationObjects defaultAuthorizationObjects;
    private UserComponentIdMappingService userComponentIdMappingService;

    public MainCommandDescription[] getCommands() {
        MainCommandDescription commands = new MainCommandDescription(ROOT_COMMAND, "manage component publishing", "alias for \"components list\"", this::performComponentsList, new CommandModifierInfo(new CommandFlag[]{LOCAL_FLAG, REMOTE_FLAG, AS_TABLE_FLAG}), new SubCommandDescription[]{new SubCommandDescription("list", "show available components; by default, components on the local node as well as those published by a reachable remote node are listed", this::performComponentsList, new CommandModifierInfo(new CommandFlag[]{LOCAL_FLAG, REMOTE_FLAG, AS_TABLE_FLAG})), new SubCommandDescription("list-auth", "Shows a list of all defined authorization settings. Note that these settings are independent of whether a matching component exists, which means that settings are kept when a component is removed and later added again.", this::performListAuth), new SubCommandDescription("set-auth", "assigns a list of authorization groups to a component id; note that authorization settings always apply to all components with using this id, regardless of the component's version", this::performSetAuth, new CommandModifierInfo(new AbstractCommandParameter[]{COMPONENT_ID_PARAMETER, GROUPS_PARAMETER})), new SubCommandDescription("show", "Show component definition", this::performShow, new CommandModifierInfo(new AbstractCommandParameter[]{COMPONENT_ID_PARAMETER}))});
        return new MainCommandDescription[]{commands};
    }

    @Reference
    protected void bindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService newInstance) {
        this.componentKnowledgeService = newInstance;
    }

    @Reference
    protected void bindComponentRegistrationService(LocalComponentRegistrationService newInstance) {
        this.componentRegistrationService = newInstance;
    }

    @Reference
    protected void bindAuthorizationService(AuthorizationService newInstance) {
        this.authorizationService = newInstance;
        this.defaultAuthorizationObjects = newInstance.getDefaultAuthorizationObjects();
    }

    @Reference
    protected void bindUserComponentIdMappingService(UserComponentIdMappingService newInstance) {
        this.userComponentIdMappingService = newInstance;
    }

    private void performComponentsList(CommandContext context) throws CommandException {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        boolean localOnly = modifiers.hasCommandFlag("-l");
        boolean remoteOnly = modifiers.hasCommandFlag("-r");
        if (localOnly && remoteOnly) {
            throw CommandException.syntaxError((String)"Only one of --local and --remote can be selected", (CommandContext)context);
        }
        boolean includeAuthInformation = true;
        boolean asTable = modifiers.hasCommandFlag("-t");
        DistributedComponentKnowledge compKnowledge = this.componentKnowledgeService.getCurrentSnapshot();
        Collection<DistributedComponentEntry> installationSet = localOnly ? compKnowledge.getAllLocalInstallations() : (remoteOnly ? compKnowledge.getRemoteInstallations() : compKnowledge.getAllInstallations());
        if (installationSet.isEmpty()) {
            context.println((Object)"No components available.");
            return;
        }
        TreeMap components = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (DistributedComponentEntry entry : installationSet) {
            ComponentInstallation ci = entry.getComponentInstallation();
            if (components.get(ci.getNodeId()) == null) {
                components.put(ci.getNodeId(), new TreeMap(String.CASE_INSENSITIVE_ORDER));
            }
            ComponentInterface compInterface = ci.getComponentInterface();
            String component = String.valueOf(compInterface.getDisplayName()) + compInterface.getVersion();
            ((TreeMap)components.get(ci.getNodeId())).put(component, entry);
        }
        for (String nodeId : components.keySet()) {
            LogicalNodeId nodeIdObject = NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)nodeId);
            if (!asTable) {
                context.println((Object)StringUtils.format((String)"Components available on %s:", (Object[])new Object[]{nodeIdObject}));
            }
            for (DistributedComponentEntry entry : ((TreeMap)components.get(nodeId)).values()) {
                String externalComponentId;
                String authData;
                String authPatternPart;
                String nodePrefixPattern;
                String basePattern;
                String versionPart;
                ComponentInterface compInterface;
                block17: {
                    block16: {
                        ComponentInstallation ci = entry.getComponentInstallation();
                        compInterface = ci.getComponentInterface();
                        versionPart = compInterface.getVersion();
                        basePattern = !asTable ? "  %2$s" : "%2$s|%1$s|%3$s";
                        if ("".equals(versionPart)) {
                            versionPart = "--";
                        }
                        nodePrefixPattern = asTable ? "%5$s|%6$s|" : "";
                        if (!includeAuthInformation) break block16;
                        authPatternPart = !asTable ? " <%4$s>" : "|%4$s";
                        switch (entry.getType()) {
                            case LOCAL: {
                                authData = "local";
                                break block17;
                            }
                            case FORCED_LOCAL: {
                                authData = "local-only";
                                break block17;
                            }
                            case SHARED: {
                                authData = "shared:" + entry.getDeclaredPermissionSet().getSignature();
                                break block17;
                            }
                            case REMOTE: {
                                authData = "remote:" + entry.getDeclaredPermissionSet().getSignature();
                                break block17;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                    authPatternPart = "";
                    authData = "";
                }
                try {
                    externalComponentId = this.userComponentIdMappingService.fromInternalToExternalId(compInterface.getIdentifier());
                }
                catch (OperationFailureException operationFailureException) {
                    LogFactory.getLog(this.getClass()).warn((Object)("Failed to determine/generate external id for component " + compInterface.getIdentifier() + "; falling back to display name"));
                    externalComponentId = compInterface.getDisplayName();
                }
                context.println((Object)StringUtils.format((String)(String.valueOf(nodePrefixPattern) + basePattern + authPatternPart), (Object[])new Object[]{compInterface.getIdentifier(), externalComponentId, versionPart, authData, nodeIdObject.getAssociatedDisplayName(), nodeIdObject.getLogicalNodeIdString()}));
            }
        }
    }

    private void performSetAuth(CommandContext context) throws CommandException {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        String componentId = ((ParsedStringParameter)modifiers.getPositionalCommandParameter(0)).getResult();
        List authSetting = ((ParsedListParameter)modifiers.getPositionalCommandParameter(1)).getResult();
        String authSettingString = authSetting.stream().map(group -> (String)group.getResult()).collect(Collectors.joining(","));
        if (componentId.isEmpty() || !componentId.contains("/")) {
            throw CommandException.syntaxError((String)"Invalid component id", (CommandContext)context);
        }
        AuthorizationPermissionSet permissionSet = this.parsePermissionSetString(authSettingString, context);
        ComponentAuthorizationSelectorImpl selector = new ComponentAuthorizationSelectorImpl(componentId);
        this.componentRegistrationService.setComponentPermissions(selector, permissionSet);
        context.println((Object)StringUtils.format((String)"Set access authorization for component id \"%s\" to \"%s\"", (Object[])new Object[]{componentId, this.componentRegistrationService.getComponentPermissionSet(selector, true).getSignature()}));
    }

    private AuthorizationPermissionSet parsePermissionSetString(String authSetting, CommandContext context) throws CommandException {
        AuthorizationPermissionSet permissionSet;
        if ("local".equals(authSetting)) {
            permissionSet = this.defaultAuthorizationObjects.permissionSetLocalOnly();
        } else if ("public".equals(authSetting)) {
            permissionSet = this.defaultAuthorizationObjects.permissionSetPublicInLocalNetwork();
        } else {
            String[] groupIds = authSetting.split(",");
            ArrayList<AuthorizationAccessGroup> groupObjects = new ArrayList<AuthorizationAccessGroup>();
            String[] stringArray = groupIds;
            int n = groupIds.length;
            int n2 = 0;
            while (n2 < n) {
                String rawGroupId = stringArray[n2];
                String groupId = rawGroupId.trim();
                try {
                    AuthorizationAccessGroup group = this.authorizationService.findLocalGroupById(groupId);
                    if (group == null) {
                        throw CommandException.executionError((String)("There is no local group matching the id " + groupId), (CommandContext)context);
                    }
                    groupObjects.add(group);
                }
                catch (OperationFailureException e) {
                    throw CommandException.executionError((String)("Error assigning local group " + groupId + ": " + e.getMessage()), (CommandContext)context);
                }
                ++n2;
            }
            permissionSet = this.authorizationService.buildPermissionSet(groupObjects);
        }
        return permissionSet;
    }

    private void performListAuth(CommandContext context) {
        List externalSelectors = this.componentRegistrationService.listAuthorizationSelectorsForRemotableComponentsIncludingOrphans().stream().filter(selector -> !this.componentRegistrationService.getComponentPermissionSet((ComponentAuthorizationSelector)selector, true).isLocalOnly()).collect(Collectors.toList());
        if (externalSelectors.isEmpty()) {
            context.println((Object)"There are no external access permission(s)");
            return;
        }
        context.println((Object)StringUtils.format((String)"Found %d external access permission(s)", (Object[])new Object[]{externalSelectors.size()}));
        ArrayBasedDataTable outputTable = new ArrayBasedDataTable();
        outputTable.setAlignment(new Alignments[]{Alignments.LEFT, Alignments.LEFT, Alignments.LEFT});
        List<NamedComponentAuthorizationSelector> authorizationSelectorsWithoutOrphans = this.componentRegistrationService.listAuthorizationSelectorsForRemotableComponents();
        boolean allSelectorsAvailable = externalSelectors.stream().allMatch(authorizationSelectorsWithoutOrphans::contains);
        for (NamedComponentAuthorizationSelector selector2 : externalSelectors) {
            String externalId = selector2.getId();
            ArrayList<String> tableRow = new ArrayList<String>(Arrays.asList(externalId, this.componentRegistrationService.getComponentPermissionSet(selector2, true).getSignature()));
            if (!allSelectorsAvailable) {
                boolean selectorIsAvailable = authorizationSelectorsWithoutOrphans.contains(selector2);
                if (selectorIsAvailable) {
                    tableRow.add("");
                } else {
                    tableRow.add("not available");
                }
            }
            outputTable.addRow(tableRow.toArray(new String[0]));
        }
        StringBuilder[] stringBuilderArray = new Formatter().renderTable((DataTable)outputTable);
        int n = stringBuilderArray.length;
        int n2 = 0;
        while (n2 < n) {
            StringBuilder sb = stringBuilderArray[n2];
            context.println((Object)sb.toString());
            ++n2;
        }
    }

    private void performShow(CommandContext context) throws CommandException {
        String internalId;
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        ParsedStringParameter externalCompontentIdParamteter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(0);
        try {
            internalId = this.userComponentIdMappingService.fromExternalToInternalId(externalCompontentIdParamteter.getResult());
        }
        catch (OperationFailureException operationFailureException) {
            throw CommandException.executionError((String)StringUtils.format((String)"Failed to translate external ID '%s' into internal ID", (Object[])new Object[]{externalCompontentIdParamteter.getResult()}), (CommandContext)context);
        }
        Optional<DistributedComponentEntry> optionalComponentEntry = this.componentKnowledgeService.getCurrentSnapshot().getAllInstallations().stream().filter(entry -> entry.getComponentInterface().getIdentifier().equals(internalId)).findAny();
        if (!optionalComponentEntry.isPresent()) {
            throw CommandException.executionError((String)StringUtils.format((String)"No component with ID '%s' found", (Object[])new Object[]{externalCompontentIdParamteter.getResult()}), (CommandContext)context);
        }
        DistributedComponentEntry componentEntry = optionalComponentEntry.get();
        context.getOutputReceiver().addOutput(StringUtils.format((String)"External ID: %s", (Object[])new Object[]{externalCompontentIdParamteter.getResult()}));
        context.getOutputReceiver().addOutput(StringUtils.format((String)"Internal ID: %s", (Object[])new Object[]{internalId}));
        EndpointDefinitionsProvider inputDefinitionsProvider = componentEntry.getComponentInterface().getInputDefinitionsProvider();
        context.getOutputReceiver().addOutput("Static Inputs:");
        for (EndpointDefinition staticInputDefinition : inputDefinitionsProvider.getStaticEndpointDefinitions()) {
            context.getOutputReceiver().addOutput(this.inputDefinitionToString(staticInputDefinition));
        }
        context.getOutputReceiver().addOutput("Dynamic Inputs:");
        for (EndpointDefinition staticInputDefinition : inputDefinitionsProvider.getDynamicEndpointDefinitions()) {
            context.getOutputReceiver().addOutput(this.inputDefinitionToString(staticInputDefinition));
        }
        EndpointDefinitionsProvider outputDefinitionsProvider = componentEntry.getComponentInterface().getOutputDefinitionsProvider();
        context.getOutputReceiver().addOutput("Static Outputs:");
        for (EndpointDefinition staticOutputDefinition : outputDefinitionsProvider.getStaticEndpointDefinitions()) {
            context.getOutputReceiver().addOutput(this.outputDefinitionToString(staticOutputDefinition));
        }
        context.getOutputReceiver().addOutput("Dynamic Outputs:");
        for (EndpointDefinition staticOutputDefinition : outputDefinitionsProvider.getDynamicEndpointDefinitions()) {
            context.getOutputReceiver().addOutput(this.outputDefinitionToString(staticOutputDefinition));
        }
    }

    private String inputDefinitionToString(EndpointDefinition staticInputDefinition) {
        return String.join((CharSequence)"|", staticInputDefinition.getName(), staticInputDefinition.getDefaultDataType().toString(), this.listToTableCellEntry(staticInputDefinition.getPossibleDataTypes()), staticInputDefinition.getDefaultInputDatumHandling().toString(), this.listToTableCellEntry(staticInputDefinition.getInputDatumOptions()), staticInputDefinition.getDefaultInputExecutionConstraint().toString(), this.listToTableCellEntry(staticInputDefinition.getInputExecutionConstraintOptions()));
    }

    private String outputDefinitionToString(EndpointDefinition staticOutputDefinition) {
        return String.join((CharSequence)"|", staticOutputDefinition.getName(), staticOutputDefinition.getDefaultDataType().toString(), this.listToTableCellEntry(staticOutputDefinition.getPossibleDataTypes()));
    }

    private String listToTableCellEntry(List<? extends Object> list) {
        String listEntries = list.stream().map(Object::toString).collect(Collectors.joining(","));
        return StringUtils.format((String)"[%s]", (Object[])new Object[]{listEntries});
    }
}

