/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.documentation.internal;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.integration.ToolIntegrationService;
import de.rcenvironment.core.component.integration.documentation.RemoteToolIntegrationDocumentationService;
import de.rcenvironment.core.component.integration.documentation.ToolDocumentationProvider;
import de.rcenvironment.core.component.integration.documentation.ToolIntegrationDocumentationService;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.sshremoteaccess.SshRemoteAccessClientService;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.utils.common.FileCompressionFormat;
import de.rcenvironment.core.utils.common.FileCompressionService;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class ToolIntegrationDocumentationServiceImpl
implements ToolIntegrationDocumentationService,
RemoteToolIntegrationDocumentationService {
    protected static DistributedComponentKnowledgeService componentKnowledgeService;
    protected static CommunicationService communicationService;
    private static final String DE_RCENVIRONMENT_REMOTEACCESS = "de.rcenvironment.remoteaccess";
    private static final String METADATA_FILE_NAME = ".metadata";
    private static final String KEY_HASH = "hash";
    private static final String KEY_LAST_USED = "lastUsed";
    private static final String KEY_DOCUMENTATION_DIR_NAME = "documentationDir";
    private static final String CACHE_NAME = "toolDocCache";
    private static final Log LOGGER;
    private Map<String, Map<String, Map<String, String>>> toolDocumentationCache;
    private Map<String, ToolDocumentationProvider> toolDocProviderMap = new HashMap<String, ToolDocumentationProvider>();
    private ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
    private ConfigurationService configService;
    private SshRemoteAccessClientService sshClientService;
    @Reference
    private ToolIntegrationService toolIntegrationService;
    private final long time90Days = 7776000000L;

    static {
        LOGGER = LogFactory.getLog(ToolIntegrationDocumentationServiceImpl.class);
    }

    @Override
    public Map<String, String> getComponentDocumentationList(String identifier) {
        HashMap<String, String> docs = new HashMap<String, String>();
        for (DistributedComponentEntry entry : componentKnowledgeService.getCurrentSnapshot().getAllInstallations()) {
            ComponentInstallation ci = entry.getComponentInstallation();
            if (ci.getComponentInterface().getIdentifierAndVersion().equals(identifier) && !ci.getComponentInterface().getDocumentationHash().isEmpty()) {
                docs.put(ci.getComponentInterface().getDocumentationHash(), ci.getNodeId());
            }
            if (!ci.getComponentInterface().getIdentifierAndVersion().equals(identifier) || !identifier.startsWith(DE_RCENVIRONMENT_REMOTEACCESS)) continue;
            RemoteToolIntegrationDocumentationService rtis = (RemoteToolIntegrationDocumentationService)communicationService.getRemotableService(RemoteToolIntegrationDocumentationService.class, (NetworkDestination)NodeIdentifierUtils.parseLogicalNodeIdStringWithExceptionWrapping((String)ci.getNodeId()));
            try {
                Map<String, String> componentInstallationsWithDocumentation = rtis.getComponentDocumentationListForRemoteAccessTools(identifier);
                for (String hash : componentInstallationsWithDocumentation.keySet()) {
                    docs.put(hash, componentInstallationsWithDocumentation.get(hash));
                }
            }
            catch (RemoteOperationException e) {
                LOGGER.error((Object)"Could not retreive remote tool documenation: ", (Throwable)e);
            }
        }
        this.loadDocumentationCache();
        if (this.toolDocumentationCache.get(identifier) != null) {
            for (String nodeIdentifier : this.toolDocumentationCache.get(identifier).keySet()) {
                String hash = this.toolDocumentationCache.get(identifier).get(nodeIdentifier).get(KEY_HASH);
                if (docs.get(hash) == null || ((String)docs.get(hash)).isEmpty()) continue;
                docs.put(hash, String.valueOf(nodeIdentifier) + "(C)");
            }
        }
        return docs;
    }

    private File loadDocumentationCache() {
        File cacheDir = new File(this.configService.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_INTERNAL_DATA), CACHE_NAME);
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        if (this.toolDocumentationCache == null) {
            try {
                this.toolDocumentationCache = new TreeMap<String, Map<String, Map<String, String>>>();
                this.readToolDocumentationCache();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Could not read documentation cache: ", (Throwable)e);
                this.toolDocumentationCache = new TreeMap<String, Map<String, Map<String, String>>>();
            }
        }
        return cacheDir;
    }

    @Override
    public File getToolDocumentation(String identifier, String nodeId, String hashValue) throws FileNotFoundException, IOException, RemoteOperationException {
        File cacheDir = this.loadDocumentationCache();
        String documentationNodeId = nodeId.endsWith("(C)") ? nodeId.substring(0, nodeId.length() - 3) : nodeId;
        if (this.toolDocumentationCache.get(identifier) != null && this.toolDocumentationCache.get(identifier).get(documentationNodeId) != null && this.toolDocumentationCache.get(identifier).get(documentationNodeId).get(KEY_HASH).equals(hashValue)) {
            File docuDir = new File(cacheDir, this.toolDocumentationCache.get(identifier).get(documentationNodeId).get(KEY_DOCUMENTATION_DIR_NAME));
            this.toolDocumentationCache.get(identifier).get(documentationNodeId).put(KEY_LAST_USED, String.valueOf(System.currentTimeMillis()));
            return docuDir;
        }
        RemoteToolIntegrationDocumentationService rtis = (RemoteToolIntegrationDocumentationService)communicationService.getRemotableService(RemoteToolIntegrationDocumentationService.class, (NetworkDestination)NodeIdentifierUtils.parseLogicalNodeIdStringWithExceptionWrapping((String)documentationNodeId));
        byte[] documentation = rtis.loadToolDocumentation(identifier, nodeId, hashValue);
        if (documentation == null && identifier.startsWith(DE_RCENVIRONMENT_REMOTEACCESS)) {
            this.sshClientService.downloadToolDocumentation(identifier, documentationNodeId, hashValue);
        }
        if (documentation != null) {
            File tempDir = this.findFirstUnusedDirectory(cacheDir);
            tempDir.mkdirs();
            if (!FileCompressionService.expandCompressedDirectoryFromByteArray((byte[])documentation, (File)tempDir, (FileCompressionFormat)FileCompressionFormat.ZIP).booleanValue()) {
                LOGGER.error((Object)"Was not able to retrieve the tool documentation due to an issue with the archive expansion.");
                throw new IOException("Was not able to retrive the tool documentation due to an issue with the archive expansion.");
            }
            HashMap nodeIDMap = new HashMap();
            HashMap<String, String> values = new HashMap<String, String>();
            values.put(KEY_DOCUMENTATION_DIR_NAME, tempDir.getName());
            values.put(KEY_HASH, hashValue);
            values.put(KEY_LAST_USED, String.valueOf(System.currentTimeMillis()));
            nodeIDMap.put(documentationNodeId, values);
            this.toolDocumentationCache.put(identifier, nodeIDMap);
            this.mapper.writerWithDefaultPrettyPrinter().writeValue(new File(cacheDir, METADATA_FILE_NAME), this.toolDocumentationCache);
            return tempDir;
        }
        return null;
    }

    private File findFirstUnusedDirectory(File cacheDir) {
        long i = 0L;
        File tmpFile = new File(cacheDir, String.valueOf(i));
        while (tmpFile.exists() && tmpFile.isDirectory()) {
            tmpFile = new File(cacheDir, String.valueOf(++i));
        }
        return tmpFile;
    }

    private void readToolDocumentationCache() throws JsonParseException, JsonMappingException, IOException {
        File metadataFile;
        File cacheDir = new File(this.configService.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_INTERNAL_DATA), CACHE_NAME);
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        if ((metadataFile = new File(cacheDir, METADATA_FILE_NAME)).exists()) {
            this.mapper.readValue(metadataFile, this.toolDocumentationCache.getClass());
            HashSet<String> toolIdsToRemove = new HashSet<String>();
            for (String toolID : this.toolDocumentationCache.keySet()) {
                HashSet<String> nodeIdsToRemove = new HashSet<String>();
                for (String nodeId : this.toolDocumentationCache.get(toolID).keySet()) {
                    this.checkDocuDirectory(cacheDir, toolID, nodeIdsToRemove, nodeId);
                }
                for (String id : nodeIdsToRemove) {
                    this.toolDocumentationCache.get(toolID).remove(id);
                }
                if (!this.toolDocumentationCache.get(toolID).isEmpty()) continue;
                toolIdsToRemove.add(toolID);
            }
            for (String id : toolIdsToRemove) {
                this.toolDocumentationCache.remove(id);
            }
        }
        this.mapper.writerWithDefaultPrettyPrinter().writeValue(metadataFile, this.toolDocumentationCache);
    }

    private void checkDocuDirectory(File cacheDir, String toolID, Set<String> nodeIdsToRemove, String nodeId) throws IOException {
        if (this.toolDocumentationCache.get(toolID).get(nodeId).get(KEY_DOCUMENTATION_DIR_NAME) != null) {
            File docDir = new File(cacheDir, this.toolDocumentationCache.get(toolID).get(nodeId).get(KEY_DOCUMENTATION_DIR_NAME));
            if (!docDir.exists() || !docDir.isDirectory()) {
                nodeIdsToRemove.add(nodeId);
            }
            if (this.toolDocumentationCache.get(toolID).get(nodeId).get(KEY_LAST_USED) != null) {
                long lastUsed = Long.parseLong(this.toolDocumentationCache.get(toolID).get(nodeId).get(KEY_LAST_USED));
                if (System.currentTimeMillis() - lastUsed > 7776000000L) {
                    nodeIdsToRemove.add(nodeId);
                    if (docDir.exists()) {
                        FileUtils.deleteDirectory((File)docDir);
                    }
                }
            }
        }
    }

    @Reference
    public void bindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService incoming) {
        componentKnowledgeService = incoming;
    }

    protected void unbindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService incoming) {
        componentKnowledgeService = null;
    }

    @Reference
    public void bindCommunicationService(CommunicationService incoming) {
        communicationService = incoming;
    }

    protected void unbindCommunicationService(CommunicationService incoming) {
        communicationService = null;
    }

    @Reference
    public void bindConfigurationService(ConfigurationService incoming) {
        this.configService = incoming;
    }

    protected void unbindConfigurationService(ConfigurationService incoming) {
        this.configService = null;
    }

    @Reference
    public void bindSshRemoteAccessClientService(SshRemoteAccessClientService incoming) {
        this.sshClientService = incoming;
    }

    @Reference
    public void bindToolIntegrationService(ToolIntegrationService incoming) {
        this.toolIntegrationService = incoming;
    }

    @Override
    @AllowRemoteAccess
    public byte[] loadToolDocumentation(String identifier, String nodeId, String hashValue) throws RemoteOperationException {
        LogicalNodeId nodeIdObj;
        try {
            nodeIdObj = NodeIdentifierUtils.parseLogicalNodeIdString((String)nodeId);
        }
        catch (IdentifierException e) {
            throw new RemoteOperationException("Failed to parse logical node id: " + e.getMessage());
        }
        byte[] documentation = null;
        if (nodeIdObj.getLogicalNodePart().equals("0")) {
            documentation = this.toolIntegrationService.getToolDocumentation(identifier);
        } else if (identifier.startsWith(DE_RCENVIRONMENT_REMOTEACCESS)) {
            File documentationDir = this.sshClientService.downloadToolDocumentation(identifier, nodeId, hashValue);
            documentation = FileCompressionService.compressDirectoryToByteArray((File)documentationDir, (FileCompressionFormat)FileCompressionFormat.ZIP, (Boolean)false);
        } else {
            ToolDocumentationProvider toolDocumentationProvider = this.toolDocProviderMap.get(nodeId);
            if (toolDocumentationProvider != null) {
                try {
                    documentation = toolDocumentationProvider.provideToolDocumentation(identifier, nodeId, hashValue);
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Error retrieving documentation", (Throwable)e);
                    return null;
                }
            }
        }
        return documentation;
    }

    @Override
    @AllowRemoteAccess
    public Map<String, String> getComponentDocumentationListForRemoteAccessTools(String identifier) throws RemoteOperationException {
        Map componentInstallationsWithDocumentation = this.sshClientService.getListOfToolsWithDocumentation(identifier);
        return componentInstallationsWithDocumentation;
    }

    @Override
    public void registerToolDocumentationProvider(ToolDocumentationProvider provider, String nodeId) {
        this.toolDocProviderMap.put(nodeId, provider);
    }
}

