/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.testutils;

import de.rcenvironment.core.communication.channel.MessageChannelLifecycleListener;
import de.rcenvironment.core.communication.channel.MessageChannelTrafficListener;
import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.testutils.CommonVirtualInstanceControl;
import de.rcenvironment.core.communication.testutils.VirtualInstance;
import de.rcenvironment.core.communication.testutils.VirtualInstanceState;
import de.rcenvironment.core.communication.transport.spi.NetworkTransportProvider;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.CallablesGroup;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.concurrent.Callable;

public class VirtualInstanceGroup
implements CommonVirtualInstanceControl {
    private CommonVirtualInstanceControl[] instances;

    public VirtualInstanceGroup(CommonVirtualInstanceControl ... instances) {
        this.instances = instances;
    }

    @Override
    public void setTargetState(final VirtualInstanceState state) throws InterruptedException {
        CallablesGroup callablesGroup = ConcurrencyUtils.getFactory().createCallablesGroup(Void.class);
        CommonVirtualInstanceControl[] commonVirtualInstanceControlArray = this.instances;
        int n = this.instances.length;
        int n2 = 0;
        while (n2 < n) {
            final CommonVirtualInstanceControl instance = commonVirtualInstanceControlArray[n2];
            callablesGroup.add((Callable)new Callable<Void>(){

                @Override
                @TaskDescription(value="Set individual target states in a virtual instance group")
                public Void call() throws Exception {
                    instance.setTargetState(state);
                    return null;
                }
            });
            ++n2;
        }
        callablesGroup.executeParallel(null);
    }

    @Override
    public void waitForStateChangesToFinish() throws InterruptedException {
        CommonVirtualInstanceControl[] commonVirtualInstanceControlArray = this.instances;
        int n = this.instances.length;
        int n2 = 0;
        while (n2 < n) {
            CommonVirtualInstanceControl instance = commonVirtualInstanceControlArray[n2];
            instance.waitForStateChangesToFinish();
            ++n2;
        }
    }

    @Override
    public void start() throws InterruptedException {
        this.setTargetState(VirtualInstanceState.STARTED);
        this.waitForStateChangesToFinish();
    }

    @Override
    public void simulateCrash() throws InterruptedException {
        this.setTargetState(VirtualInstanceState.SIMULATED_CRASHING);
        this.waitForStateChangesToFinish();
    }

    @Override
    public void shutDown() throws InterruptedException {
        this.setTargetState(VirtualInstanceState.STOPPED);
        this.waitForStateChangesToFinish();
    }

    @Override
    public void registerNetworkTransportProvider(NetworkTransportProvider provider) {
        CommonVirtualInstanceControl[] commonVirtualInstanceControlArray = this.instances;
        int n = this.instances.length;
        int n2 = 0;
        while (n2 < n) {
            CommonVirtualInstanceControl instance = commonVirtualInstanceControlArray[n2];
            instance.registerNetworkTransportProvider(provider);
            ++n2;
        }
    }

    @Override
    public void simulateCustomProtocolVersion(String version) {
        CommonVirtualInstanceControl[] commonVirtualInstanceControlArray = this.instances;
        int n = this.instances.length;
        int n2 = 0;
        while (n2 < n) {
            CommonVirtualInstanceControl instance = commonVirtualInstanceControlArray[n2];
            instance.simulateCustomProtocolVersion(version);
            ++n2;
        }
    }

    @Override
    public void addInitialNetworkPeer(NetworkContactPoint contactPoint) {
        CommonVirtualInstanceControl[] commonVirtualInstanceControlArray = this.instances;
        int n = this.instances.length;
        int n2 = 0;
        while (n2 < n) {
            CommonVirtualInstanceControl instance = commonVirtualInstanceControlArray[n2];
            instance.addInitialNetworkPeer(contactPoint);
            ++n2;
        }
    }

    @Override
    public void addNetworkConnectionListener(MessageChannelLifecycleListener listener) {
        CommonVirtualInstanceControl[] commonVirtualInstanceControlArray = this.instances;
        int n = this.instances.length;
        int n2 = 0;
        while (n2 < n) {
            CommonVirtualInstanceControl instance = commonVirtualInstanceControlArray[n2];
            instance.addNetworkConnectionListener(listener);
            ++n2;
        }
    }

    @Override
    public void addNetworkTrafficListener(MessageChannelTrafficListener listener) {
        CommonVirtualInstanceControl[] commonVirtualInstanceControlArray = this.instances;
        int n = this.instances.length;
        int n2 = 0;
        while (n2 < n) {
            CommonVirtualInstanceControl instance = commonVirtualInstanceControlArray[n2];
            instance.addNetworkTrafficListener(listener);
            ++n2;
        }
    }

    public VirtualInstance[] toArray() {
        VirtualInstance[] result = new VirtualInstance[this.instances.length];
        int i = 0;
        CommonVirtualInstanceControl[] commonVirtualInstanceControlArray = this.instances;
        int n = this.instances.length;
        int n2 = 0;
        while (n2 < n) {
            CommonVirtualInstanceControl instance = commonVirtualInstanceControlArray[n2];
            result[i++] = (VirtualInstance)instance;
            ++n2;
        }
        return result;
    }
}

