/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.testutils;

import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.InstanceNodeId;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.communication.common.impl.NodeIdentifierServiceImpl;
import de.rcenvironment.core.communication.configuration.CommunicationIPFilterConfiguration;
import de.rcenvironment.core.communication.configuration.NodeConfigurationService;
import de.rcenvironment.core.communication.model.InitialNodeInformation;
import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.model.impl.InitialNodeInformationImpl;
import de.rcenvironment.core.communication.sshconnection.InitialSshConnectionConfig;
import de.rcenvironment.core.communication.sshconnection.InitialUplinkConnectionConfig;
import de.rcenvironment.toolkit.utils.common.IdGeneratorType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public class NodeConfigurationServiceTestStub
implements NodeConfigurationService {
    private static final long TEST_INSTANCES_INITIAL_CONNECT_DELAY_MSEC = 300L;
    private final InstanceNodeSessionId localInstanceSessionId;
    private final InitialNodeInformationImpl localNodeInformation;
    private final List<NetworkContactPoint> serverContactPoints;
    private final List<NetworkContactPoint> initialNetworkPeers;
    private final boolean isRelay;
    private NodeIdentifierServiceImpl nodeIdentifierService = new NodeIdentifierServiceImpl(IdGeneratorType.FAST);

    public NodeConfigurationServiceTestStub(String predefinedInstanceId, String displayName, boolean isRelay) {
        InstanceNodeId localInstanceId;
        if (predefinedInstanceId != null) {
            try {
                localInstanceId = this.nodeIdentifierService.parseInstanceNodeIdString(predefinedInstanceId);
            }
            catch (IdentifierException e) {
                throw NodeIdentifierUtils.wrapIdentifierException(e);
            }
        } else {
            localInstanceId = this.nodeIdentifierService.generateInstanceNodeId();
        }
        this.localInstanceSessionId = this.nodeIdentifierService.generateInstanceNodeSessionId(localInstanceId);
        LogFactory.getLog(this.getClass()).debug((Object)("Created instance session id " + this.localInstanceSessionId + " for provided instance id"));
        this.localNodeInformation = new InitialNodeInformationImpl(this.localInstanceSessionId);
        this.localNodeInformation.setDisplayName(displayName);
        this.serverContactPoints = new ArrayList<NetworkContactPoint>();
        this.initialNetworkPeers = new ArrayList<NetworkContactPoint>();
        this.isRelay = isRelay;
    }

    @Override
    public NodeIdentifierServiceImpl getNodeIdentifierService() {
        return this.nodeIdentifierService;
    }

    @Override
    public InstanceNodeSessionId getInstanceNodeSessionId() {
        return this.localInstanceSessionId;
    }

    @Override
    @Deprecated
    public boolean isWorkflowHost() {
        return false;
    }

    @Override
    public InitialNodeInformation getInitialNodeInformation() {
        return this.localNodeInformation;
    }

    @Override
    public List<NetworkContactPoint> getServerContactPoints() {
        return this.serverContactPoints;
    }

    @Override
    public List<NetworkContactPoint> getInitialNetworkContactPoints() {
        return this.initialNetworkPeers;
    }

    @Override
    public boolean isRelay() {
        return this.isRelay;
    }

    @Override
    public long getDelayBeforeStartupConnectAttempts() {
        return 300L;
    }

    @Override
    public int getRequestTimeoutMsec() {
        return 40000;
    }

    @Override
    public int getForwardingTimeoutMsec() {
        return 35000;
    }

    public void addServerConfigurationEntry(NetworkContactPoint contactPoint) {
        this.serverContactPoints.add(contactPoint);
    }

    public void addInitialNetworkPeer(NetworkContactPoint contactPoint) {
        this.initialNetworkPeers.add(contactPoint);
    }

    @Override
    public CommunicationIPFilterConfiguration getIPFilterConfiguration() {
        return new CommunicationIPFilterConfiguration();
    }

    @Override
    public List<InitialSshConnectionConfig> getInitialSSHConnectionConfigs() {
        return null;
    }

    @Override
    public double[] getLocationCoordinates() {
        return new double[]{0.0, 0.0};
    }

    @Override
    public String getLocationName() {
        return "";
    }

    @Override
    public String getInstanceContact() {
        return "";
    }

    @Override
    public String getInstanceAdditionalInformation() {
        return "";
    }

    @Override
    public List<InitialUplinkConnectionConfig> getInitialUplinkConnectionConfigs() {
        return null;
    }

    @Override
    public File getStandardImportDirectory(String subdir) {
        return null;
    }
}

