/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.model.internal;

import de.rcenvironment.core.communication.common.CommonIdBase;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.LogicalNodeSessionId;
import de.rcenvironment.core.communication.common.impl.NodeIdentifierImpl;
import de.rcenvironment.core.communication.common.impl.NodeNameDataHolder;
import de.rcenvironment.core.communication.model.NodeInformationRegistry;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodeInformationRegistryImpl
implements NodeInformationRegistry {
    private static final String LOG_PATTERN_CREATING_INITIAL_SESSION_DATA_HOLDER = "Creating initial name data holder for %s";
    private static final String LOG_PATTERN_REPLACING_SESSION_DATA_HOLDER = "Discarding name data for session %s as it will be replaced by session %s";
    private static final String LOG_PATTERN_SETTING_NAME_ASSOCIATION = "Setting initial name '%s' for session %s";
    private static final String LOG_PATTERN_REPLACING_NAME_ASSOCIATION = "Replacing name '%s' for session %s with '%s'";
    private static final String LOG_PATTERN_IGNORING_DUPLICATE_NAMING_REQUEST = "Ignoring request to set the name '%s' for %s again";
    private static final String LOG_PATTERN_IGNORING_NAME_CHANGE_FOR_NON_CURRENT_SESSION = "Ignoring name change request '%s' for non-current session %s";
    private final Map<String, InstanceSessionData> currentSessionDataByInstanceId = new HashMap<String, InstanceSessionData>();
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public synchronized boolean associateDisplayName(InstanceNodeSessionId id, String newName) {
        InstanceSessionData currentSessionData = this.getOrReplaceCurrentSessionDataForInstance(id);
        String fullIdString = id.getInstanceNodeSessionIdString();
        if (!currentSessionData.matchesSessionIdOf(id)) {
            this.log.debug((Object)StringUtils.format((String)LOG_PATTERN_IGNORING_NAME_CHANGE_FOR_NON_CURRENT_SESSION, (Object[])new Object[]{newName, fullIdString}));
            return false;
        }
        NodeNameDataHolder oldNameHolder = currentSessionData.sessionNameDataHolder;
        if (oldNameHolder == null) {
            this.log.debug((Object)StringUtils.format((String)LOG_PATTERN_SETTING_NAME_ASSOCIATION, (Object[])new Object[]{newName, fullIdString}));
        } else {
            String oldName = oldNameHolder.getResolvedName();
            if (!newName.equals(oldName)) {
                this.log.debug((Object)StringUtils.format((String)LOG_PATTERN_REPLACING_NAME_ASSOCIATION, (Object[])new Object[]{oldName, fullIdString, newName}));
            } else {
                this.log.debug((Object)StringUtils.format((String)LOG_PATTERN_IGNORING_DUPLICATE_NAMING_REQUEST, (Object[])new Object[]{newName, fullIdString}));
                return false;
            }
        }
        currentSessionData.setInstanceSessionNameHolder(new NodeNameDataHolder(newName));
        return true;
    }

    @Override
    public synchronized boolean associateDisplayNameWithLogicalNode(LogicalNodeSessionId id, String newName) {
        InstanceSessionData currentSessionData = this.getOrReplaceCurrentSessionDataForInstance(id.convertToInstanceNodeSessionId());
        String fullIdString = id.getLogicalNodeSessionIdString();
        if (!currentSessionData.matchesSessionIdOf(id)) {
            this.log.debug((Object)StringUtils.format((String)LOG_PATTERN_IGNORING_NAME_CHANGE_FOR_NON_CURRENT_SESSION, (Object[])new Object[]{newName, fullIdString}));
            return false;
        }
        currentSessionData.setOrRemoveLogicalNodeName(id.getLogicalNodePart(), newName);
        return true;
    }

    @Override
    public synchronized String getDisplayNameForNodeId(NodeIdentifierImpl nodeId, boolean replaceNullWithDefaultName) {
        InstanceSessionData instanceSessionData = this.currentSessionDataByInstanceId.get(nodeId.getInstanceNodeIdString());
        if (instanceSessionData == null) {
            if (replaceNullWithDefaultName) {
                return "<unknown>";
            }
            return null;
        }
        Optional<NodeNameDataHolder> lookupResult = instanceSessionData.getMostSpecificNameHolder(nodeId);
        if (lookupResult.isPresent()) {
            NodeNameDataHolder nameHolder = lookupResult.get();
            if (nameHolder.isResolved()) {
                return nameHolder.getResolvedName();
            }
            return "<not resolved yet>";
        }
        if (replaceNullWithDefaultName) {
            return "<unknown>";
        }
        return null;
    }

    @Override
    public synchronized void printAllNameAssociations(PrintStream output, String introText) {
        if (introText != null) {
            output.println(introText);
        }
        TreeMap<String, InstanceSessionData> sortedSnapshot = new TreeMap<String, InstanceSessionData>(this.currentSessionDataByInstanceId);
        for (Map.Entry entry : sortedSnapshot.entrySet()) {
            String stringValue = ((InstanceSessionData)entry.getValue()).sessionNameDataHolder.getResolvedName();
            if (stringValue != null) {
                output.println(StringUtils.format((String)"  %s -> \"%s\"", (Object[])new Object[]{entry.getKey(), stringValue}));
                continue;
            }
            output.println(StringUtils.format((String)"  %s -> <null>", (Object[])new Object[]{entry.getKey()}));
        }
    }

    private InstanceSessionData getOrReplaceCurrentSessionDataForInstance(InstanceNodeSessionId id) {
        String instanceNodeIdString = id.getInstanceNodeIdString();
        InstanceSessionData currentSessionData = this.currentSessionDataByInstanceId.get(instanceNodeIdString);
        if (currentSessionData == null || currentSessionData.isObsoletedBy(id)) {
            if (currentSessionData == null) {
                this.log.debug((Object)StringUtils.format((String)LOG_PATTERN_CREATING_INITIAL_SESSION_DATA_HOLDER, (Object[])new Object[]{id.getInstanceNodeSessionIdString()}));
            } else {
                this.log.debug((Object)StringUtils.format((String)LOG_PATTERN_REPLACING_SESSION_DATA_HOLDER, (Object[])new Object[]{currentSessionData.sessionId, id.getSessionIdPart()}));
            }
            currentSessionData = new InstanceSessionData(id);
            this.currentSessionDataByInstanceId.put(instanceNodeIdString, currentSessionData);
        }
        return currentSessionData;
    }

    private final class InstanceSessionData {
        private final InstanceNodeSessionId sessionId;
        private final String sessionIdPart;
        private final Map<String, NodeNameDataHolder> logicalNodeNames = new HashMap<String, NodeNameDataHolder>();
        private NodeNameDataHolder sessionNameDataHolder;

        InstanceSessionData(InstanceNodeSessionId sessionId) {
            this.sessionId = sessionId;
            this.sessionIdPart = sessionId.getSessionIdPart();
        }

        public boolean matchesSessionIdOf(CommonIdBase id) {
            NodeIdentifierImpl idImpl = (NodeIdentifierImpl)id;
            String sessionIdPartOfParam = idImpl.getSessionIdPart();
            if (this.sessionIdPart == null || sessionIdPartOfParam == null) {
                return false;
            }
            return this.sessionIdPart.equals(sessionIdPartOfParam);
        }

        public boolean isObsoletedBy(InstanceNodeSessionId sessionIdParam) {
            return sessionIdParam.getSessionIdPart().compareTo(this.sessionIdPart) > 0;
        }

        public void setInstanceSessionNameHolder(NodeNameDataHolder dataHolder) {
            this.sessionNameDataHolder = dataHolder;
        }

        public void setOrRemoveLogicalNodeName(String logicalNodePart, String newName) {
            if (newName != null) {
                this.logicalNodeNames.put(logicalNodePart, new NodeNameDataHolder(newName));
            } else {
                this.logicalNodeNames.remove(logicalNodePart);
            }
        }

        public Optional<NodeNameDataHolder> getMostSpecificNameHolder(NodeIdentifierImpl nodeId) {
            NodeNameDataHolder specificNameHolder;
            String logicalNodePart = nodeId.getLogicalNodePart();
            if (logicalNodePart != null && !logicalNodePart.equals("0") && (specificNameHolder = this.logicalNodeNames.get(logicalNodePart)) != null) {
                return Optional.of(specificNameHolder);
            }
            switch (nodeId.getType()) {
                case INSTANCE_NODE_ID: 
                case LOGICAL_NODE_ID: {
                    return Optional.ofNullable(this.sessionNameDataHolder);
                }
                case INSTANCE_NODE_SESSION_ID: 
                case LOGICAL_NODE_SESSION_ID: {
                    String requestedSessionIdPart = nodeId.getSessionIdPart();
                    if (requestedSessionIdPart.compareTo(this.sessionIdPart) >= 0) {
                        return Optional.ofNullable(this.sessionNameDataHolder);
                    }
                    String currentSessionName = this.sessionNameDataHolder != null ? this.sessionNameDataHolder.getResolvedName() : "<unknown>";
                    return Optional.of(new NodeNameDataHolder(String.valueOf(currentSessionName) + " <outdated session>"));
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

