/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.session.internal;

import de.rcenvironment.core.communication.uplink.common.internal.MessageType;
import de.rcenvironment.core.communication.uplink.network.api.MessageBlockPriority;
import de.rcenvironment.core.communication.uplink.network.internal.CommonUplinkLowLevelProtocolWrapper;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlockWithMetadata;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkConnectionRefusedException;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkProtocolConfiguration;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkProtocolErrorType;
import de.rcenvironment.core.communication.uplink.session.api.UplinkSession;
import de.rcenvironment.core.communication.uplink.session.api.UplinkSessionState;
import de.rcenvironment.core.communication.uplink.session.internal.BoundedMessageBlockPrioritizer;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedExecutionQueue;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.ConcurrencyUtilsFactory;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractUplinkSessionImpl
implements UplinkSession {
    protected static final String UNDEFINED_CLIENT_VERSION_PLACEHOLDER = "<undefined>";
    private static final int VERY_SHORT_WAIT_MSEC = 50;
    private static final int GOODBYE_CONFIRMATION_WAIT_TIMEOUT_MSEC = 10000;
    private static final String LOG_SLASH = "/";
    private static final boolean DEBUG_OUTPUT_ENABLED = DebugSettings.getVerboseLoggingEnabled((String)"uplink.sessions");
    protected final AsyncOrderedExecutionQueue incomingProcessingQueue;
    protected final AsyncOrderedExecutionQueue outgoingProcessingQueue;
    protected final UplinkSessionStateHolder sessionState = new UplinkSessionStateHolder();
    protected String logPrefix;
    protected final Log log = LogFactory.getLog(this.getClass());
    private final BoundedMessageBlockPrioritizer boundedMessageOutbox = new BoundedMessageBlockPrioritizer();
    private final AsyncTaskService asyncTaskService = ConcurrencyUtils.getAsyncTaskService();

    protected AbstractUplinkSessionImpl(ConcurrencyUtilsFactory concurrencyUtilsFactory) {
        Objects.requireNonNull(concurrencyUtilsFactory);
        this.incomingProcessingQueue = concurrencyUtilsFactory.createAsyncOrderedExecutionQueue(AsyncCallbackExceptionPolicy.LOG_AND_PROCEED);
        this.outgoingProcessingQueue = concurrencyUtilsFactory.createAsyncOrderedExecutionQueue(AsyncCallbackExceptionPolicy.LOG_AND_PROCEED);
    }

    protected abstract void onTerminalStateReached(UplinkSessionState var1, Optional<UplinkProtocolErrorType> var2);

    @Override
    public UplinkSessionState getState() {
        return this.sessionState.getMainState();
    }

    @Override
    public boolean isShuttingDownOrShutDown() {
        return this.sessionState.isShuttingDownOrShutDown();
    }

    @Override
    public final void enqueueMessageBlockForSending(long channelId, MessageBlock messageBlock, MessageBlockPriority priority, boolean allowBlocking) throws ProtocolException {
        if (DEBUG_OUTPUT_ENABLED) {
            this.log.debug((Object)StringUtils.format((String)"%sEnqueuing message of type %s for sending to channel %d with priority %s, payload size %d bytes", (Object[])new Object[]{this.logPrefix, messageBlock.getType(), channelId, priority.name(), messageBlock.getDataLength()}));
        }
        MessageBlockWithMetadata wrappedMessage = new MessageBlockWithMetadata(messageBlock, channelId, priority);
        try {
            if (allowBlocking) {
                this.boundedMessageOutbox.submitOrBlock(wrappedMessage, this.logPrefix);
            } else {
                try {
                    this.boundedMessageOutbox.submitOrFail(wrappedMessage, this.logPrefix);
                }
                catch (OperationFailureException e) {
                    this.log.error((Object)(String.valueOf(this.logPrefix) + "Terminating session after overflow of outgoing message queue of priority level " + wrappedMessage.getPriority().name() + " (typically caused by extremely slow or interrupted client connections): " + e.getMessage()));
                    this.initiateUncleanShutdownIfStillRunning();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            this.log.warn((Object)(String.valueOf(this.logPrefix) + "Interrupted while waiting to enqueue a message of type " + (Object)((Object)messageBlock.getType())));
            return;
        }
        this.outgoingProcessingQueue.enqueue(this::sendNextMessageByPriority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void initiateCleanShutdownIfRunning() {
        UplinkSessionStateHolder uplinkSessionStateHolder = this.sessionState;
        synchronized (uplinkSessionStateHolder) {
            if (!this.sessionState.isShuttingDownOrShutDown()) {
                this.initiateCleanShutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void handleRegularRemoteGoodbyeMessage() {
        UplinkSessionStateHolder uplinkSessionStateHolder = this.sessionState;
        synchronized (uplinkSessionStateHolder) {
            if (this.sessionState.getRemoteSideHasSentGoodbye()) {
                this.log.error((Object)(String.valueOf(this.logPrefix) + "Protocol error: Received more than one 'goodbye' message from remote side"));
                return;
            }
            this.sessionState.markRemoteSideHasSentGoodbye();
            switch (this.sessionState.getMainState()) {
                case GOODBYE_HANDSHAKE: {
                    this.log.debug((Object)(String.valueOf(this.logPrefix) + "Received 'goodbye' message from remote side, initiating clean shutdown"));
                    this.initiateCleanShutdown();
                    break;
                }
                case GOODBYE_HANDSHAKE_COMPLETE: {
                    this.log.debug((Object)(String.valueOf(this.logPrefix) + "Received 'goodbye' confirmation from remote side, closing stream"));
                    this.asyncTaskService.execute("Close outgoing Uplink stream after goodbye handshake", () -> {
                        this.getLowLevelProtocolWrapper().terminateSession();
                        this.sessionState.markOutgoingStreamClosed();
                    });
                    break;
                }
                case CLEAN_SHUTDOWN: 
                case UNCLEAN_SHUTDOWN_INITIATED: 
                case UNCLEAN_SHUTDOWN: {
                    this.log.debug((Object)(String.valueOf(this.logPrefix) + "Ignoring redundant 'goodbye' message as the session is already in state " + (Object)((Object)this.sessionState.getMainState())));
                    break;
                }
                default: {
                    this.log.debug((Object)(String.valueOf(this.logPrefix) + "Unhandled state after receiving a 'goodbye' message: " + (Object)((Object)this.sessionState.getMainState())));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void handleIncomingStreamClosedOrEOF() {
        UplinkSessionStateHolder uplinkSessionStateHolder = this.sessionState;
        synchronized (uplinkSessionStateHolder) {
            this.sessionState.markIncomingStreamClosedOrEOF();
        }
    }

    @Override
    public final boolean isActive() {
        return this.sessionState.getMainState() == UplinkSessionState.ACTIVE;
    }

    @Override
    public final String getAssignedNamespaceId() {
        return this.sessionState.getAssignedNamespaceId();
    }

    @Override
    public final Optional<String> getAssignedNamespaceIdIfAvailable() {
        return this.sessionState.getAssignedNamespaceIdIfAvailable();
    }

    @Override
    public final String getLogDescriptor() {
        return this.sessionState.logDescriptor;
    }

    @Override
    public final String getDestinationIdPrefix() {
        return this.getAssignedNamespaceId();
    }

    public final String toString() {
        return this.getLogDescriptor();
    }

    protected final void markClientHandshakeSentOrReceived() {
        this.sessionState.markClientHandshakeSentOrReceived();
    }

    protected final void markServerHandshakeSentOrReceived() {
        this.sessionState.markServerHandshakeSentOrReceived();
    }

    public void markHandshakeFailed(UplinkConnectionRefusedException e) {
        this.log.debug((Object)(String.valueOf(this.logPrefix) + "Uplink connection failed or refused: " + e.getMessage()));
        this.sessionState.markHandshakeFailed();
        this.getLowLevelProtocolWrapper().terminateSession();
        this.sessionState.markOutgoingStreamClosed();
    }

    public void markHandshakeSuccessful() {
        this.sessionState.markHandshakeSuccessful();
    }

    protected abstract void onSessionStateChanged(UplinkSessionState var1, UplinkSessionState var2);

    protected abstract CommonUplinkLowLevelProtocolWrapper getProtocolWrapper();

    private void initiateCleanShutdown() {
        UplinkSessionState startingState = this.getState();
        if (startingState != UplinkSessionState.ACTIVE && startingState != UplinkSessionState.GOODBYE_HANDSHAKE) {
            this.log.warn((Object)(String.valueOf(this.logPrefix) + "Initiatiating clean shutdown from non-ACTIVE state " + (Object)((Object)this.getState())));
        }
        this.sessionState.setShuttingDown();
        this.outgoingProcessingQueue.enqueue(() -> {
            if (DEBUG_OUTPUT_ENABLED) {
                if (startingState == UplinkSessionState.ACTIVE) {
                    this.log.debug((Object)(String.valueOf(this.logPrefix) + "Sending 'goodbye' message to initiate clean shutdown"));
                } else {
                    this.log.debug((Object)(String.valueOf(this.logPrefix) + "Sending 'goodbye' message to confirm remote-initiated clean shutdown"));
                }
            }
            this.drainOutgoingMessageQueueOnShutdown();
            if (this.getLowLevelProtocolWrapper().attemptToSendRegularGoodbyeMessage()) {
                this.sessionState.markOwnGoodbyeSent();
                if (this.sessionState.getRemoteSideHasSentGoodbye()) {
                    this.getLowLevelProtocolWrapper().terminateSession();
                    this.sessionState.markOutgoingStreamClosed();
                } else {
                    this.asyncTaskService.scheduleAfterDelay("Close local end of Uplink stream", () -> {
                        if (!this.sessionState.isOutgoingStreamClosed()) {
                            this.getLowLevelProtocolWrapper().terminateSession();
                            this.sessionState.markOutgoingStreamClosed();
                        }
                    }, 10000L);
                }
            } else {
                this.handleStreamWriteError(null);
                this.getLowLevelProtocolWrapper().terminateSession();
                this.sessionState.markOutgoingStreamClosed();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleFatalError(UplinkProtocolErrorType errorType, String errorMessage) {
        this.log.debug((Object)StringUtils.format((String)"%sFatal error in Uplink connection to %s, closing the session: %s [type %s]", (Object[])new Object[]{this.logPrefix, this.getRemoteSideInformationString(), errorMessage, errorType.name()}));
        UplinkSessionStateHolder uplinkSessionStateHolder = this.sessionState;
        synchronized (uplinkSessionStateHolder) {
            this.sessionState.markFatalError(errorType);
            this.initiateUncleanShutdownIfStillRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void handleStreamWriteError(IOException e) {
        UplinkSessionStateHolder uplinkSessionStateHolder = this.sessionState;
        synchronized (uplinkSessionStateHolder) {
            this.sessionState.markOutgoingStreamWriteError();
            this.initiateUncleanShutdownIfStillRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateUncleanShutdownIfStillRunning() {
        UplinkSessionStateHolder uplinkSessionStateHolder = this.sessionState;
        synchronized (uplinkSessionStateHolder) {
            if (this.sessionState.isShuttingDownOrShutDown()) {
                this.log.debug((Object)(String.valueOf(this.logPrefix) + "Ignoring redundant call to initiate an unclean shutdown"));
                return;
            }
            if (this.sessionState.getMainState() == UplinkSessionState.ACTIVE) {
                this.sessionState.setMainStateInternal(UplinkSessionState.UNCLEAN_SHUTDOWN_INITIATED);
            }
            this.sessionState.setShuttingDown();
            this.drainOutgoingMessageQueueOnShutdown();
            this.outgoingProcessingQueue.enqueue(() -> {
                this.getLowLevelProtocolWrapper().terminateSession();
                this.sessionState.markOutgoingStreamClosed();
            });
        }
    }

    private void drainOutgoingMessageQueueOnShutdown() {
        Optional<MessageBlockWithMetadata> optionalNext;
        while ((optionalNext = this.boundedMessageOutbox.takeNext()).isPresent()) {
            this.log.debug((Object)(String.valueOf(this.logPrefix) + "Draining enqueued message of type " + (Object)((Object)optionalNext.get().getType()) + " to speed up sending of GOODBYE message on session shutdown"));
        }
    }

    private void sendNextMessageByPriority() {
        Optional<MessageBlockWithMetadata> optionalMessageBlock = this.boundedMessageOutbox.takeNext();
        if (!optionalMessageBlock.isPresent()) {
            if (!this.isShuttingDownOrShutDown()) {
                this.log.error((Object)("Potential consistency error: Did not receive a queued " + MessageBlockWithMetadata.class.getSimpleName() + ", but the session is not shutting down either"));
            }
            return;
        }
        MessageBlockWithMetadata messageBlock = optionalMessageBlock.get();
        if (this.isShuttingDownOrShutDown() && messageBlock.getType() != MessageType.GOODBYE) {
            this.log.debug((Object)(String.valueOf(this.logPrefix) + "Discarding enqueued message of type " + (Object)((Object)messageBlock.getType()) + " as the session is shutting down"));
            return;
        }
        try {
            this.getProtocolWrapper().sendMessageBlock(messageBlock.getChannelId(), messageBlock);
            if (DEBUG_OUTPUT_ENABLED) {
                this.log.debug((Object)(String.valueOf(this.logPrefix) + "Successfully sent message of type " + (Object)((Object)messageBlock.getType())));
            }
        }
        catch (IOException e) {
            this.log.error((Object)("Error during asynchronous sending of message with type " + (Object)((Object)messageBlock.getType())));
            this.handleStreamWriteError(e);
        }
    }

    protected final void setAssignedNamespaceId(String serverAssignedNamespaceId) {
        this.sessionState.setAssignedNamespaceId(serverAssignedNamespaceId);
    }

    protected final void setNamespaceIdReleased() {
        this.sessionState.setNamespaceIdReleased();
    }

    protected final void updateLogDescriptor() {
        this.sessionState.updateLogDescriptor();
    }

    protected abstract CommonUplinkLowLevelProtocolWrapper getLowLevelProtocolWrapper();

    protected abstract String getRemoteSideInformationString();

    protected final class UplinkSessionStateHolder {
        private static final String STRING_TO = " to ";
        private UplinkSessionState mainState = UplinkSessionState.INITIAL;
        private Optional<UplinkProtocolErrorType> fatalError = Optional.empty();
        private final CompletableFuture<String> assignedNamespaceIdFuture = new CompletableFuture();
        private boolean incomingStreamClosedOrEOF;
        private boolean outgoingStreamClosed;
        private boolean shuttingDown;
        private volatile String logDescriptor;
        private boolean remoteSideHasSentGoodbye;
        private boolean ownGoodbyeSent;
        private boolean handshakeFailed;
        private boolean namespaceIdReleased;
        private String protocolVersion;
        private String clientVersionInfo;
        private boolean heartbeatSendingEnabled;
        private String effectiveAccountName;
        private String effectiveSessionQualifier;
        private long lastHeartbeatSentTime;
        private boolean expectingHeartbeatResponse;
        private long handshakeResponseTimeout = UplinkProtocolConfiguration.getCurrent().getHandshakeResponseTimeout();

        protected UplinkSessionStateHolder() {
        }

        public synchronized void markClientHandshakeSentOrReceived() {
            if (this.getMainState() != UplinkSessionState.INITIAL) {
                AbstractUplinkSessionImpl.this.log.debug((Object)("Ignoring client handshake event as the session's state is " + (Object)((Object)this.getMainState())));
                return;
            }
            this.setMainStateInternal(UplinkSessionState.CLIENT_HANDSHAKE_REQUEST_READY);
        }

        public synchronized void markServerHandshakeSentOrReceived() {
            if (this.getMainState() != UplinkSessionState.CLIENT_HANDSHAKE_REQUEST_READY) {
                AbstractUplinkSessionImpl.this.log.debug((Object)("Ignoring server handshake event as the session's state is " + (Object)((Object)this.getMainState())));
                return;
            }
            this.setMainStateInternal(UplinkSessionState.SERVER_HANDSHAKE_RESPONSE_READY);
        }

        public void markHandshakeSuccessful() {
            this.setMainStateInternal(UplinkSessionState.ACTIVE);
        }

        public void markHandshakeFailed() {
            this.shuttingDown = true;
            if (!this.handshakeFailed) {
                this.handshakeFailed = true;
                this.setMainStateInternal(UplinkSessionState.SESSION_REFUSED_OR_HANDSHAKE_ERROR);
            }
        }

        public synchronized void markRemoteSideHasSentGoodbye() {
            this.remoteSideHasSentGoodbye = true;
            switch (this.mainState) {
                case ACTIVE: {
                    this.setMainStateInternal(UplinkSessionState.GOODBYE_HANDSHAKE);
                    break;
                }
                case GOODBYE_HANDSHAKE: {
                    if (!this.ownGoodbyeSent) {
                        throw new IllegalStateException();
                    }
                    this.setMainStateInternal(UplinkSessionState.GOODBYE_HANDSHAKE_COMPLETE);
                    break;
                }
                default: {
                    AbstractUplinkSessionImpl.this.log.debug((Object)("Received 'goodbye' message in non-standard state " + (Object)((Object)this.mainState)));
                }
            }
        }

        public synchronized boolean getRemoteSideHasSentGoodbye() {
            return this.remoteSideHasSentGoodbye;
        }

        public synchronized void markOwnGoodbyeSent() {
            this.ownGoodbyeSent = true;
            switch (this.mainState) {
                case ACTIVE: {
                    this.setMainStateInternal(UplinkSessionState.GOODBYE_HANDSHAKE);
                    break;
                }
                case GOODBYE_HANDSHAKE: {
                    if (!this.remoteSideHasSentGoodbye) {
                        throw new IllegalStateException();
                    }
                    this.setMainStateInternal(UplinkSessionState.GOODBYE_HANDSHAKE_COMPLETE);
                    break;
                }
                case INITIAL: 
                case CLIENT_HANDSHAKE_REQUEST_READY: 
                case SERVER_HANDSHAKE_RESPONSE_READY: 
                case UNCLEAN_SHUTDOWN_INITIATED: 
                case UNCLEAN_SHUTDOWN: {
                    AbstractUplinkSessionImpl.this.log.debug((Object)(String.valueOf(AbstractUplinkSessionImpl.this.logPrefix) + "Marking own 'goodbye' as sent from unusual state " + (Object)((Object)this.mainState)));
                    return;
                }
                default: {
                    AbstractUplinkSessionImpl.this.log.warn((Object)(String.valueOf(AbstractUplinkSessionImpl.this.logPrefix) + "Marking own 'goodbye' as sent from unexpected state " + (Object)((Object)this.mainState)));
                }
            }
        }

        public synchronized boolean getOwnGoodbyeSent() {
            return this.ownGoodbyeSent;
        }

        public synchronized void markIncomingStreamClosedOrEOF() {
            if (this.incomingStreamClosedOrEOF) {
                AbstractUplinkSessionImpl.this.log.warn((Object)(String.valueOf(AbstractUplinkSessionImpl.this.logPrefix) + "Redundant call to mark the incoming stream as closed or EOF"));
                return;
            }
            this.incomingStreamClosedOrEOF = true;
            if (this.mainState == UplinkSessionState.UNCLEAN_SHUTDOWN_INITIATED) {
                if (this.outgoingStreamClosed) {
                    AbstractUplinkSessionImpl.this.log.debug((Object)(String.valueOf(AbstractUplinkSessionImpl.this.logPrefix) + "Incoming stream closed after closing the local end of the stream; considering unclean shutdown complete"));
                    this.setMainStateInternal(UplinkSessionState.UNCLEAN_SHUTDOWN);
                } else {
                    AbstractUplinkSessionImpl.this.log.debug((Object)(String.valueOf(AbstractUplinkSessionImpl.this.logPrefix) + "Incoming stream marked as closed or EOF, " + "but the outgoing stream was not closed yet; postponing final state change"));
                }
                return;
            }
            if (this.ownGoodbyeSent) {
                if (this.remoteSideHasSentGoodbye) {
                    this.setMainStateInternal(UplinkSessionState.CLEAN_SHUTDOWN);
                } else {
                    AbstractUplinkSessionImpl.this.log.debug((Object)(String.valueOf(AbstractUplinkSessionImpl.this.logPrefix) + "Stream closed before the remote side sent 'goodbye'; the remote side may be using an outdated client"));
                    AbstractUplinkSessionImpl.this.initiateUncleanShutdownIfStillRunning();
                }
            } else if (this.remoteSideHasSentGoodbye) {
                AbstractUplinkSessionImpl.this.log.debug((Object)(String.valueOf(AbstractUplinkSessionImpl.this.logPrefix) + "Stream closed after a remote 'goodbye' before this side could send its confirmation; " + "the remote side may be using an outdated client"));
                AbstractUplinkSessionImpl.this.initiateUncleanShutdownIfStillRunning();
            } else {
                AbstractUplinkSessionImpl.this.log.debug((Object)(String.valueOf(AbstractUplinkSessionImpl.this.logPrefix) + "Unexpected end of Uplink stream; either the remote side has abruptly closed the connection, " + "or the network connection has been interrupted"));
                AbstractUplinkSessionImpl.this.initiateUncleanShutdownIfStillRunning();
            }
        }

        public synchronized void markFatalError(UplinkProtocolErrorType errorType) {
            this.fatalError = Optional.of(errorType);
            AbstractUplinkSessionImpl.this.log.debug((Object)(String.valueOf(AbstractUplinkSessionImpl.this.logPrefix) + "Encountered fatal error " + errorType.name() + ", terminating the session"));
        }

        public synchronized void markOutgoingStreamWriteError() {
            AbstractUplinkSessionImpl.this.log.debug((Object)(String.valueOf(AbstractUplinkSessionImpl.this.logPrefix) + "Failed to write to Uplink stream - " + "most likely, the underlying network connection has been interrupted; terminating the session"));
        }

        public synchronized void markOutgoingStreamClosed() {
            if (this.outgoingStreamClosed) {
                return;
            }
            AbstractUplinkSessionImpl.this.log.debug((Object)(String.valueOf(AbstractUplinkSessionImpl.this.logPrefix) + "Closed local end of stream"));
            this.outgoingStreamClosed = true;
            if (this.mainState == UplinkSessionState.GOODBYE_HANDSHAKE || this.mainState == UplinkSessionState.ACTIVE) {
                if (this.ownGoodbyeSent && this.remoteSideHasSentGoodbye) {
                    if (this.mainState == UplinkSessionState.ACTIVE) {
                        AbstractUplinkSessionImpl.this.log.warn((Object)(String.valueOf(AbstractUplinkSessionImpl.this.logPrefix) + "Unexpected transition: " + (Object)((Object)this.mainState) + "->" + (Object)((Object)UplinkSessionState.CLEAN_SHUTDOWN)));
                    }
                    this.setMainStateInternal(UplinkSessionState.CLEAN_SHUTDOWN);
                } else {
                    this.setMainStateInternal(UplinkSessionState.UNCLEAN_SHUTDOWN);
                }
            } else if (this.mainState != UplinkSessionState.CLEAN_SHUTDOWN) {
                if (this.incomingStreamClosedOrEOF) {
                    if (this.mainState != UplinkSessionState.UNCLEAN_SHUTDOWN_INITIATED) {
                        AbstractUplinkSessionImpl.this.log.warn((Object)(String.valueOf(AbstractUplinkSessionImpl.this.logPrefix) + "Unexpected transition: " + (Object)((Object)this.mainState) + "->" + (Object)((Object)UplinkSessionState.UNCLEAN_SHUTDOWN)));
                    }
                    this.setMainStateInternal(UplinkSessionState.UNCLEAN_SHUTDOWN);
                } else {
                    AbstractUplinkSessionImpl.this.log.debug((Object)(String.valueOf(AbstractUplinkSessionImpl.this.logPrefix) + "Unexpected combination: " + (Object)((Object)this.mainState) + ", outgoing stream closed, but not incoming stream"));
                }
            }
        }

        public synchronized boolean isOutgoingStreamClosed() {
            return this.outgoingStreamClosed;
        }

        public synchronized void setShuttingDown() {
            this.shuttingDown = true;
        }

        public synchronized boolean isShuttingDownOrShutDown() {
            return this.shuttingDown;
        }

        public synchronized void setAssignedNamespaceId(String serverAssignedNamespaceId) {
            this.assignedNamespaceIdFuture.complete(serverAssignedNamespaceId);
        }

        public synchronized String getAssignedNamespaceId() {
            String currentValue = this.assignedNamespaceIdFuture.getNow(null);
            if (currentValue != null) {
                return currentValue;
            }
            throw new IllegalStateException("Namespace id requested before it was available");
        }

        public synchronized Optional<String> getAssignedNamespaceIdIfAvailable() {
            return Optional.ofNullable(this.assignedNamespaceIdFuture.getNow(null));
        }

        public synchronized String getAssignedNamespaceIdIfAvailable(String fallback) {
            return this.assignedNamespaceIdFuture.getNow(fallback);
        }

        public synchronized void setNamespaceIdReleased() {
            this.namespaceIdReleased = true;
        }

        public boolean isNamespaceIdReleased() {
            return this.namespaceIdReleased;
        }

        public synchronized void updateLogDescriptor() {
            String namespaceIdOrPlaceholder = AbstractUplinkSessionImpl.this.sessionState.getAssignedNamespaceIdIfAvailable("<no namespace>");
            String releasedSuffix = this.namespaceIdReleased ? "(released)" : "";
            this.logDescriptor = StringUtils.format((String)"%s/%s%s", (Object[])new Object[]{AbstractUplinkSessionImpl.this.getLocalSessionId(), namespaceIdOrPlaceholder, releasedSuffix});
            AbstractUplinkSessionImpl.this.logPrefix = "[" + this.logDescriptor + "] ";
        }

        private void setMainStateInternal(UplinkSessionState newState) {
            UplinkSessionState oldState = this.mainState;
            if (newState == oldState) {
                if (newState == UplinkSessionState.CLEAN_SHUTDOWN || newState == UplinkSessionState.UNCLEAN_SHUTDOWN) {
                    AbstractUplinkSessionImpl.this.log.debug((Object)("Redundant request to set the state of session " + this.logDescriptor + STRING_TO + (Object)((Object)newState)));
                    return;
                }
                throw new IllegalStateException("Redundant request to set the state of session " + this.logDescriptor + STRING_TO + (Object)((Object)newState));
            }
            if (oldState.isTerminal()) {
                throw new IllegalStateException("Tried to set the state of session " + this.logDescriptor + STRING_TO + (Object)((Object)newState) + " while it is already in terminal state " + (Object)((Object)oldState));
            }
            if (newState == UplinkSessionState.GOODBYE_HANDSHAKE && this.remoteSideHasSentGoodbye == this.ownGoodbyeSent) {
                throw new IllegalStateException("Consistency violation: " + (Object)((Object)newState) + AbstractUplinkSessionImpl.LOG_SLASH + this.ownGoodbyeSent + AbstractUplinkSessionImpl.LOG_SLASH + this.remoteSideHasSentGoodbye);
            }
            if (!(newState != UplinkSessionState.GOODBYE_HANDSHAKE_COMPLETE || this.remoteSideHasSentGoodbye && this.ownGoodbyeSent)) {
                throw new IllegalStateException("Consistency violation: " + (Object)((Object)newState) + AbstractUplinkSessionImpl.LOG_SLASH + this.ownGoodbyeSent + AbstractUplinkSessionImpl.LOG_SLASH + this.remoteSideHasSentGoodbye);
            }
            AbstractUplinkSessionImpl.this.log.debug((Object)StringUtils.format((String)"%s%s -> %s", (Object[])new Object[]{AbstractUplinkSessionImpl.this.logPrefix, oldState, newState}));
            this.mainState = newState;
            AbstractUplinkSessionImpl.this.onSessionStateChanged(oldState, newState);
            if (newState.isTerminal()) {
                AbstractUplinkSessionImpl.this.getLowLevelProtocolWrapper().terminateSession();
                AbstractUplinkSessionImpl.this.onTerminalStateReached(newState, this.fatalError);
            }
        }

        public synchronized UplinkSessionState getMainState() {
            return this.mainState;
        }

        public synchronized void setClientVersionInfo(String clientVersionInfo) {
            this.clientVersionInfo = clientVersionInfo != null ? clientVersionInfo : AbstractUplinkSessionImpl.UNDEFINED_CLIENT_VERSION_PLACEHOLDER;
        }

        public synchronized String getClientVersionInfo() {
            return this.clientVersionInfo;
        }

        public synchronized void setProtocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
            this.heartbeatSendingEnabled = !"0.1".equals(protocolVersion);
        }

        public synchronized String getProtocolVersion() {
            return this.protocolVersion;
        }

        public synchronized boolean isHeartbeatSendingEnabled() {
            return this.heartbeatSendingEnabled;
        }

        public synchronized void setEffectiveAccountName(String effectiveAccountName) {
            this.effectiveAccountName = effectiveAccountName;
        }

        public synchronized String getEffectiveAccountName() {
            return this.effectiveAccountName;
        }

        public synchronized void setEffectiveSessionQualifier(String effectiveSessionQualifier) {
            this.effectiveSessionQualifier = effectiveSessionQualifier;
        }

        public synchronized String getEffectiveSessionQualifier() {
            return this.effectiveSessionQualifier;
        }

        public synchronized void markHeartbeatSent() {
            this.lastHeartbeatSentTime = System.currentTimeMillis();
            this.expectingHeartbeatResponse = true;
        }

        public synchronized void markHeartbeatResponseReceived() {
            if (this.expectingHeartbeatResponse) {
                long duration = System.currentTimeMillis() - this.lastHeartbeatSentTime;
                if (duration > this.handshakeResponseTimeout) {
                    AbstractUplinkSessionImpl.this.log.warn((Object)(String.valueOf(AbstractUplinkSessionImpl.this.logPrefix) + "Observed long heartbeat round-trip time of " + duration + " msec"));
                }
                this.expectingHeartbeatResponse = false;
            } else {
                AbstractUplinkSessionImpl.this.log.warn((Object)(String.valueOf(AbstractUplinkSessionImpl.this.logPrefix) + "Received a " + (Object)((Object)MessageType.HEARTBEAT_RESPONSE) + " message without expecting one"));
            }
        }

        public synchronized boolean validateHeartbeatResponseIfExpected() {
            if (this.expectingHeartbeatResponse) {
                long duration = System.currentTimeMillis() - this.lastHeartbeatSentTime;
                AbstractUplinkSessionImpl.this.log.debug((Object)(String.valueOf(AbstractUplinkSessionImpl.this.logPrefix) + "No heartbeat response received within " + duration + " msec, assuming broken connection or client"));
                AbstractUplinkSessionImpl.this.initiateUncleanShutdownIfStillRunning();
                return false;
            }
            return true;
        }
    }
}

