/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.relay.internal;

import de.rcenvironment.core.communication.uplink.common.internal.MessageType;
import de.rcenvironment.core.communication.uplink.common.internal.UplinkProtocolMessageConverter;
import de.rcenvironment.core.communication.uplink.network.api.MessageBlockPriority;
import de.rcenvironment.core.communication.uplink.network.internal.CommonUplinkLowLevelProtocolWrapper;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.communication.uplink.network.internal.ServerSideUplinkLowLevelProtocolWrapper;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkConnectionLowLevelEventHandler;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkConnectionRefusedException;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkProtocolConfiguration;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkProtocolErrorType;
import de.rcenvironment.core.communication.uplink.relay.api.ServerSideUplinkEndpointService;
import de.rcenvironment.core.communication.uplink.relay.api.ServerSideUplinkSession;
import de.rcenvironment.core.communication.uplink.session.api.UplinkSessionState;
import de.rcenvironment.core.communication.uplink.session.internal.AbstractUplinkSessionImpl;
import de.rcenvironment.core.eventlog.api.EventLog;
import de.rcenvironment.core.eventlog.api.EventLogEntry;
import de.rcenvironment.core.eventlog.api.EventType;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StreamConnectionEndpoint;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.ConcurrencyUtilsFactory;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.Semaphore;

public class ServerSideUplinkSessionImpl
extends AbstractUplinkSessionImpl
implements ServerSideUplinkSession {
    private static final String SESSION_CONTEXT_INFO_PREFIX_FOR_SSH_SESSION = "ssh session ";
    private static final boolean HEARTBEAT_LOGGING_ENABLED = DebugSettings.getVerboseLoggingEnabled((String)"uplink.heartbeat");
    private static final boolean BACKPRESSURE_LOGGING_ENABLED = DebugSettings.getVerboseLoggingEnabled((String)"uplink.backpressure");
    private final String sessionContextInfoString;
    private final String eventLogConnectionId;
    private final String localSessionId;
    private final CommonUplinkLowLevelProtocolWrapper protocolWrapper;
    private final ServerSideUplinkEndpointService serverSideUplinkEndpointService;
    private final UplinkProtocolMessageConverter messageConverter;
    private String loginAccountName;
    private Random random = new Random();
    private int heartbeatServerToClientSendIntervalAverage = UplinkProtocolConfiguration.getCurrent().getHeartbeatServerToClientSendIntervalAverage();
    private int heartbeatServerToClientSendIntervalSpread = UplinkProtocolConfiguration.getCurrent().getHeartbeatServerToClientSendIntervalSpread();

    public ServerSideUplinkSessionImpl(StreamConnectionEndpoint connectionEndpoint, String loginAccountName, String sessionContextInfoString, ServerSideUplinkEndpointService serverSideUplinkEndpointService, ConcurrencyUtilsFactory concurrencyUtilsFactory) {
        super(concurrencyUtilsFactory);
        this.loginAccountName = loginAccountName;
        this.sessionContextInfoString = sessionContextInfoString;
        this.eventLogConnectionId = sessionContextInfoString.startsWith(SESSION_CONTEXT_INFO_PREFIX_FOR_SSH_SESSION) ? sessionContextInfoString.substring(SESSION_CONTEXT_INFO_PREFIX_FOR_SSH_SESSION.length()) : sessionContextInfoString;
        this.serverSideUplinkEndpointService = serverSideUplinkEndpointService;
        this.localSessionId = serverSideUplinkEndpointService.assignSessionId(this);
        this.updateLogDescriptor();
        this.messageConverter = new UplinkProtocolMessageConverter("server session " + this.localSessionId);
        ServerSideUplinkLowLevelEventHandlerImpl serverSideUplinkLowLevelEventHandler = new ServerSideUplinkLowLevelEventHandlerImpl(serverSideUplinkEndpointService, sessionContextInfoString);
        this.protocolWrapper = new ServerSideUplinkLowLevelProtocolWrapper(connectionEndpoint, serverSideUplinkLowLevelEventHandler, this.localSessionId);
    }

    @Override
    public boolean runSession() {
        boolean bl;
        this.log.debug((Object)StringUtils.format((String)"%sStarting Uplink session for %s (%s)", (Object[])new Object[]{this.logPrefix, this.loginAccountName, this.sessionContextInfoString}));
        long startTime = System.currentTimeMillis();
        try {
            this.protocolWrapper.runSession();
            bl = this.getState() == UplinkSessionState.CLEAN_SHUTDOWN;
        }
        catch (Throwable throwable) {
            UplinkSessionState finalState = this.getState();
            long execTimeMsec = System.currentTimeMillis() - startTime;
            this.validateProperSessionRelease();
            this.log.debug((Object)StringUtils.format((String)"%sUplink session for user \"%s\" (%s) terminated in final state %s, duration: %d msec", (Object[])new Object[]{this.logPrefix, this.loginAccountName, this.sessionContextInfoString, finalState.name(), execTimeMsec}));
            if (!finalState.isTerminal()) {
                if ("<undefined>" == this.sessionState.getClientVersionInfo()) {
                    this.log.debug((Object)(String.valueOf(this.logPrefix) + "Session of outdated client terminated in non-terminal state " + finalState.name() + " (expected legacy behavior)"));
                } else {
                    this.log.warn((Object)(String.valueOf(this.logPrefix) + "Session terminated in non-terminal state " + finalState.name()));
                }
            }
            throw throwable;
        }
        UplinkSessionState finalState = this.getState();
        long execTimeMsec = System.currentTimeMillis() - startTime;
        this.validateProperSessionRelease();
        this.log.debug((Object)StringUtils.format((String)"%sUplink session for user \"%s\" (%s) terminated in final state %s, duration: %d msec", (Object[])new Object[]{this.logPrefix, this.loginAccountName, this.sessionContextInfoString, finalState.name(), execTimeMsec}));
        if (!finalState.isTerminal()) {
            if ("<undefined>" == this.sessionState.getClientVersionInfo()) {
                this.log.debug((Object)(String.valueOf(this.logPrefix) + "Session of outdated client terminated in non-terminal state " + finalState.name() + " (expected legacy behavior)"));
            } else {
                this.log.warn((Object)(String.valueOf(this.logPrefix) + "Session terminated in non-terminal state " + finalState.name()));
            }
        }
        return bl;
    }

    @Override
    public CommonUplinkLowLevelProtocolWrapper getProtocolWrapper() {
        return this.protocolWrapper;
    }

    @Override
    public String getLocalSessionId() {
        return this.localSessionId;
    }

    @Override
    protected void onSessionStateChanged(UplinkSessionState oldState, UplinkSessionState newState) {
        if (newState == UplinkSessionState.ACTIVE) {
            this.serverSideUplinkEndpointService.setSessionActiveState(this, true);
            if (this.sessionState.isHeartbeatSendingEnabled()) {
                this.scheduleHeartbeatSendTrigger();
            }
        }
        if (newState == UplinkSessionState.SESSION_REFUSED_OR_HANDSHAKE_ERROR || oldState == UplinkSessionState.ACTIVE) {
            this.releaseNamespaceIdIfPresent(oldState == UplinkSessionState.ACTIVE);
        }
        if (oldState == UplinkSessionState.ACTIVE) {
            this.serverSideUplinkEndpointService.setSessionActiveState(this, false);
        }
    }

    private void scheduleHeartbeatSendTrigger() {
        AsyncTaskService asyncTaskService = ConcurrencyUtils.getAsyncTaskService();
        int delay = this.heartbeatServerToClientSendIntervalAverage - this.heartbeatServerToClientSendIntervalAverage / 2 + this.random.nextInt(this.heartbeatServerToClientSendIntervalSpread);
        asyncTaskService.scheduleAfterDelay("Send Uplink heartbeat after delay", () -> {
            if (this.enqueueHeartbeatMessage()) {
                this.scheduleHeartbeatSendTrigger();
            }
        }, (long)delay);
    }

    private boolean enqueueHeartbeatMessage() {
        if (this.getState() == UplinkSessionState.ACTIVE) {
            if (!this.sessionState.validateHeartbeatResponseIfExpected()) {
                return false;
            }
            try {
                if (HEARTBEAT_LOGGING_ENABLED) {
                    this.log.debug((Object)(String.valueOf(this.logPrefix) + "Enqueueing heartbeat message"));
                }
                this.enqueueMessageBlockForSending(0L, new MessageBlock(MessageType.HEARTBEAT), MessageBlockPriority.HIGH, false);
                this.sessionState.markHeartbeatSent();
                return true;
            }
            catch (IOException e) {
                this.log.debug((Object)(String.valueOf(this.logPrefix) + "Error while scheduling an Uplink heartbeat: " + e.toString()));
                return false;
            }
        }
        if (HEARTBEAT_LOGGING_ENABLED) {
            this.log.debug((Object)(String.valueOf(this.logPrefix) + "Stopping hearbeat sending as session is in state " + this.getState().name()));
        }
        return false;
    }

    @Override
    protected void onTerminalStateReached(UplinkSessionState newState, Optional<UplinkProtocolErrorType> fatalError) {
        this.writeEventLogEntryOnSessionTerminating(newState);
    }

    @Override
    protected void handleFatalError(UplinkProtocolErrorType errorType, String errorMessage) {
        super.handleFatalError(errorType, errorMessage);
    }

    @Override
    protected CommonUplinkLowLevelProtocolWrapper getLowLevelProtocolWrapper() {
        return this.protocolWrapper;
    }

    @Override
    protected String getRemoteSideInformationString() {
        return StringUtils.format((String)"user \"%s\" (%s)", (Object[])new Object[]{this.loginAccountName, this.sessionContextInfoString});
    }

    private void releaseNamespaceIdIfPresent(boolean sessionWasActive) {
        Optional<String> assignedNamespaceId = this.getAssignedNamespaceIdIfAvailable();
        if (assignedNamespaceId.isPresent()) {
            this.serverSideUplinkEndpointService.releaseNamespaceId(assignedNamespaceId.get(), this);
            this.sessionState.setNamespaceIdReleased();
            this.updateLogDescriptor();
        } else if (sessionWasActive) {
            this.log.warn((Object)(String.valueOf(this.logPrefix) + "Session had no namespace assigned when leaving the ACTIVE state"));
        }
    }

    private String determineEffectiveAccountName(String accountNameInput) {
        String effectiveAccountName;
        if (accountNameInput.length() > 8) {
            String truncated = accountNameInput.substring(0, 8);
            this.log.warn((Object)StringUtils.format((String)"Only the first %d characters of the login name '%s' ('%s') will be used for the client's unique identity; if possible, use login names that do not exceed %d characters", (Object[])new Object[]{8, accountNameInput, truncated, 8}));
            effectiveAccountName = truncated;
        } else {
            effectiveAccountName = accountNameInput;
        }
        return effectiveAccountName;
    }

    private String determineEffectiveSessionQualifier(String accountNameInput, Map<String, String> incomingData) {
        String effectiveSessionQualifier;
        String clientSessionQualifier = incomingData.get("sessionQualifier");
        if (StringUtils.isNullorEmpty((String)clientSessionQualifier)) {
            clientSessionQualifier = "default";
            this.log.debug((Object)(String.valueOf(this.logPrefix) + "An Uplink client using account '" + accountNameInput + "' sent an empty client ID; using '" + clientSessionQualifier + "'"));
        }
        if (clientSessionQualifier.length() > 8) {
            String truncated = clientSessionQualifier.substring(0, 8);
            this.log.warn((Object)StringUtils.format((String)"Truncating client ID '%s' to '%s' as it exceeds the significant character limit (%d)", (Object[])new Object[]{clientSessionQualifier, truncated, 8}));
            effectiveSessionQualifier = truncated;
        } else {
            effectiveSessionQualifier = clientSessionQualifier;
        }
        return effectiveSessionQualifier;
    }

    private String deriveAssignedNamespaceId(String effectiveAccountName, String effectiveSessionQualifier) {
        String namespaceId = String.valueOf(org.apache.commons.lang3.StringUtils.rightPad((String)effectiveAccountName, (int)8, (char)'-')) + org.apache.commons.lang3.StringUtils.rightPad((String)effectiveSessionQualifier, (int)8, (char)'-');
        if (namespaceId.length() != 16) {
            throw new IllegalStateException();
        }
        return namespaceId;
    }

    protected void validateProperSessionRelease() {
        Optional<String> assignedNamespaceId = this.getAssignedNamespaceIdIfAvailable();
        if (assignedNamespaceId.isPresent() && !this.sessionState.isNamespaceIdReleased()) {
            this.log.error((Object)(String.valueOf(this.logPrefix) + "Found attached namespace " + assignedNamespaceId.get() + " when it should already have been released; " + "please report this error and provide the related debug.log file, if possible"));
        }
    }

    private void writeEventLogEntryOnSessionActivating() {
        EventLogEntry entry = EventLog.newEntry((EventType)EventType.UPLINK_INCOMING_ACCEPTED);
        this.addCommonSessionStartInfoToEventLogEntry(entry);
        this.addVersionInfoToEventLogEntry(entry);
        EventLog.append((EventLogEntry)entry);
    }

    private void writeEventLogEntryOnSessionRefused(UplinkConnectionRefusedException e) {
        EventLogEntry entry = EventLog.newEntry((EventType)EventType.UPLINK_INCOMING_REFUSED).set("reason", e.getMessage());
        this.addCommonSessionStartInfoToEventLogEntry(entry);
        this.addVersionInfoToEventLogEntry(entry);
        EventLog.append((EventLogEntry)entry);
    }

    private void addCommonSessionStartInfoToEventLogEntry(EventLogEntry entry) {
        String effectiveAccountName = this.sessionState.getEffectiveAccountName();
        entry.set("session_id", this.localSessionId).set("connection_id", this.eventLogConnectionId).set("login_name", effectiveAccountName).set("client_id", this.sessionState.getEffectiveSessionQualifier());
        Optional<String> assignedNamespaceIdIfAvailable = this.sessionState.getAssignedNamespaceIdIfAvailable();
        if (assignedNamespaceIdIfAvailable.isPresent()) {
            entry.set("namespace", assignedNamespaceIdIfAvailable.get());
        }
        if (effectiveAccountName == null || !effectiveAccountName.equals(this.loginAccountName)) {
            entry.set("original_login_name", this.loginAccountName);
        }
    }

    private void writeEventLogEntryOnSessionTerminating(UplinkSessionState newState) {
        EventLog.append((EventLogEntry)EventLog.newEntry((EventType)EventType.UPLINK_INCOMING_CLOSED).set("session_id", this.localSessionId).set("connection_id", this.eventLogConnectionId).set("final_state", newState.name()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVersionInfoToEventLogEntry(EventLogEntry entry) {
        AbstractUplinkSessionImpl.UplinkSessionStateHolder uplinkSessionStateHolder = this.sessionState;
        synchronized (uplinkSessionStateHolder) {
            String protocolVersion;
            String clientVersionInfo = this.sessionState.getClientVersionInfo();
            if (clientVersionInfo != null) {
                entry.set("client_version", clientVersionInfo);
            }
            if ((protocolVersion = this.sessionState.getProtocolVersion()) != null) {
                entry.set("protocol_version", protocolVersion);
            }
        }
    }

    private final class ServerSideUplinkLowLevelEventHandlerImpl
    implements UplinkConnectionLowLevelEventHandler {
        private final ServerSideUplinkEndpointService serverSideUplinkEndpointService;
        private final String clientInformationString;
        private final Semaphore messageReadBufferSemaphore = new Semaphore(UplinkProtocolConfiguration.getCurrent().getMaxBufferedIncomingMessagesPerSession());

        private ServerSideUplinkLowLevelEventHandlerImpl(ServerSideUplinkEndpointService serverSideUplinkEndpointService, String clientInformationString) {
            this.serverSideUplinkEndpointService = serverSideUplinkEndpointService;
            this.clientInformationString = clientInformationString;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void provideOrProcessHandshakeData(Map<String, String> incomingData, Map<String, String> outgoingData) throws ProtocolException, UplinkConnectionRefusedException {
            ServerSideUplinkSessionImpl.this.markClientHandshakeSentOrReceived();
            Objects.requireNonNull(incomingData);
            Objects.requireNonNull(outgoingData);
            outgoingData.putAll(incomingData);
            outgoingData.remove("protocolVersion");
            String clientProtocolVersion = incomingData.get("protocolVersion");
            if (StringUtils.isNullorEmpty((String)clientProtocolVersion)) {
                throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.INVALID_HANDSHAKE_DATA, "Missing handshake version information", true);
            }
            if (clientProtocolVersion.equals("0.2")) {
                ServerSideUplinkSessionImpl.this.sessionState.setProtocolVersion(clientProtocolVersion);
            } else if (clientProtocolVersion.equals("10.0.0")) {
                ServerSideUplinkSessionImpl.this.sessionState.setProtocolVersion("0.1");
            } else {
                throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.PROTOCOL_VERSION_MISMATCH, "The client and server are using incompatible versions of the Uplink protocol (" + clientProtocolVersion + " vs. " + "0.2" + "). Please use a client version matching the server you are connecting to.", true);
            }
            outgoingData.put("protocolVersion", ServerSideUplinkSessionImpl.this.sessionState.getProtocolVersion());
            ServerSideUplinkSessionImpl.this.sessionState.setClientVersionInfo(incomingData.get("clientVersion"));
            String effectiveAccountName = ServerSideUplinkSessionImpl.this.determineEffectiveAccountName(ServerSideUplinkSessionImpl.this.loginAccountName);
            String effectiveSessionQualifier = ServerSideUplinkSessionImpl.this.determineEffectiveSessionQualifier(ServerSideUplinkSessionImpl.this.loginAccountName, incomingData);
            AbstractUplinkSessionImpl.UplinkSessionStateHolder uplinkSessionStateHolder = ServerSideUplinkSessionImpl.this.sessionState;
            synchronized (uplinkSessionStateHolder) {
                ServerSideUplinkSessionImpl.this.sessionState.setEffectiveAccountName(effectiveAccountName);
                ServerSideUplinkSessionImpl.this.sessionState.setEffectiveSessionQualifier(effectiveSessionQualifier);
            }
            String assignedNamespaceId = ServerSideUplinkSessionImpl.this.deriveAssignedNamespaceId(effectiveAccountName, effectiveSessionQualifier);
            boolean namespaceAcquired = this.serverSideUplinkEndpointService.attemptToAssignNamespaceId(assignedNamespaceId, ServerSideUplinkSessionImpl.this);
            if (!namespaceAcquired) {
                throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.CLIENT_NAMESPACE_COLLISION, "The combination of account name \"" + effectiveAccountName + "\" and client ID \"" + effectiveSessionQualifier + "\" is already in use. To allow parallel logins, use a different client ID for each client.", true);
            }
            ServerSideUplinkSessionImpl.this.setAssignedNamespaceId(assignedNamespaceId);
            ServerSideUplinkSessionImpl.this.updateLogDescriptor();
            outgoingData.put("namespace", assignedNamespaceId);
            if (incomingData.containsKey("simulateHandshakeFailure")) {
                throw new ProtocolException(incomingData.get("simulateHandshakeFailure"));
            }
            if (incomingData.containsKey("simulateRefusedConnection")) {
                throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.CLIENT_NAMESPACE_COLLISION, incomingData.get("simulateRefusedConnection"), true);
            }
            if (incomingData.containsKey("simulateHandshakeTimeout")) {
                try {
                    Thread.sleep(UplinkProtocolConfiguration.getCurrent().getHandshakeResponseTimeout() + UplinkProtocolConfiguration.getCurrent().getHandshakeResponseTimeout());
                }
                catch (InterruptedException interruptedException) {
                    ServerSideUplinkSessionImpl.this.log.warn((Object)"Interrupted while simulating handshake timeout");
                }
            }
            ServerSideUplinkSessionImpl.this.markServerHandshakeSentOrReceived();
        }

        @Override
        public void onHandshakeComplete() {
            ServerSideUplinkSessionImpl.this.writeEventLogEntryOnSessionActivating();
            ServerSideUplinkSessionImpl.this.markHandshakeSuccessful();
        }

        @Override
        public void onHandshakeFailedOrConnectionRefused(UplinkConnectionRefusedException e) {
            ServerSideUplinkSessionImpl.this.writeEventLogEntryOnSessionRefused(e);
            ServerSideUplinkSessionImpl.this.markHandshakeFailed(e);
        }

        @Override
        public void onRegularGoodbyeMessage() {
            ServerSideUplinkSessionImpl.this.handleRegularRemoteGoodbyeMessage();
        }

        @Override
        public void onErrorGoodbyeMessage(UplinkProtocolErrorType errorType, String errorMessage) {
            ServerSideUplinkSessionImpl.this.handleFatalError(errorType, errorMessage);
        }

        @Override
        public void onIncomingStreamClosedOrEOF() {
            ServerSideUplinkSessionImpl.this.handleIncomingStreamClosedOrEOF();
        }

        @Override
        public void onStreamReadError(IOException e) {
            ServerSideUplinkSessionImpl.this.handleFatalError(UplinkProtocolErrorType.LOW_LEVEL_CONNECTION_ERROR, e.toString());
        }

        @Override
        public void onStreamWriteError(IOException e) {
            ServerSideUplinkSessionImpl.this.log.warn((Object)("Stream write error: " + e.toString()));
            ServerSideUplinkSessionImpl.this.handleStreamWriteError(e);
        }

        @Override
        public void onNonProtocolError(Exception exception) {
            ServerSideUplinkSessionImpl.this.handleFatalError(UplinkProtocolErrorType.UNKNOWN_ERROR_ALLOW_RECONNECT, exception.toString());
        }

        @Override
        public void onMessageBlock(long channelId, MessageBlock messageBlock) {
            if (messageBlock.getType() == MessageType.HEARTBEAT_RESPONSE && channelId == 0L) {
                ServerSideUplinkSessionImpl.this.sessionState.markHeartbeatResponseReceived();
                return;
            }
            long semaphoreBlockedStartTime = 0L;
            if (BACKPRESSURE_LOGGING_ENABLED && this.messageReadBufferSemaphore.availablePermits() == 0) {
                semaphoreBlockedStartTime = System.currentTimeMillis();
                ServerSideUplinkSessionImpl.this.log.debug((Object)(String.valueOf(ServerSideUplinkSessionImpl.this.logPrefix) + "Waiting to enqueue the next incoming message for processing"));
            }
            try {
                this.messageReadBufferSemaphore.acquire();
                if (BACKPRESSURE_LOGGING_ENABLED && semaphoreBlockedStartTime != 0L) {
                    ServerSideUplinkSessionImpl.this.log.debug((Object)(String.valueOf(ServerSideUplinkSessionImpl.this.logPrefix) + "Proceeding with next incoming message after waiting for " + (System.currentTimeMillis() - semaphoreBlockedStartTime) + " msec"));
                }
            }
            catch (InterruptedException interruptedException) {
                ServerSideUplinkSessionImpl.this.log.debug((Object)(String.valueOf(ServerSideUplinkSessionImpl.this.logPrefix) + "Interrupted while waiting to enqueue the next incoming message; stopping read loop"));
                return;
            }
            ServerSideUplinkSessionImpl.this.incomingProcessingQueue.enqueue(() -> {
                try {
                    try {
                        this.serverSideUplinkEndpointService.onMessageBlock(ServerSideUplinkSessionImpl.this, channelId, messageBlock);
                    }
                    catch (ProtocolException e) {
                        ServerSideUplinkSessionImpl.this.log.error((Object)(String.valueOf(ServerSideUplinkSessionImpl.this.logPrefix) + "Error processing a received message"), (Throwable)e);
                        this.messageReadBufferSemaphore.release();
                    }
                }
                finally {
                    this.messageReadBufferSemaphore.release();
                }
            });
        }
    }
}

