/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output;

import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfPageData;

public class OutputShape {
    private static final boolean ENABLE_CROPPING = true;
    boolean hasMoveTo = false;
    protected int shapeCount = 0;
    double minXcoord = 999999.0;
    double minYcoord = 999999.0;
    protected List pathCommands;
    protected int currentColor;
    protected Rectangle cropBox;
    private Point2D midPoint;
    private double[] lastVisiblePoint;
    private double[] lastInvisiblePoint;
    private double[] previousPoint;
    private boolean isPathSegmentVisible;
    protected double[] entryPoint;
    private int yOffset = 0;
    boolean includeClip = false;
    private double[] exitPoint;
    private List largeBox;
    private boolean isLargeBox;
    private boolean largeBoxSideAlternation;
    static int debug = 0;
    Rectangle clipBox = null;
    private int dpCount = 0;
    private int pageRotation = 0;
    protected float scaling;
    private boolean debugPath = false;
    protected boolean isSinglePixelFill;
    private PdfPageData pageData;
    private int pageNumber;
    int pathCommand;
    private float[][] ctm;
    private Shape currentShape;
    private int minX;
    private int minY;
    protected int cmd = -1;
    int adjustY = 0;

    public OutputShape(int n, int n2, float f, Shape shape, GraphicsState graphicsState, AffineTransform affineTransform, Point2D point2D, Rectangle rectangle, int n3, int n4, int n5, PdfPageData pdfPageData, int n6, boolean bl) {
        double d;
        this.includeClip = bl;
        if (shape.getBounds2D().getHeight() > (double)0.6f && shape.getBounds2D().getHeight() < 1.0 && shape.getBounds2D().getWidth() > 1.0 && (d = shape.getBounds2D().getMinY() - (double)shape.getBounds().y) > 0.7) {
            this.adjustY = 1;
        }
        this.cmd = n;
        this.minX = pdfPageData.getCropBoxX(n6);
        this.minY = pdfPageData.getCropBoxY(n6);
        if (this.debugPath) {
            System.out.println("raw shape=" + shape.getBounds() + " minx=" + this.minX + " " + this.minY);
        }
        this.yOffset = n2;
        Area area = graphicsState.getClippingShape();
        this.clipBox = area != null ? area.getBounds() : null;
        if ((this.minX != 0 || this.minY != 0) && this.clipBox != null) {
            this.clipBox.translate(-this.minX, -this.minY);
        }
        this.currentShape = shape;
        this.ctm = graphicsState.CTM;
        this.scaling = f;
        this.currentColor = n3;
        this.cropBox = rectangle;
        this.dpCount = n4;
        this.midPoint = point2D;
        this.pageData = pdfPageData;
        this.pageNumber = n6;
        this.isSinglePixelFill = shape.getBounds().width < 2 || shape.getBounds().height < 2;
        this.pageRotation = n5;
        this.isPathSegmentVisible = true;
        this.lastVisiblePoint = new double[2];
        this.lastInvisiblePoint = new double[2];
        this.previousPoint = new double[2];
        this.exitPoint = new double[2];
        this.entryPoint = new double[2];
        this.pathCommands = new ArrayList();
        this.largeBox = new ArrayList();
        this.isLargeBox = true;
    }

    protected void generateShapeFromG2Data(GraphicsState graphicsState, AffineTransform affineTransform, Rectangle rectangle) {
        PathIterator pathIterator = this.currentShape.getPathIterator(affineTransform);
        this.beginShape();
        boolean bl = true;
        if (this.debugPath) {
            System.out.println("About to generate commands for shape with bounds" + this.currentShape.getBounds());
            System.out.println("------------------------------------------------");
            System.out.println("crop bounds=" + rectangle.getBounds());
            System.out.println("shape bounds=" + this.currentShape.getBounds());
            System.out.println("minX=" + this.minX + " minY=" + this.minY);
            if (this.clipBox != null) {
                System.out.println("clip bounds=" + this.clipBox.getBounds());
            }
        }
        int n = 0;
        while (!pathIterator.isDone()) {
            int n2;
            double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            this.pathCommand = pathIterator.currentSegment(dArray);
            ++n;
            for (n2 = 0; n2 < 3; ++n2) {
                dArray[n2 * 2] = dArray[n2 * 2] - (double)this.minX;
                dArray[n2 * 2 + 1] = dArray[n2 * 2 + 1] - (double)this.minY;
            }
            if (this.debugPath) {
                System.out.println("\n=======Get pathCommand segment " + (int)dArray[0] + " " + (int)dArray[1] + " " + (int)dArray[2] + " " + (int)dArray[3] + " " + (int)dArray[4] + " " + (int)dArray[5]);
            }
            if (this.cmd != 110) {
                this.checkLargeBox(dArray, this.pathCommand);
            }
            if (bl) {
                n2 = (int)dArray[OutputShape.getCoordOffset(this.pathCommand)];
                int n3 = (int)dArray[OutputShape.getCoordOffset(this.pathCommand) + 1];
                Rectangle rectangle2 = rectangle;
                if (this.clipBox != null) {
                    rectangle2 = this.clipBox;
                }
                if (rectangle2.width > 1) {
                    if (n2 == rectangle2.x) {
                        ++n2;
                    } else if (n2 == rectangle2.x + rectangle2.width) {
                        --n2;
                    }
                }
                this.isPathSegmentVisible = rectangle2.contains(n2, n3);
                bl = false;
                if (this.debugPath) {
                    System.out.println("isPathSegmentVisible=" + this.isPathSegmentVisible);
                }
            }
            if (this.pathCommand == 3) {
                n2 = this.testDrawLimits(dArray, 3) ? 1 : 0;
                if (this.debugPath) {
                    System.out.println("PathIterator.SEG_CUBICTO isPointVisible=" + (n2 != 0));
                }
                if (n2 != 0 && this.isPathSegmentVisible) {
                    this.bezierCurveTo(dArray);
                }
                this.isPathSegmentVisible = n2;
            } else if (this.pathCommand == 1) {
                double[] dArray2 = new double[]{this.previousPoint[0], this.previousPoint[1]};
                n2 = this.testDrawLimits(dArray, 1) ? 1 : 0;
                if (this.debugPath) {
                    System.out.println("PathIterator.SEG_LINETO isPointVisible=" + (n2 != 0) + " isPathSegmentVisible=" + this.isPathSegmentVisible + " " + (int)dArray[0] + " " + (int)dArray[1]);
                }
                if (n2 != 0 && this.isPathSegmentVisible) {
                    if (this.debugPath) {
                        System.out.println("pdf_context.lineTo(" + this.coordsToStringParam(dArray, 2) + ")");
                    }
                    this.lineTo(dArray);
                } else if (n2 != this.isPathSegmentVisible) {
                    if (!this.isPathSegmentVisible) {
                        if (graphicsState.getFillType() != 2) {
                            this.moveTo(this.entryPoint);
                            this.hasMoveTo = true;
                            if (this.debugPath) {
                                System.out.println("pdf_context.moveTo(" + this.coordsToStringParam(dArray, 2));
                            }
                        } else {
                            if (!this.hasMoveTo && !rectangle.contains(dArray2[0], dArray2[1])) {
                                double d = rectangle.x + rectangle.width;
                                double d2 = rectangle.y + rectangle.height;
                                if (d > this.lastInvisiblePoint[0]) {
                                    d = rectangle.x;
                                }
                                if (this.lastInvisiblePoint[1] < (double)rectangle.y) {
                                    d2 = rectangle.y;
                                } else if (d2 < this.lastInvisiblePoint[1]) {
                                    d2 = rectangle.y;
                                }
                                double[] dArray3 = new double[]{d, d2};
                                this.hasMoveTo = true;
                                this.moveTo(dArray3);
                                if (this.debugPath) {
                                    System.out.println("pdf_context.moveTo(" + this.coordsToStringParam(dArray3, 2));
                                }
                            }
                            this.lineTo(this.entryPoint);
                        }
                        this.lineTo(dArray);
                        if (this.debugPath) {
                            System.out.println("pdf_context.lineTo(" + this.coordsToStringParam(dArray, 2) + ");");
                        }
                        this.isPathSegmentVisible = true;
                    } else {
                        this.lineTo(this.exitPoint);
                        this.isPathSegmentVisible = false;
                        if (this.debugPath) {
                            System.out.println("pdf_context.lineTo(" + this.coordsToStringParam(this.exitPoint, 2) + ");");
                        }
                    }
                }
            } else if (this.pathCommand == 2) {
                if (this.debugPath) {
                    System.out.println("PathIterator.SEG_QUADTO");
                }
                if (this.testDrawLimits(dArray, 2)) {
                    if (this.debugPath) {
                        System.out.println("pdf_context.quadraticCurveTo(" + this.coordsToStringParam(dArray, 4));
                    }
                    this.quadraticCurveTo(dArray);
                    this.isPathSegmentVisible = true;
                } else {
                    this.isPathSegmentVisible = false;
                }
            } else if (this.pathCommand == 0) {
                if (this.debugPath) {
                    System.out.println("PathIterator.SEG_MOVETO");
                }
                if (this.testDrawLimits(dArray, 0)) {
                    this.isPathSegmentVisible = true;
                    if (this.debugPath) {
                        System.out.println("pdf_context.moveTo(" + this.coordsToStringParam(dArray, 2) + ");");
                    }
                    this.hasMoveTo = true;
                    this.moveTo(dArray);
                } else {
                    this.isPathSegmentVisible = false;
                }
            }
            pathIterator.next();
        }
        if (this.pathCommands.size() == 1) {
            this.pathCommands.clear();
        } else {
            if (!this.isPathSegmentVisible && graphicsState.getFillType() != 2) {
                this.finishShape();
                if (this.debugPath) {
                    System.out.println("pdf_context.closePath();");
                }
            }
            this.applyGraphicsStateToPath(graphicsState);
        }
        if (this.cmd == 83 && n == 6 && this.clipBox != null && this.currentShape.getBounds().width > 10 && this.currentShape.getBounds().height > 10 && this.clipBox.x >= this.currentShape.getBounds().x && this.clipBox.x + this.clipBox.width <= this.currentShape.getBounds().x + this.currentShape.getBounds().width && this.clipBox.y >= this.currentShape.getBounds().y && this.clipBox.y + this.clipBox.height <= this.currentShape.getBounds().y + this.currentShape.getBounds().height) {
            this.pathCommands.clear();
            if (this.debugPath) {
                System.out.println("shape removed");
            }
        }
    }

    protected void moveTo(double[] dArray) {
    }

    protected void quadraticCurveTo(double[] dArray) {
    }

    protected void lineTo(double[] dArray) {
    }

    protected void finishShape() {
    }

    protected void beginShape() {
    }

    protected void bezierCurveTo(double[] dArray) {
    }

    private String setPrecision(double d, boolean bl) {
        if (bl && d < this.minXcoord) {
            this.minXcoord = d;
        } else if (!bl && d < this.minYcoord) {
            this.minYcoord = d;
        }
        String string = String.valueOf(d);
        int n = string.indexOf(".");
        int n2 = string.length();
        int n3 = n2 - n - 1;
        if (n > 0 && n3 > this.dpCount) {
            string = this.dpCount == 0 ? string.substring(0, n + this.dpCount) : string.substring(0, n + this.dpCount + 1);
        }
        return string;
    }

    protected void applyGraphicsStateToPath(GraphicsState graphicsState) {
    }

    protected static String determineLineCap(BasicStroke basicStroke) {
        String string = "";
        switch (basicStroke.getEndCap()) {
            case 1: {
                string = "round";
                break;
            }
            case 2: {
                string = "square";
                break;
            }
            default: {
                string = "butt";
            }
        }
        return string;
    }

    protected static String determineLineJoin(BasicStroke basicStroke) {
        String string = "";
        switch (basicStroke.getLineJoin()) {
            case 1: {
                string = "round";
                break;
            }
            case 2: {
                string = "bevel";
                break;
            }
            default: {
                string = "miter";
            }
        }
        return string;
    }

    private boolean testDrawLimits(double[] dArray, int n) {
        double[] dArray2;
        double d;
        double d2;
        if (this.includeClip) {
            return true;
        }
        if (this.debugPath) {
            System.out.println("testDrawLimits coords[0] + coords[1]=" + (int)dArray[0] + " " + (int)dArray[1]);
        }
        int n2 = OutputShape.getCoordOffset(n);
        boolean bl = false;
        if (this.debugPath) {
            System.out.println("crop=" + this.cropBox + " clip=" + this.clipBox);
        }
        Rectangle rectangle = this.cropBox;
        if (this.clipBox != null) {
            rectangle = rectangle.intersection(this.clipBox);
            if (this.debugPath) {
                System.out.println("merged crop=" + rectangle);
            }
        }
        if ((d2 = dArray[n2]) > (double)(rectangle.x + 1)) {
            d2 -= 1.0;
        }
        if ((d = dArray[n2 + 1]) > (double)(rectangle.y + 1)) {
            d -= 1.0;
        }
        if (rectangle.contains((dArray2 = new double[]{d2, d})[0], dArray2[1])) {
            this.lastVisiblePoint = dArray2;
            bl = true;
            if (this.debugPath) {
                System.out.println("Point visible in cropBox or clip");
            }
        } else {
            this.lastInvisiblePoint = dArray2;
            bl = false;
            if (this.debugPath) {
                System.out.println("Point invisible " + (int)dArray2[0] + " " + (int)dArray2[1] + " crop=" + rectangle.getBounds());
            }
        }
        if (!bl && this.isPathSegmentVisible) {
            if (this.debugPath) {
                System.out.println("Case1 this point " + (int)d2 + "," + (int)d + " invisible and isPathSegmentVisible");
            }
            this.findSwitchPoint(dArray2, true);
        } else if (bl && !this.isPathSegmentVisible) {
            if (this.debugPath) {
                System.out.println("Case2 this point " + (int)d2 + "," + (int)d + " visible and isPathSegment invisible");
            }
            this.findSwitchPoint(dArray2, false);
        } else if (this.debugPath) {
            System.out.println("Case3 NOT COVERED isCurrentPointVisible=" + bl + " isPathSegmentVisible" + this.isPathSegmentVisible);
        }
        if (!bl && !rectangle.contains(this.previousPoint[0], this.previousPoint[1]) && n == 1) {
            if (this.debugPath) {
                System.out.println("checkTraversalPoints");
            }
            this.checkTraversalPoints(dArray2, this.previousPoint, rectangle);
        }
        this.previousPoint = dArray2;
        return bl;
    }

    private void checkTraversalPoints(double[] dArray, double[] dArray2, Rectangle rectangle) {
        double d;
        boolean bl = dArray2[0] < (double)rectangle.x && dArray[0] > (double)(rectangle.x + rectangle.width) || dArray[0] < (double)rectangle.x && dArray2[0] > (double)(rectangle.x + rectangle.width);
        boolean bl2 = dArray2[1] < (double)rectangle.y && dArray[1] > (double)(rectangle.y + rectangle.height) || dArray[1] < (double)rectangle.y && dArray2[1] > (double)(rectangle.y + rectangle.height);
        boolean bl3 = OutputShape.isCompleteCropBoxMiss(dArray, dArray2, rectangle);
        if (this.debugPath) {
            System.out.println("checkTraversalPoints xtrav=" + bl + " yTrav=" + bl2 + " completeCropBoxMiss=" + bl3 + " " + (dArray2[0] < (double)rectangle.x && dArray[0] > (double)(rectangle.x + rectangle.width)));
            System.out.println("start=" + (int)dArray[0] + " " + (int)dArray[1] + "  end=" + (int)dArray2[0] + " " + (int)dArray2[1]);
        }
        if (!bl && !bl2) {
            return;
        }
        double d2 = dArray[0] - dArray2[0];
        double d3 = dArray[1] - dArray2[1];
        double d4 = d = (dArray2[1] - dArray[1]) / (dArray2[0] - dArray[0]);
        if (Math.abs(dArray2[0] - dArray[0]) < 1.0) {
            d = 0.0;
        }
        if (d < 0.001) {
            d = 0.0;
        }
        if (d == 0.0) {
            if (d4 < 0.0 && dArray2[0] < 0.0 && dArray2[0] < dArray[0]) {
                this.exitPoint = OutputShape.calcCrossoverPoint(dArray2, rectangle, d, dArray);
                this.entryPoint = OutputShape.calcCrossoverPoint(dArray, rectangle, d, dArray2);
            } else {
                this.entryPoint = OutputShape.calcCrossoverPoint(dArray2, rectangle, d, dArray);
                this.exitPoint = OutputShape.calcCrossoverPoint(dArray, rectangle, d, dArray2);
            }
        } else {
            this.exitPoint = OutputShape.calcCrossoverPoint(dArray2, rectangle, d, dArray);
            this.entryPoint = OutputShape.calcCrossoverPoint(dArray, rectangle, d, dArray2);
        }
        if (this.debugPath) {
            System.out.println("entry=" + this.entryPoint[0] + " " + this.entryPoint[1] + " exit=" + this.exitPoint[0] + " " + this.exitPoint[1]);
            System.out.println("XXpdf_context.lineTo(" + this.coordsToStringParam(this.entryPoint, 2) + ");");
            System.out.println("XXpdf_context.lineTo(" + this.coordsToStringParam(this.exitPoint, 2) + "); hasMoveTo=" + this.hasMoveTo);
        }
        if (!this.hasMoveTo && dArray2[0] < 0.0 && dArray[0] > this.entryPoint[0] && this.entryPoint[0] > this.exitPoint[0]) {
            double d5 = rectangle.x + rectangle.width;
            double d6 = rectangle.y + rectangle.height;
            if (d5 > this.lastVisiblePoint[0]) {
                d5 = rectangle.x;
            }
            if (d6 < this.lastVisiblePoint[1]) {
                d6 = rectangle.y;
            }
            double[] dArray3 = new double[]{d5, d6};
            this.hasMoveTo = true;
            this.moveTo(dArray3);
            if (this.debugPath) {
                System.out.println("pdf_context.moveTo(" + this.coordsToStringParam(dArray3, 2));
            }
            this.lineTo(this.exitPoint);
            this.lineTo(this.entryPoint);
        } else {
            this.lineTo(this.entryPoint);
            this.lineTo(this.exitPoint);
        }
    }

    private static double[] calcCrossoverPoint(double[] dArray, Rectangle rectangle, double d, double[] dArray2) {
        double d2 = 0.0;
        double d3 = 0.0;
        if (dArray[1] < (double)rectangle.y || dArray[1] > (double)(rectangle.y + rectangle.height)) {
            d3 = dArray[1] < (double)rectangle.y ? (double)rectangle.y : (double)(rectangle.y + rectangle.height);
            d2 = d == 0.0 ? dArray[0] : (d3 - dArray[1]) / d + dArray[0];
            if (d2 < (double)rectangle.x || d2 > (double)(rectangle.x + rectangle.width)) {
                d2 = d2 < (double)rectangle.x ? (double)rectangle.x : (double)(rectangle.x + rectangle.width);
                d3 = d * (d2 - dArray[0]) + dArray[1];
            }
        } else if ((dArray[0] < (double)rectangle.x || dArray[0] > (double)(rectangle.x + rectangle.width)) && ((d3 = d * ((d2 = dArray[0] < (double)rectangle.x ? (double)rectangle.x : (double)(rectangle.x + rectangle.width)) - dArray[0]) + dArray[1]) < (double)rectangle.y || d3 > (double)(rectangle.y + rectangle.height))) {
            d3 = dArray[1] < (double)rectangle.y ? (double)rectangle.y : (double)(rectangle.y + rectangle.height);
            d2 = (d3 - dArray[1]) / d + dArray[0];
        }
        return new double[]{d2, d3};
    }

    private void findSwitchPoint(double[] dArray, boolean bl) {
        double d;
        double d2;
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = dArray2 = bl ? this.lastVisiblePoint : this.lastInvisiblePoint;
        if (this.debugPath) {
            if (bl) {
                System.out.println("Find point of exit lastPoint=" + (int)dArray2[0] + " " + (int)dArray2[1] + " current=" + (int)dArray[0] + " " + (int)dArray[1]);
            } else {
                System.out.println("Find point of entry lastPoint=" + (int)dArray2[0] + " " + (int)dArray2[1] + " current=" + (int)dArray[0] + " " + (int)dArray[1]);
            }
        }
        if (!bl) {
            double[] dArray5 = dArray;
            dArray = dArray2;
            dArray2 = dArray5;
        }
        double d3 = dArray[0] - dArray2[0];
        double d4 = dArray[1] - dArray2[1];
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.clipBox != null && dArray[0] >= (double)(this.clipBox.width + this.clipBox.x)) {
            dArray3[0] = this.clipBox.width + this.clipBox.x;
            bl2 = true;
        } else if (dArray[0] >= (double)(this.cropBox.width + this.cropBox.x)) {
            dArray3[0] = this.cropBox.width + this.cropBox.x;
            bl2 = true;
        } else if (this.clipBox != null && dArray[0] < (double)this.clipBox.x) {
            dArray3[0] = this.clipBox.x;
            bl2 = true;
        } else if (dArray[0] < (double)this.cropBox.x) {
            dArray3[0] = this.cropBox.x;
            bl2 = true;
        }
        if (this.clipBox != null && dArray[1] > (double)(this.clipBox.height + this.clipBox.y)) {
            dArray3[1] = this.clipBox.height + this.clipBox.y;
            bl3 = true;
        } else if (dArray[1] > (double)(this.cropBox.height + this.cropBox.y)) {
            dArray3[1] = this.cropBox.height + this.cropBox.y;
            bl3 = true;
        } else if (this.clipBox != null && dArray[1] < (double)this.clipBox.y) {
            dArray3[1] = this.clipBox.y;
            bl3 = true;
        } else if (dArray[1] < (double)this.cropBox.y) {
            dArray3[1] = this.cropBox.y;
            bl3 = true;
        }
        if (bl3) {
            if (d3 == 0.0) {
                dArray3[0] = dArray[0];
            } else {
                d2 = d3 / d4;
                if (d4 == 0.0) {
                    d2 = 1.0;
                }
                d = dArray3[1] - dArray[1];
                dArray3[0] = dArray[0] + d2 * d;
            }
        }
        if (bl2) {
            if (d4 == 0.0) {
                dArray3[1] = dArray[1];
            } else {
                d2 = d4 / d3;
                d = dArray3[0] - dArray[0];
                dArray3[1] = dArray[1] + d2 * d;
            }
        }
        if (bl) {
            this.exitPoint = dArray3;
            if (this.debugPath) {
                System.out.println("returns exit=" + (int)dArray3[0] + " " + (int)dArray3[1]);
            }
        } else {
            this.entryPoint = dArray3;
            if (this.debugPath) {
                System.out.println("returns entry=" + (int)dArray3[0] + " " + (int)dArray3[1]);
            }
        }
    }

    private void checkLargeBox(double[] dArray, int n) {
        if (this.debugPath) {
            System.out.println("check large " + (int)dArray[0] + " " + (int)dArray[1]);
        }
        if (!(this.isLargeBox || n == 1 && n == 0)) {
            return;
        }
        double d = dArray[OutputShape.getCoordOffset(n)];
        double d2 = dArray[OutputShape.getCoordOffset(n) + 1];
        double[] dArray2 = this.correctCoords(new double[]{d, d2});
        d = dArray2[0];
        d2 = dArray2[1];
        Point point = new Point((int)d, (int)d2);
        if (this.largeBox.isEmpty()) {
            this.largeBox.add(point);
        } else {
            Point point2 = (Point)this.largeBox.get(this.largeBox.size() - 1);
            double d3 = ((Point2D)point2).getX() - point.getX();
            double d4 = ((Point2D)point2).getY() - point.getY();
            if (this.largeBox.size() == 1) {
                this.largeBoxSideAlternation = d4 != 0.0 ? d3 / d4 != 0.0 : true;
            }
            if (d3 / d4 == 0.0 || d4 / d3 == 0.0) {
                boolean bl;
                boolean bl2 = bl = d3 / d4 == 0.0;
                if (this.largeBox.size() > 1 || bl != this.largeBoxSideAlternation) {
                    this.largeBox.add(point);
                    this.largeBoxSideAlternation = d3 / d4 == 0.0;
                }
            } else if (!point.equals(this.largeBox.get(this.largeBox.size() - 1))) {
                this.isLargeBox = false;
                return;
            }
            if (this.largeBox.size() >= 4 && this.isLargerThanCropBox()) {
                this.drawCropBox();
            }
        }
    }

    private boolean isLargerThanCropBox() {
        int n;
        if (!this.isLargeBox) {
            return false;
        }
        Point point = (Point)this.largeBox.get(this.largeBox.size() - 4);
        Point point2 = (Point)this.largeBox.get(this.largeBox.size() - 3);
        Point point3 = (Point)this.largeBox.get(this.largeBox.size() - 2);
        Point point4 = (Point)this.largeBox.get(this.largeBox.size() - 1);
        int n2 = n = this.cropBox.width < this.cropBox.height ? this.cropBox.width : this.cropBox.height;
        if (point.distance(point2) < (double)n || point2.distance(point3) < (double)n || point3.distance(point4) < (double)n) {
            return false;
        }
        int n3 = 0;
        if (!this.cropBox.contains(((Point2D)point).getX(), ((Point2D)point).getY())) {
            ++n3;
        }
        if (!this.cropBox.contains(((Point2D)point2).getX(), ((Point2D)point2).getY())) {
            ++n3;
        }
        if (!this.cropBox.contains(((Point2D)point3).getX(), ((Point2D)point3).getY())) {
            ++n3;
        }
        if (!this.cropBox.contains(((Point2D)point4).getX(), ((Point2D)point4).getY())) {
            ++n3;
        }
        if (n3 <= 2) {
            return false;
        }
        HashSet<Point> hashSet = new HashSet<Point>();
        hashSet.add(point);
        hashSet.add(point2);
        hashSet.add(point3);
        hashSet.add(point4);
        n3 = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0) continue;
                Rectangle rectangle = new Rectangle(this.cropBox);
                rectangle.translate(j * this.cropBox.width, i * this.cropBox.height);
                if (!OutputShape.doesPointSetCollide(hashSet, rectangle)) continue;
                ++n3;
            }
        }
        return n3 >= 3;
    }

    private static boolean doesPointSetCollide(Set set, Rectangle rectangle) {
        for (Point2D point2D : set) {
            if (!rectangle.contains(point2D)) continue;
            return true;
        }
        return false;
    }

    protected void drawCropBox() {
    }

    private double getClosestCropEdgeX(double d) {
        return d < (double)(this.cropBox.x + this.cropBox.width / 2) ? (double)this.cropBox.x : (double)(this.cropBox.x + this.cropBox.width);
    }

    private double getClosestCropEdgeY(double d) {
        return d < (double)(this.cropBox.y + this.cropBox.height / 2) ? (double)this.cropBox.y : (double)(this.cropBox.y + this.cropBox.height);
    }

    private double[] correctCoords(double[] dArray) {
        int n;
        switch (this.pathCommand) {
            case 3: {
                n = 4;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            default: {
                n = 0;
            }
        }
        if (n > dArray.length) {
            n = dArray.length - 2;
        }
        for (int i = 0; i < n + 2; i += 2) {
            dArray[i + 1] = dArray[i + 1] + (double)this.adjustY;
            dArray[i] = dArray[i] - this.midPoint.getX() + (double)this.minX;
            int n2 = i;
            dArray[n2] = dArray[n2] + (double)(this.cropBox.width / 2);
            dArray[i + 1] = dArray[i + 1] - this.midPoint.getY() + (double)this.minY;
            dArray[i + 1] = 0.0 - dArray[i + 1];
            int n3 = i + 1;
            dArray[n3] = dArray[n3] + (double)(this.cropBox.height / 2);
        }
        return dArray;
    }

    private static int getCoordOffset(int n) {
        int n2;
        switch (n) {
            case 3: {
                n2 = 4;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    private static boolean isCompleteCropBoxMiss(double[] dArray, double[] dArray2, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = n + rectangle.width;
        int n3 = rectangle.y;
        int n4 = n2 + rectangle.height;
        return (dArray[0] < (double)n && dArray2[0] < (double)n || dArray[0] > (double)n2 && dArray2[0] > (double)n2) && (dArray[1] < (double)n3 && dArray2[1] < (double)n3 || dArray[1] > (double)n4 && dArray2[1] > (double)n4);
    }

    protected String coordsToStringParam(double[] dArray, int n) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        System.arraycopy(dArray, 0, dArray2, 0, n2);
        dArray = this.correctCoords(dArray2);
        return this.convertCoords(dArray, n);
    }

    protected String convertCoords(double[] dArray, int n) {
        String string = "";
        if (this.pageRotation == 90 || this.pageRotation == 270) {
            for (int i = 0; i < n; i += 2) {
                if (i != 0) {
                    string = string + ",";
                }
                if (this.ctm[0][0] == 0.0f && this.ctm[1][1] == 0.0f && this.ctm[0][1] > 0.0f && (this.ctm[1][0] < 0.0f || (double)Math.abs(this.ctm[1][0]) < 0.5)) {
                    string = string + this.setPrecision(((double)this.cropBox.height - dArray[i + 1]) * (double)this.scaling + (double)this.yOffset, false);
                    string = string + ",";
                    string = string + this.setPrecision(dArray[i] * (double)this.scaling, (i & 1) != 1);
                    continue;
                }
                string = string + this.setPrecision(((double)(this.cropBox.height - 20) - dArray[i + 1]) * (double)this.scaling + (double)this.yOffset, false);
                string = string + ",";
                string = string + this.setPrecision(dArray[i] * (double)this.scaling, (i & 1) != 1);
            }
        } else {
            for (int i = 0; i < n; i += 2) {
                if (i != 0) {
                    string = string + ",";
                }
                string = string + this.setPrecision(dArray[i] * (double)this.scaling, true);
                if (i + 1 != 0) {
                    string = string + ",";
                }
                string = string + this.setPrecision(dArray[i + 1] * (double)this.scaling + (double)this.yOffset, false);
            }
        }
        return string;
    }

    protected static String rgbToCSSColor(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        return "rgb(" + n2 + "," + n3 + "," + n4 + ")";
    }

    public String getContent() {
        int n = this.pathCommands.size();
        StringBuilder stringBuilder = new StringBuilder(n * 15);
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append('\t');
            }
            stringBuilder.append(this.pathCommands.get(i));
            if (i == n - 1) continue;
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public boolean isEmpty() {
        return this.pathCommands.isEmpty();
    }

    public int getShapeColor() {
        return this.currentColor;
    }

    public double getMinXcoord() {
        return this.minXcoord;
    }

    public double getMinYcoord() {
        return this.minYcoord;
    }
}

