/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.parts;

import de.rcenvironment.core.component.workflow.execution.impl.WorkflowExecutionInformationImpl;
import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.Location;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.editor.commands.ConnectionBendpointEditPolicy;
import de.rcenvironment.core.gui.workflow.editor.commands.ConnectionDeletionPolicy;
import de.rcenvironment.core.gui.workflow.editor.properties.ComponentPropertySource;
import de.rcenvironment.core.gui.workflow.parts.ConnectionWrapper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.ui.views.properties.IPropertySource;

public class ConnectionPart
extends AbstractConnectionEditPart
implements PropertyChangeListener {
    private Label relationshipLabel;

    public IFigure createFigure() {
        Polyline figure = (Polyline)super.createFigure();
        PolylineConnection connection = new PolylineConnection();
        connection.setPoints(figure.getPoints());
        ConnectionWrapper wrapper = (ConnectionWrapper)this.getModel();
        if (wrapper.getSourceArrow()) {
            connection.setSourceDecoration((RotatableDecoration)new PolylineDecoration());
        }
        if (wrapper.getTargetArrow()) {
            connection.setTargetDecoration((RotatableDecoration)new PolylineDecoration());
        }
        if (!wrapper.getSource().getIdentifierAsObject().equals((Object)wrapper.getTarget().getIdentifierAsObject())) {
            ConnectionLocator connectionLocator = new ConnectionLocator((org.eclipse.draw2d.Connection)connection, 4);
            connectionLocator.setRelativePosition(29);
            connectionLocator.setGap(5);
            this.relationshipLabel = new Label(String.valueOf(((ConnectionWrapper)this.getModel()).getNumberOfConnections()));
            this.relationshipLabel.setVisible(false);
            connection.add((IFigure)this.relationshipLabel, (Object)connectionLocator);
        }
        return connection;
    }

    public void activate() {
        super.activate();
        Object model = ((ScalableFreeformRootEditPart)this.getParent()).getContents().getModel();
        WorkflowDescription workflowDescription = this.getWorkflowDescriptionFromModelObject(model);
        for (Connection connection : workflowDescription.getConnections()) {
            connection.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void deactivate() {
        super.deactivate();
        Object model = ((ScalableFreeformRootEditPart)this.getParent()).getContents().getModel();
        WorkflowDescription workflowDescription = this.getWorkflowDescriptionFromModelObject(model);
        for (Connection connection : workflowDescription.getConnections()) {
            connection.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    protected void refreshVisuals() {
        EditPart parent = this.getParent();
        if (parent != null) {
            EditPartViewer viewer = parent.getViewer();
            EditPart contents = viewer.getContents();
            Object modelObject = contents.getModel();
            WorkflowDescription workflowDescription = this.getWorkflowDescriptionFromModelObject(modelObject);
            ConnectionWrapper connectionWrapper = (ConnectionWrapper)this.getModel();
            for (Connection connection : workflowDescription.getConnections()) {
                if (!connectionWrapper.getSource().getIdentifierAsObject().equals((Object)connection.getSourceNode().getIdentifierAsObject()) || !connectionWrapper.getTarget().getIdentifierAsObject().equals((Object)connection.getTargetNode().getIdentifierAsObject())) continue;
                this.addBendpointsFromModelToGraphics(connection);
                return;
            }
        }
    }

    public Object getAdapter(Class type) {
        if (type == SnapToHelper.class) {
            ArrayList<Object> helpers = new ArrayList<Object>();
            if (Boolean.TRUE.equals(this.getViewer().getProperty("SnapToGeometry.isEnabled"))) {
                helpers.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if (Boolean.TRUE.equals(this.getViewer().getProperty("SnapToGrid.isEnabled"))) {
                helpers.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (helpers.size() == 0) {
                return null;
            }
            return new CompoundSnapToHelper(helpers.toArray(new SnapToHelper[0]));
        }
        if (type == IPropertySource.class && this.getModel() instanceof WorkflowNode) {
            return new ComponentPropertySource(this.getViewer().getEditDomain().getCommandStack(), (WorkflowNode)this.getModel());
        }
        return super.getAdapter(type);
    }

    private void addBendpointsFromModelToGraphics(Connection matchingConnection) {
        org.eclipse.draw2d.Connection connection = this.getConnectionFigure();
        ArrayList<AbsoluteBendpoint> figureConstraint = new ArrayList<AbsoluteBendpoint>();
        for (Location location : matchingConnection.getBendpoints()) {
            figureConstraint.add(new AbsoluteBendpoint(new Point(location.x, location.y)));
        }
        connection.setRoutingConstraint(figureConstraint);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new ConnectionDeletionPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new ConnectionBendpointEditPolicy());
    }

    public void hideLabel() {
        if (this.relationshipLabel != null) {
            this.relationshipLabel.setVisible(false);
        }
    }

    public void showLabel() {
        if (this.relationshipLabel != null) {
            this.relationshipLabel.setVisible(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("de.rcenvironment.bendpoint")) {
            this.refreshVisuals();
        }
    }

    private WorkflowDescription getWorkflowDescriptionFromModelObject(Object modelObject) {
        WorkflowDescription workflowDescription = null;
        if (modelObject instanceof WorkflowDescription) {
            workflowDescription = (WorkflowDescription)modelObject;
        } else if (modelObject instanceof WorkflowExecutionInformationImpl) {
            workflowDescription = ((WorkflowExecutionInformationImpl)modelObject).getWorkflowDescription();
        }
        return workflowDescription;
    }
}

