/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.EndpointHandlingHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class EndpointContentProvider
implements ITreeContentProvider {
    private EndpointType type;

    public EndpointContentProvider(EndpointType type) {
        this.type = type;
    }

    public Object[] getChildren(Object element) {
        if (element instanceof WorkflowDescription) {
            List items = ((WorkflowDescription)element).getWorkflowNodes();
            Collections.sort(items);
            return items.toArray();
        }
        if (element instanceof WorkflowNode) {
            ArrayList<Endpoint> items = new ArrayList<Endpoint>();
            items.addAll(EndpointHandlingHelper.getEndpoints((WorkflowNode)element, this.type));
            Collections.sort(items);
            return items.toArray();
        }
        ArrayList items = new ArrayList();
        Collections.sort(items);
        return items.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element) != null && this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer view, Object object1, Object object2) {
    }

    public static class Endpoint
    extends EndpointItem {
        private static final long serialVersionUID = 1633769598091968303L;
        private WorkflowNode parent;

        public Endpoint(WorkflowNode parent, EndpointDescription endpointDesc) {
            super(endpointDesc);
            this.parent = parent;
        }

        public WorkflowNode getWorkflowNode() {
            return this.parent;
        }
    }

    public static class EndpointItem
    implements Serializable,
    Comparable<EndpointItem> {
        private static final long serialVersionUID = 777733457712592306L;
        private String name;
        private EndpointDescription endpointDesc;

        public EndpointItem(EndpointDescription endpointDesc) {
            this.endpointDesc = endpointDesc;
            this.name = endpointDesc.getName();
        }

        public String getName() {
            return this.name;
        }

        public EndpointDescription getEndpointDescription() {
            return this.endpointDesc;
        }

        public String getShortName() {
            return this.name;
        }

        @Override
        public int compareTo(EndpointItem o) {
            return this.name.compareTo(o.getName());
        }
    }
}

