/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.integration;

import de.rcenvironment.core.component.model.configuration.api.ReadOnlyConfiguration;
import de.rcenvironment.core.gui.utils.common.widgets.LineNumberStyledText;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.integration.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class BaseScriptReadOnlySection
extends ValidatingWorkflowNodePropertySection {
    private LineNumberStyledText scriptText;
    private final String scriptName;

    public BaseScriptReadOnlySection(String scriptName) {
        this.scriptName = scriptName;
    }

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, true));
        Section scriptSection = this.getWidgetFactory().createSection(composite, 256);
        scriptSection.setLayoutData((Object)new GridData(1808));
        if (this.scriptName.equals("preScript")) {
            scriptSection.setText(Messages.preScriptSection);
        } else {
            scriptSection.setText(Messages.postScriptSection);
        }
        Composite scriptComposite = this.getWidgetFactory().createFlatFormComposite((Composite)scriptSection);
        scriptComposite.setLayout((Layout)new GridLayout(1, false));
        scriptComposite.setLayoutData((Object)new GridData(1808));
        this.scriptText = new LineNumberStyledText(scriptComposite, 2122);
        this.scriptText.setLayoutData((Object)new GridData(1808));
        scriptSection.setClient((Control)scriptComposite);
        this.scriptText.setEditable(false);
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.scriptText.setText("");
        ReadOnlyConfiguration readOnlyConfig = this.getConfiguration().getConfigurationDescription().getComponentConfigurationDefinition().getReadOnlyConfiguration();
        String script = readOnlyConfig.getValue(this.scriptName);
        if (script != null) {
            this.scriptText.setText(script);
        }
        this.scriptText.setBackgroundEnabled(false);
    }

    public void refreshSection() {
        super.refreshSection();
        this.aboutToBeShown();
    }
}

