/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.workflowintegration.editor.pages;

import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.gui.integration.common.editor.IntegrationEditor;
import de.rcenvironment.core.gui.integration.common.editor.IntegrationEditorPage;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.WorkflowIntegrationEditor;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.mappingtreenodes.ComponentNode;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.mappingtreenodes.MappingNode;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.pages.MappingTreeComparator;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.pages.MappingTreeContentProvider;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.pages.MappingTreeFilterWidget;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.pages.MappingValidator;
import de.rcenvironment.core.gui.resources.api.ColorManager;
import de.rcenvironment.core.gui.resources.api.ColorSource;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardColors;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class MappingPage
extends IntegrationEditorPage {
    private static final int COLUMN4_WIDTH = 200;
    private static final int COLUMN3_WIDTH = 300;
    private static final int COLUMN2_WIDTH = 80;
    private static final int COLUMN1_WIDTH = 70;
    private static final int COLUMN0_WIDTH = 200;
    private static final String DEFAULT_MESSAGE = "Select inputs and outputs to serve as the inputs and outputs, respectively, for the integrated workflow component.\nNote that the inputs with the constraint 'Required' are mandatory.";
    private static final String[] TABLE_TITLES = new String[]{"Component", "Type", "DataType", "Details", "Mapped Name"};
    private static final String HELP_CONTEXT_ID = "de.rcenvironment.core.gui.integration.workflowintegration.integration_mapping";
    private CheckboxTreeViewer treeViewer;
    private MappingTreeContentProvider contentProvider;
    private WorkflowIntegrationEditor integrationEditor;
    private Action resetExternalNameAction;
    private MenuManager treeViewerMenuManager;
    private Action useInternalNameAction;
    private Action checkNodeAction;
    private Action uncheckNodeAction;

    public MappingPage(WorkflowIntegrationEditor integrationEditor, CTabFolder container, MappingTreeContentProvider contentProvider) {
        super((IntegrationEditor)integrationEditor, container, "Mapping");
        this.integrationEditor = integrationEditor;
        this.contentProvider = contentProvider;
    }

    public void createContent(Composite container) {
        Composite tools = new Composite(container, 0);
        tools.setLayoutData((Object)new GridData(896));
        GridLayout toolbarLayout = new GridLayout(2, false);
        toolbarLayout.marginWidth = 0;
        tools.setLayout((Layout)toolbarLayout);
        tools.setBackground(ColorManager.getInstance().getSharedColor((ColorSource)StandardColors.RCE_WHITE));
        ToolBar toolbar = new ToolBar(tools, 0);
        toolbar.setBackground(ColorManager.getInstance().getSharedColor((ColorSource)StandardColors.RCE_WHITE));
        ToolItem expandAllButton = new ToolItem(toolbar, 8);
        expandAllButton.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.EXPAND_ALL));
        expandAllButton.addListener(13, event -> {
            this.treeViewer.getControl().setVisible(false);
            this.treeViewer.expandAll();
            this.treeViewer.getControl().setVisible(true);
        });
        ToolItem collapseAllButton = new ToolItem(toolbar, 8);
        collapseAllButton.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.COLLAPSE_ALL));
        collapseAllButton.addListener(13, event -> {
            this.treeViewer.getControl().setVisible(false);
            this.treeViewer.collapseAll();
            this.treeViewer.getControl().setVisible(true);
        });
        Tree tree = new Tree(container, 67618);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.treeViewer = new CheckboxTreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        GridData viewerGridData = new GridData(1808);
        this.treeViewer.getControl().setLayoutData((Object)viewerGridData);
        this.treeViewer.setInput((Object)this.contentProvider.getRoot());
        this.treeViewer.setComparator((ViewerComparator)new MappingTreeComparator());
        this.createColumns();
        new MappingTreeFilterWidget(tools, this.treeViewer);
        this.treeViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                if (element instanceof MappingNode) {
                    return !((MappingNode)element).isCheckable();
                }
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof MappingNode) {
                    return ((MappingNode)element).isChecked();
                }
                if (element instanceof ComponentNode && ((ComponentNode)element).hasChildren()) {
                    return Arrays.stream(((ComponentNode)element).getChildren()).filter(MappingNode.class::isInstance).map(MappingNode.class::cast).allMatch(MappingNode::isChecked);
                }
                return false;
            }
        });
        this.addTreeListeners();
        this.treeViewer.refresh();
        this.setMessage(DEFAULT_MESSAGE);
        this.treeViewerMenuManager = this.hookContextMenu();
        this.createActions();
    }

    private void addTreeListeners() {
        this.treeViewer.addCheckStateListener(event -> {
            MappingNode node;
            if (event.getElement() instanceof ComponentNode) {
                this.setSubtreeChecked((ComponentNode)event.getElement(), event.getChecked());
            }
            if (event.getElement() instanceof MappingNode && (node = (MappingNode)event.getElement()).isCheckable()) {
                node.setChecked(event.getChecked());
                this.validateMappedName(node);
            }
            this.integrationEditor.updateDirty();
            this.treeViewer.refresh();
        });
        this.treeViewer.getControl().addListener(8, event -> {
            MappingNode node;
            Point clickCoords = new Point(event.x, event.y);
            if (this.treeViewer.getCell(clickCoords) == null) {
                return;
            }
            TreeItem item = this.treeViewer.getTree().getItem(clickCoords);
            ViewerCell cell = this.treeViewer.getCell(clickCoords);
            if (cell.getViewerRow().getBounds().contains(clickCoords) && item.getData() instanceof ComponentNode) {
                this.treeViewer.setExpandedState(item.getData(), !this.treeViewer.getExpandedState(item.getData()));
            }
            if (item.getData() instanceof MappingNode && (node = (MappingNode)item.getData()).isCheckable()) {
                node.setChecked(!node.isChecked());
                this.validateMappedName(node);
                this.integrationEditor.updateDirty();
                this.treeViewer.refresh();
                this.treeViewer.editElement((Object)node, 4);
            }
        });
        this.treeViewer.getTree().addListener(13, event -> {
            List<MappingNode> selectedMappingNodes = this.getSelectedMappingNodes();
            if (selectedMappingNodes.size() == 1 && selectedMappingNodes.iterator().next().isChecked()) {
                this.treeViewer.editElement(event.item.getData(), 4);
            }
        });
        this.treeViewer.getTree().addMenuDetectListener(e -> this.updateContextMenu());
        this.treeViewer.getTree().addListener(1, e -> {
            if (e.character == '\u001b') {
                this.treeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        });
    }

    private void updateContextMenu() {
        this.treeViewerMenuManager.removeAll();
        List<MappingNode> selectedMappingNodes = this.getSelectedMappingNodes();
        if (selectedMappingNodes.isEmpty()) {
            return;
        }
        boolean allNodesChecked = selectedMappingNodes.stream().allMatch(MappingNode::isChecked);
        boolean anyNodeUnchecked = selectedMappingNodes.stream().filter(MappingNode::isCheckable).anyMatch(node -> !node.isChecked());
        boolean anyNodeChecked = selectedMappingNodes.stream().filter(MappingNode::isCheckable).anyMatch(MappingNode::isChecked);
        this.useInternalNameAction.setEnabled(allNodesChecked && selectedMappingNodes.stream().anyMatch(n -> !n.getExternalName().equals(n.getInternalName())));
        this.resetExternalNameAction.setEnabled(allNodesChecked && selectedMappingNodes.stream().anyMatch(n -> !n.getExternalName().equals(n.getDefaultExternalName())));
        this.checkNodeAction.setEnabled(anyNodeUnchecked);
        this.uncheckNodeAction.setEnabled(anyNodeChecked);
        this.treeViewerMenuManager.add((IAction)this.useInternalNameAction);
        this.treeViewerMenuManager.add((IAction)this.resetExternalNameAction);
        this.treeViewerMenuManager.add((IContributionItem)new Separator());
        this.treeViewerMenuManager.add((IAction)this.checkNodeAction);
        this.treeViewerMenuManager.add((IAction)this.uncheckNodeAction);
    }

    private List<MappingNode> getSelectedMappingNodes() {
        TreeItem[] selectedItems = this.treeViewer.getTree().getSelection();
        return Arrays.stream(selectedItems).map(Widget::getData).filter(MappingNode.class::isInstance).map(MappingNode.class::cast).collect(Collectors.toList());
    }

    private MenuManager hookContextMenu() {
        MenuManager menuManager = new MenuManager();
        Menu treeContextMenu = menuManager.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(treeContextMenu);
        return menuManager;
    }

    private void createActions() {
        this.useInternalNameAction = this.createUseInternalNameAction();
        this.resetExternalNameAction = this.createResetExternalNameActions();
        this.checkNodeAction = this.createCheckAction();
        this.uncheckNodeAction = this.createUncheckAction();
    }

    private Action createResetExternalNameActions() {
        return new Action("Reset Mapped Name to Default"){

            public void run() {
                MappingPage.this.getSelectedMappingNodes().stream().filter(MappingNode::isChecked).forEach(node -> {
                    node.setDefaultExternalName();
                    MappingPage.this.validateMappedName((MappingNode)node);
                });
                MappingPage.this.treeViewer.refresh();
            }
        };
    }

    private Action createUseInternalNameAction() {
        return new Action("Use Origin Name as Mapped Name"){

            public void run() {
                MappingPage.this.getSelectedMappingNodes().stream().filter(MappingNode::isChecked).forEach(node -> {
                    node.setExternalName(node.getInternalName());
                    MappingPage.this.validateMappedName((MappingNode)node);
                });
                MappingPage.this.treeViewer.refresh();
            }
        };
    }

    private Action createCheckAction() {
        return new Action("Enable mapping", ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.CHECK_CHECKED)){

            public void run() {
                MappingPage.this.getSelectedMappingNodes().stream().filter(MappingNode::isCheckable).filter(node -> !node.isChecked()).forEach(node -> {
                    node.setChecked(true);
                    MappingPage.this.validateMappedName((MappingNode)node);
                });
                MappingPage.this.treeViewer.refresh();
            }
        };
    }

    private Action createUncheckAction() {
        return new Action("Disable mapping", ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.CHECK_UNCHECKED)){

            public void run() {
                MappingPage.this.getSelectedMappingNodes().stream().filter(MappingNode::isCheckable).filter(MappingNode::isChecked).forEach(node -> {
                    node.setChecked(false);
                    MappingPage.this.validateMappedName((MappingNode)node);
                });
                MappingPage.this.treeViewer.refresh();
            }
        };
    }

    public void refreshTree() {
        this.treeViewer.refresh();
    }

    private void validateMappedName(MappingNode node) {
        node.setNameValid(!node.isChecked() || !this.contentProvider.getMappedNamesOfOtherCheckedNodes(node).contains(node.getExternalName().trim().toLowerCase()));
        this.contentProvider.updateValidationOfOtherNodes(node);
        this.validateMappedNames();
    }

    private void validateMappedNames() {
        if (this.contentProvider.hasInvalidMappedNames()) {
            this.setPageValid(false);
            this.setMessage("At least one mapped name is not valid. Note that mapped names of the same type must be unique.", ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.FAILED));
        } else {
            this.setPageValid(true);
            this.setMessage(DEFAULT_MESSAGE);
        }
        this.updateSaveButtonActivation();
    }

    private void setSubtreeChecked(ComponentNode componentNode, boolean checked) {
        if (!componentNode.hasChildren()) {
            return;
        }
        Arrays.stream(componentNode.getChildren()).filter(MappingNode.class::isInstance).map(MappingNode.class::cast).forEach(subnode -> {
            if (subnode.isCheckable()) {
                subnode.setChecked(checked);
                this.validateMappedName((MappingNode)subnode);
            }
        });
    }

    private void createColumns() {
        TreeViewerColumn col0 = this.createTreeViewerColumn(TABLE_TITLES[0], 200);
        TreeViewerColumn col1 = this.createTreeViewerColumn(TABLE_TITLES[1], 70);
        TreeViewerColumn col2 = this.createTreeViewerColumn(TABLE_TITLES[2], 80);
        TreeViewerColumn col3 = this.createTreeViewerColumn(TABLE_TITLES[3], 300);
        TreeViewerColumn col4 = this.createTreeViewerColumn(TABLE_TITLES[4], 200);
        col0.setLabelProvider((CellLabelProvider)new MappingTreeColumnLabelProvider(0));
        col1.setLabelProvider((CellLabelProvider)new MappingTreeColumnLabelProvider(1));
        col2.setLabelProvider((CellLabelProvider)new MappingTreeColumnLabelProvider(2));
        col3.setLabelProvider((CellLabelProvider)new MappingTreeColumnLabelProvider(3));
        col4.setLabelProvider((CellLabelProvider)new MappingTreeColumnLabelProvider(4));
        col4.setEditingSupport((EditingSupport)new TextEditingSupport((ColumnViewer)this.treeViewer));
    }

    private TreeViewerColumn createTreeViewerColumn(String title, int width) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn((TreeViewer)this.treeViewer, 16384);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(width);
        return viewerColumn;
    }

    public void update() {
        this.treeViewer.getControl().setVisible(false);
        ArrayList<Object> expandedElements = new ArrayList<Object>(Arrays.asList(this.treeViewer.getExpandedElements()));
        List<TreeItem> oldItems = Arrays.asList(this.treeViewer.getTree().getItems());
        HashMap oldNodes = new HashMap();
        oldItems.stream().map(Widget::getData).filter(ComponentNode.class::isInstance).map(ComponentNode.class::cast).forEach(node -> {
            Boolean bl = oldNodes.put(node, this.hasCheckedChildren((ComponentNode)node));
        });
        WorkflowDescription workflow = this.integrationEditor.getController().getWorkflowDescription().clone();
        this.contentProvider.updateContent(workflow);
        this.treeViewer.refresh();
        List<TreeItem> newItems = Arrays.asList(this.treeViewer.getTree().getItems());
        newItems.stream().map(Widget::getData).filter(ComponentNode.class::isInstance).map(ComponentNode.class::cast).filter(node -> (!oldNodes.keySet().contains(node) || (Boolean)oldNodes.get(node) == false) && this.hasCheckedChildren((ComponentNode)node)).forEach(expandedElements::add);
        this.treeViewer.setExpandedElements(expandedElements.toArray());
        this.treeViewer.getControl().setVisible(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), HELP_CONTEXT_ID);
    }

    private boolean hasCheckedChildren(ComponentNode node) {
        return Arrays.stream(node.getChildren()).filter(MappingNode.class::isInstance).map(MappingNode.class::cast).anyMatch(MappingNode::isChecked);
    }

    public boolean hasChanges() {
        return this.contentProvider.hasChanges();
    }

    private final class MappingTreeColumnLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        private MappingTreeColumnLabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public String getText(Object element) {
            if (element instanceof ComponentNode) {
                ComponentNode componentNode = (ComponentNode)element;
                if (this.columnIndex == 0) {
                    return componentNode.getComponentName();
                }
            }
            if (element instanceof MappingNode) {
                MappingNode exposedEndpointDefinition = (MappingNode)element;
                if (this.columnIndex == 0) {
                    return exposedEndpointDefinition.getInternalName();
                }
                if (this.columnIndex == 1) {
                    return exposedEndpointDefinition.getMappingType().toString();
                }
                if (this.columnIndex == 2) {
                    return exposedEndpointDefinition.getDataType().toString();
                }
                if (this.columnIndex == 3) {
                    return exposedEndpointDefinition.getDetails();
                }
                if (this.columnIndex == 4) {
                    return exposedEndpointDefinition.getExternalName();
                }
            }
            return "";
        }

        public Color getForeground(Object element) {
            if (element instanceof MappingNode) {
                MappingNode node = (MappingNode)element;
                if (!node.isNameValid()) {
                    return PlatformUI.getWorkbench().getDisplay().getSystemColor(3);
                }
                if (!node.isChecked()) {
                    return PlatformUI.getWorkbench().getDisplay().getSystemColor(16);
                }
            }
            return super.getForeground(element);
        }
    }

    private class TextEditingSupport
    extends EditingSupport {
        private ValidatingTextCellEditor editor;

        TextEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new ValidatingTextCellEditor((TreeViewer)MappingPage.this.treeViewer);
        }

        protected boolean canEdit(Object object) {
            if (object instanceof MappingNode) {
                return ((MappingNode)object).isChecked();
            }
            return false;
        }

        protected CellEditor getCellEditor(Object element) {
            if (element instanceof MappingNode) {
                return this.editor;
            }
            return null;
        }

        protected Object getValue(Object arg0) {
            return ((MappingNode)arg0).getExternalName();
        }

        protected void setValue(Object element, Object text) {
            if (element instanceof MappingNode && text instanceof String) {
                MappingNode node = (MappingNode)element;
                node.setExternalName(text.toString().trim());
                MappingPage.this.validateMappedName(node);
                MappingPage.this.integrationEditor.updateDirty();
                MappingPage.this.treeViewer.refresh();
            }
        }
    }

    private class ValidatingTextCellEditor
    extends TextCellEditor {
        ValidatingTextCellEditor(TreeViewer treeViewer) {
            super((Composite)treeViewer.getTree());
            this.setValidator(new MappingValidator(treeViewer));
        }

        protected void valueChanged(boolean oldValidState, boolean newValidState) {
            if (!newValidState) {
                MappingPage.this.setMessage(this.getErrorMessage(), ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.FAILED));
            } else {
                MappingPage.this.setMessage(MappingPage.DEFAULT_MESSAGE);
            }
            super.valueChanged(oldValidState, newValidState);
        }

        protected void focusLost() {
            MappingPage.this.validateMappedNames();
            super.focusLost();
        }
    }
}

