/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.update.internal;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.update.api.DistributedPersistentComponentDescriptionUpdateService;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.component.update.api.RemotablePersistentComponentDescriptionUpdateService;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncExceptionListener;
import de.rcenvironment.toolkit.modules.concurrency.api.CallablesGroup;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DistributedPersistentComponentDescriptionUpdateServiceImpl
implements DistributedPersistentComponentDescriptionUpdateService {
    private static final Log LOGGER = LogFactory.getLog(DistributedPersistentComponentDescriptionUpdateServiceImpl.class);
    private CommunicationService communicationService;
    private DistributedComponentKnowledgeService componentKnowledgeService;
    private LogicalNodeId localLogicalNodeId;

    @Override
    public int getFormatVersionsAffectedByUpdate(List<PersistentComponentDescription> descriptions, final boolean silent) {
        int versionsToUpdate = 0;
        CallablesGroup callablesGroup = ConcurrencyUtils.getFactory().createCallablesGroup(Integer.class);
        final Map<LogicalNodeId, List<PersistentComponentDescription>> sortedDescriptionsMap = Collections.unmodifiableMap(this.sortPersistentComponentDescriptions(descriptions));
        for (final LogicalNodeId node : sortedDescriptionsMap.keySet()) {
            callablesGroup.add((Callable)new Callable<Integer>(){

                @Override
                @TaskDescription(value="Distributed persistent component update check: getFormatVersionsAffectedByUpdate()")
                public Integer call() throws Exception {
                    try {
                        RemotablePersistentComponentDescriptionUpdateService udpateService = (RemotablePersistentComponentDescriptionUpdateService)DistributedPersistentComponentDescriptionUpdateServiceImpl.this.communicationService.getRemotableService(RemotablePersistentComponentDescriptionUpdateService.class, (NetworkDestination)node);
                        return udpateService.getFormatVersionsAffectedByUpdate((List)sortedDescriptionsMap.get(node), silent);
                    }
                    catch (RemoteOperationException | RuntimeException e) {
                        LOGGER.warn((Object)StringUtils.format((String)"Failed to check for persistent component updates for node: %s; cause: %s", (Object[])new Object[]{node, e.toString()}));
                        return null;
                    }
                }
            });
            List results = callablesGroup.executeParallel(new AsyncExceptionListener(){

                public void onAsyncException(Exception e) {
                    LOGGER.warn((Object)"Exception during asynchrous execution", (Throwable)e);
                }
            });
            for (Integer singleResult : results) {
                if (singleResult == null) continue;
                versionsToUpdate |= singleResult.intValue();
            }
        }
        return versionsToUpdate;
    }

    @Override
    public List<PersistentComponentDescription> performComponentDescriptionUpdates(final int formatVersion, List<PersistentComponentDescription> descriptions, final boolean silent) throws IOException {
        ArrayList<PersistentComponentDescription> allUpdatedDescriptions = new ArrayList<PersistentComponentDescription>();
        final Map<LogicalNodeId, List<PersistentComponentDescription>> sortedDescriptionsMap = Collections.unmodifiableMap(this.sortPersistentComponentDescriptions(descriptions));
        final List<PersistentComponentDescription> unModdescriptions = Collections.unmodifiableList(descriptions);
        CallablesGroup callablesGroup = ConcurrencyUtils.getFactory().createCallablesGroup(List.class);
        for (final LogicalNodeId node : sortedDescriptionsMap.keySet()) {
            callablesGroup.add((Callable)new Callable<List>(){

                @Override
                @TaskDescription(value="Distributed persistent component update: performComponentDescriptionUpdates()")
                public List call() throws Exception {
                    RemotablePersistentComponentDescriptionUpdateService updateService = (RemotablePersistentComponentDescriptionUpdateService)DistributedPersistentComponentDescriptionUpdateServiceImpl.this.communicationService.getRemotableService(RemotablePersistentComponentDescriptionUpdateService.class, (NetworkDestination)node);
                    if ((updateService.getFormatVersionsAffectedByUpdate(unModdescriptions, silent) & formatVersion) == formatVersion) {
                        try {
                            return updateService.performComponentDescriptionUpdates(formatVersion, (List)sortedDescriptionsMap.get(node), silent);
                        }
                        catch (UndeclaredThrowableException e) {
                            LOGGER.warn((Object)("Failed to perform persistent component updates for node: " + node), (Throwable)e);
                            return null;
                        }
                    }
                    return (List)sortedDescriptionsMap.get(node);
                }
            });
        }
        List results = callablesGroup.executeParallel(new AsyncExceptionListener(){

            public void onAsyncException(Exception e) {
                LOGGER.warn((Object)"Exception during asynchrous execution", (Throwable)e);
            }
        });
        for (List singleResult : results) {
            if (singleResult == null) continue;
            allUpdatedDescriptions.addAll(singleResult);
        }
        return allUpdatedDescriptions;
    }

    private Map<LogicalNodeId, List<PersistentComponentDescription>> sortPersistentComponentDescriptions(List<PersistentComponentDescription> descriptions) {
        DistributedComponentKnowledge compKnowledge = this.componentKnowledgeService.getCurrentSnapshot();
        HashMap<LogicalNodeId, List<PersistentComponentDescription>> sortedDescriptions = new HashMap<LogicalNodeId, List<PersistentComponentDescription>>();
        for (PersistentComponentDescription description : descriptions) {
            LogicalNodeId targetNodeForUpdate = this.getTargetNodeForUpdate(description, compKnowledge.getAllInstallations());
            if (!sortedDescriptions.containsKey(targetNodeForUpdate)) {
                sortedDescriptions.put(targetNodeForUpdate, new ArrayList());
            }
            ((List)sortedDescriptions.get(targetNodeForUpdate)).add(description);
        }
        return sortedDescriptions;
    }

    protected LogicalNodeId getTargetNodeForUpdate(PersistentComponentDescription compDesc, Collection<DistributedComponentEntry> compInsts) {
        ComponentInstallation exactlyMatchingComponent = null;
        ArrayList<ComponentInstallation> matchingComponents = new ArrayList<ComponentInstallation>();
        for (DistributedComponentEntry entry : compInsts) {
            ComponentInstallation compInst = entry.getComponentInstallation();
            ComponentInterface compInterface = compInst.getComponentInterface();
            String compId = compInterface.getIdentifierAndVersion();
            if (compId.contains("/")) {
                compId = compInterface.getIdentifierAndVersion().split("/")[0];
            }
            if (!compId.equals(compDesc.getComponentIdentifier()) || !compDesc.getComponentVersion().equals("") && compInterface.getVersion().compareTo(compDesc.getComponentVersion()) < 0) continue;
            if (compInst.getNodeId() == null || compInst.getNodeId().equals(this.localLogicalNodeId.getLogicalNodeIdString())) {
                return this.localLogicalNodeId;
            }
            if (compInst.getNodeId() != null && compDesc.getComponentNodeIdentifier() != null && compInst.getNodeId().equals(compDesc.getComponentNodeIdentifier().getLogicalNodeIdString())) {
                exactlyMatchingComponent = compInst;
                continue;
            }
            matchingComponents.add(compInst);
        }
        if (exactlyMatchingComponent != null) {
            return exactlyMatchingComponent.getNodeIdObject();
        }
        if (matchingComponents.size() > 0) {
            return ((ComponentInstallation)matchingComponents.get(0)).getNodeIdObject();
        }
        return this.localLogicalNodeId;
    }

    protected void bindCommunicationService(CommunicationService newCommunicationService) {
        this.communicationService = newCommunicationService;
    }

    protected void bindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService service) {
        this.componentKnowledgeService = service;
    }

    protected void bindPlatformService(PlatformService platformService) {
        this.localLogicalNodeId = platformService.getLocalDefaultLogicalNodeId();
    }
}

