/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.management.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.WorkflowHostUtils;
import de.rcenvironment.core.communication.configuration.NodeConfigurationService;
import de.rcenvironment.core.communication.management.WorkflowHostService;
import de.rcenvironment.core.communication.management.WorkflowHostSetListener;
import de.rcenvironment.core.communication.nodeproperties.NodePropertiesService;
import de.rcenvironment.core.communication.nodeproperties.NodeProperty;
import de.rcenvironment.core.communication.nodeproperties.NodePropertyConstants;
import de.rcenvironment.core.communication.nodeproperties.spi.NodePropertiesChangeListener;
import de.rcenvironment.core.communication.nodeproperties.spi.NodePropertiesChangeListenerAdapter;
import de.rcenvironment.core.configuration.bootstrap.RuntimeDetection;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.service.AdditionalServiceDeclaration;
import de.rcenvironment.core.utils.common.service.AdditionalServicesProvider;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallback;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedCallbackManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkflowHostServiceImpl
implements WorkflowHostService,
AdditionalServicesProvider {
    private NodeConfigurationService platformService;
    private NodePropertiesService nodePropertiesService;
    private final Set<InstanceNodeSessionId> workflowHostsWorkingCopy = new HashSet<InstanceNodeSessionId>();
    private Set<InstanceNodeSessionId> workflowHostsSnapshot = Collections.unmodifiableSet(new HashSet());
    private Set<InstanceNodeSessionId> workflowHostsAndSelfSnapshot = Collections.unmodifiableSet(new HashSet());
    private final AsyncOrderedCallbackManager<WorkflowHostSetListener> callbackManager = ConcurrencyUtils.getFactory().createAsyncOrderedCallbackManager(AsyncCallbackExceptionPolicy.LOG_AND_PROCEED);
    private final Log log = LogFactory.getLog(this.getClass());
    private InstanceNodeSessionId localNodeId;
    private Set<LogicalNodeId> logicalWorkflowHostsSnapshot;
    private Set<LogicalNodeId> logicalWorkflowHostsAndSelfSnapshot;

    public void activate() {
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            return;
        }
        boolean isWorkflowHost = this.platformService.isWorkflowHost();
        this.nodePropertiesService.addOrUpdateLocalNodeProperty("workflowHost", NodePropertyConstants.wrapBoolean(isWorkflowHost));
        this.localNodeId = this.platformService.getInstanceNodeSessionId();
        this.workflowHostsSnapshot = Collections.unmodifiableSet(new HashSet());
        this.logicalWorkflowHostsSnapshot = Collections.unmodifiableSet(new HashSet());
        HashSet<InstanceNodeSessionId> tempWorkflowHostsAndSelf = new HashSet<InstanceNodeSessionId>();
        tempWorkflowHostsAndSelf.add(this.localNodeId);
        this.workflowHostsAndSelfSnapshot = Collections.unmodifiableSet(tempWorkflowHostsAndSelf);
        HashSet<LogicalNodeId> tempLogicalWorkflowHostsAndSelf = new HashSet<LogicalNodeId>();
        tempLogicalWorkflowHostsAndSelf.add(this.localNodeId.convertToDefaultLogicalNodeId());
        this.logicalWorkflowHostsAndSelfSnapshot = Collections.unmodifiableSet(tempLogicalWorkflowHostsAndSelf);
    }

    public Collection<AdditionalServiceDeclaration> defineAdditionalServices() {
        ArrayList<AdditionalServiceDeclaration> result = new ArrayList<AdditionalServiceDeclaration>();
        result.add(new AdditionalServiceDeclaration(NodePropertiesChangeListener.class, (Object)new NodePropertiesChangeListenerAdapter(){

            @Override
            public void onReachableNodePropertiesChanged(Collection<? extends NodeProperty> addedProperties, Collection<? extends NodeProperty> updatedProperties, Collection<? extends NodeProperty> removedProperties) {
                WorkflowHostServiceImpl.this.updateOnReachableNodePropertiesChanged(addedProperties, updatedProperties, removedProperties);
            }
        }));
        result.add(new AdditionalServiceDeclaration(WorkflowHostSetListener.class, (Object)new WorkflowHostSetListener(){

            @Override
            public void onReachableWorkflowHostsChanged(Set<InstanceNodeSessionId> reachableWfHosts, Set<InstanceNodeSessionId> addedWfHosts, Set<InstanceNodeSessionId> removedWfHosts) {
                WorkflowHostServiceImpl.this.log.debug((Object)("List of reachable workflow hosts updated: " + reachableWfHosts));
            }
        }));
        return result;
    }

    public void bindNodeConfigurationService(NodeConfigurationService newInstance) {
        this.platformService = newInstance;
    }

    public void bindNodePropertiesService(NodePropertiesService newInstance) {
        this.nodePropertiesService = newInstance;
    }

    @Override
    public synchronized Set<InstanceNodeSessionId> getWorkflowHostNodes() {
        return this.workflowHostsSnapshot;
    }

    @Override
    public synchronized Set<LogicalNodeId> getLogicalWorkflowHostNodes() {
        return this.logicalWorkflowHostsSnapshot;
    }

    @Override
    public synchronized Set<InstanceNodeSessionId> getWorkflowHostNodesAndSelf() {
        return this.workflowHostsAndSelfSnapshot;
    }

    @Override
    public synchronized Set<LogicalNodeId> getLogicalWorkflowHostNodesAndSelf() {
        return this.logicalWorkflowHostsAndSelfSnapshot;
    }

    public synchronized void addWorkflowHostSetListener(WorkflowHostSetListener listener) {
        final Set<InstanceNodeSessionId> currentWorkflowHostsCopy = this.workflowHostsSnapshot;
        this.callbackManager.addListenerAndEnqueueCallback((Object)listener, (AsyncCallback)new AsyncCallback<WorkflowHostSetListener>(){

            public void performCallback(WorkflowHostSetListener listener) {
                listener.onReachableWorkflowHostsChanged(currentWorkflowHostsCopy, null, null);
            }
        });
    }

    public void removeWorkflowHostSetListener(WorkflowHostSetListener listener) {
        this.callbackManager.removeListener((Object)listener);
    }

    private synchronized void updateOnReachableNodePropertiesChanged(Collection<? extends NodeProperty> addedProperties, Collection<? extends NodeProperty> updatedProperties, Collection<? extends NodeProperty> removedProperties) {
        boolean setChanged;
        boolean relevantModification = false;
        for (NodeProperty nodeProperty : addedProperties) {
            boolean value;
            if (!WorkflowHostUtils.isWorkflowHostProperty(nodeProperty) || !(value = WorkflowHostUtils.getWorkflowHostPropertyValue(nodeProperty))) continue;
            InstanceNodeSessionId nodeId = nodeProperty.getInstanceNodeSessionId();
            setChanged = this.workflowHostsWorkingCopy.add(nodeId);
            if (setChanged) {
                relevantModification = true;
                this.log.info((Object)("New workflow host available: " + nodeId));
                continue;
            }
            this.log.debug((Object)("New workflow host available, but it caused no set modification: " + nodeProperty));
        }
        for (NodeProperty nodeProperty : updatedProperties) {
            if (!WorkflowHostUtils.isWorkflowHostProperty(nodeProperty)) continue;
            InstanceNodeSessionId nodeId = nodeProperty.getInstanceNodeSessionId();
            boolean value = WorkflowHostUtils.getWorkflowHostPropertyValue(nodeProperty);
            if (value) {
                setChanged = this.workflowHostsWorkingCopy.add(nodeId);
                if (setChanged) {
                    relevantModification = true;
                    this.log.info((Object)("New workflow host available (by configuration change): " + nodeId));
                    continue;
                }
                this.log.debug((Object)("New workflow host available (by configuration change), but it caused no set modification: " + nodeProperty));
                continue;
            }
            setChanged = this.workflowHostsWorkingCopy.remove(nodeId);
            if (setChanged) {
                relevantModification = true;
                this.log.info((Object)("Node removed as workflow host (by configuration change): " + nodeId));
                continue;
            }
            this.log.debug((Object)("Node removed as workflow host (by configuration change), but it caused no set modification: " + nodeProperty));
        }
        for (NodeProperty nodeProperty : removedProperties) {
            InstanceNodeSessionId nodeId;
            if (!WorkflowHostUtils.isWorkflowHostProperty(nodeProperty) || !this.workflowHostsWorkingCopy.contains(nodeId = nodeProperty.getInstanceNodeSessionId())) continue;
            boolean setChanged2 = this.workflowHostsWorkingCopy.remove(nodeId);
            if (setChanged2) {
                relevantModification = true;
                this.log.info((Object)("Workflow host became unavailable: " + nodeId));
                continue;
            }
            this.log.debug((Object)("Workflow host was removed, but caused no set modification: " + nodeProperty));
        }
        if (relevantModification) {
            this.workflowHostsSnapshot = Collections.unmodifiableSet(new HashSet<InstanceNodeSessionId>(this.workflowHostsWorkingCopy));
            this.logicalWorkflowHostsSnapshot = this.convertFromInstanceIdsToLogicalNodesSet(this.workflowHostsSnapshot);
            HashSet<InstanceNodeSessionId> hashSet = new HashSet<InstanceNodeSessionId>(this.workflowHostsWorkingCopy);
            hashSet.add(this.localNodeId);
            this.workflowHostsAndSelfSnapshot = Collections.unmodifiableSet(hashSet);
            this.logicalWorkflowHostsAndSelfSnapshot = this.convertFromInstanceIdsToLogicalNodesSet(this.workflowHostsAndSelfSnapshot);
            this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<WorkflowHostSetListener>(){

                public void performCallback(WorkflowHostSetListener listener) {
                    listener.onReachableWorkflowHostsChanged(WorkflowHostServiceImpl.this.workflowHostsSnapshot, null, null);
                }
            });
        }
    }

    private Set<LogicalNodeId> convertFromInstanceIdsToLogicalNodesSet(Set<InstanceNodeSessionId> input) {
        HashSet<LogicalNodeId> tempSet = new HashSet<LogicalNodeId>();
        for (InstanceNodeSessionId instanceSessionId : input) {
            tempSet.add(instanceSessionId.convertToDefaultLogicalNodeId());
        }
        return Collections.unmodifiableSet(tempSet);
    }
}

