/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.internal;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.api.LiveNetworkIdResolutionService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.api.ReliableRPCStreamHandle;
import de.rcenvironment.core.communication.api.RemotableReliableRPCStreamService;
import de.rcenvironment.core.communication.api.ServiceCallContextUtils;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.LogicalNodeSessionId;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.communication.common.NetworkGraph;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.communication.internal.LiveNetworkIdResolutionServiceImpl;
import de.rcenvironment.core.communication.management.CommunicationManagementService;
import de.rcenvironment.core.communication.routing.NetworkRoutingService;
import de.rcenvironment.core.communication.rpc.internal.ReliableRPCStreamService;
import de.rcenvironment.core.communication.rpc.spi.LocalServiceResolver;
import de.rcenvironment.core.communication.rpc.spi.ServiceProxyFactory;
import de.rcenvironment.core.communication.spi.NetworkTopologyChangeListener;
import de.rcenvironment.core.communication.spi.NetworkTopologyChangeListenerAdapter;
import de.rcenvironment.core.configuration.bootstrap.RuntimeDetection;
import de.rcenvironment.core.toolkitbridge.api.StaticToolkitHolder;
import de.rcenvironment.core.utils.common.rpc.RemotableService;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.service.AdditionalServiceDeclaration;
import de.rcenvironment.core.utils.common.service.AdditionalServicesProvider;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.toolkit.modules.concurrency.api.threadcontext.ThreadContextMemento;
import de.rcenvironment.toolkit.modules.statistics.api.CounterCategory;
import de.rcenvironment.toolkit.modules.statistics.api.StatisticsFilterLevel;
import de.rcenvironment.toolkit.modules.statistics.api.StatisticsTrackerService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component
public class CommunicationServiceImpl
implements CommunicationService,
AdditionalServicesProvider {
    private static final String SERVICE_NOT_AVAILABLE_ERROR = "The requested service is not available: ";
    private Set<InstanceNodeSessionId> cachedReachableNodes;
    private Set<LogicalNodeId> cachedReachableLogicalNodes;
    private ServiceProxyFactory remoteServiceHandler;
    private PlatformService platformService;
    private CommunicationManagementService newManagementService;
    private NetworkRoutingService routingService;
    private ReliableRPCStreamService reliableRPCStreamService;
    private LocalServiceResolver localServiceResolver;
    private InstanceNodeSessionId localInstanceNodeSessionId;
    private LogicalNodeSessionId localDefaultLogicalNodeSessionId;
    private LiveNetworkIdResolutionServiceImpl idResolutionService;
    private final boolean forceLocalRPCSerialization = System.getProperty("rce.internal.forceLocalRPCSerialization") != null;
    private final CounterCategory serviceRequestCounter;
    private final boolean verboseLogging = DebugSettings.getVerboseLoggingEnabled(this.getClass());
    private final Log log = LogFactory.getLog(this.getClass());

    public CommunicationServiceImpl() {
        StatisticsTrackerService statisticsService = (StatisticsTrackerService)StaticToolkitHolder.getServiceWithUnitTestFallback(StatisticsTrackerService.class);
        this.serviceRequestCounter = statisticsService.getCounterCategory("Remote services: service proxies fetched via getRemotableService()", StatisticsFilterLevel.DEVELOPMENT);
    }

    @Activate
    public void activate() {
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            return;
        }
        this.localInstanceNodeSessionId = this.platformService.getLocalInstanceNodeSessionId();
        this.localDefaultLogicalNodeSessionId = this.platformService.getLocalDefaultLogicalNodeSessionId();
        this.idResolutionService.registerLocalInstanceNodeSessionId(this.localInstanceNodeSessionId);
        this.updateOnReachableNetworkChanged(this.routingService.getReachableNetworkGraph());
    }

    @Deactivate
    public void deactivate() {
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            return;
        }
        this.newManagementService.shutDownNetwork();
    }

    public Collection<AdditionalServiceDeclaration> defineAdditionalServices() {
        ArrayList<AdditionalServiceDeclaration> result = new ArrayList<AdditionalServiceDeclaration>();
        result.add(new AdditionalServiceDeclaration(NetworkTopologyChangeListener.class, (Object)new NetworkTopologyChangeListenerAdapter(){

            @Override
            public void onReachableNodesChanged(Set<InstanceNodeSessionId> reachableNodes, Set<InstanceNodeSessionId> addedNodes, Set<InstanceNodeSessionId> removedNodes) {
                for (InstanceNodeSessionId node : removedNodes) {
                    CommunicationServiceImpl.this.log.debug((Object)("Topology change: Node " + node + " is not reachable anymore (local node: " + CommunicationServiceImpl.this.localInstanceNodeSessionId + ")"));
                    CommunicationServiceImpl.this.idResolutionService.unregisterInstanceNodeSessionId(node);
                }
                for (InstanceNodeSessionId node : addedNodes) {
                    CommunicationServiceImpl.this.log.debug((Object)("Topology change: Node " + node + " is now reachable (local node: " + CommunicationServiceImpl.this.localInstanceNodeSessionId + ")"));
                    CommunicationServiceImpl.this.idResolutionService.registerInstanceNodeSessionId(node);
                }
            }

            @Override
            public void onReachableNetworkChanged(NetworkGraph networkGraph) {
                CommunicationServiceImpl.this.updateOnReachableNetworkChanged(networkGraph);
            }
        }));
        return result;
    }

    protected synchronized void updateOnReachableNetworkChanged(NetworkGraph networkGraph) {
        this.cachedReachableNodes = Collections.unmodifiableSet(new HashSet<InstanceNodeSessionId>(networkGraph.getNodeIds()));
        HashSet<LogicalNodeId> tempSet = new HashSet<LogicalNodeId>();
        for (InstanceNodeSessionId instanceSessionId : this.cachedReachableNodes) {
            tempSet.add(instanceSessionId.convertToDefaultLogicalNodeId());
        }
        this.cachedReachableLogicalNodes = Collections.unmodifiableSet(tempSet);
    }

    @Reference
    public void bindServiceProxyFactory(ServiceProxyFactory newInstance) {
        this.remoteServiceHandler = newInstance;
    }

    @Reference
    public void bindLocalServiceResolver(LocalServiceResolver newInstance) {
        this.localServiceResolver = newInstance;
    }

    @Reference
    public void bindPlatformService(PlatformService newInstance) {
        this.platformService = newInstance;
    }

    @Reference
    public void bindLiveNetworkIdResolutionService(LiveNetworkIdResolutionService newInstance) {
        this.idResolutionService = (LiveNetworkIdResolutionServiceImpl)newInstance;
    }

    @Reference
    public void bindCommunicationManagementService(CommunicationManagementService newInstance) {
        this.newManagementService = newInstance;
    }

    @Reference
    public void bindNetworkRoutingService(NetworkRoutingService newInstance) {
        this.routingService = newInstance;
    }

    @Reference
    public void bindReliableRPCStreamService(ReliableRPCStreamService newInstance) {
        this.reliableRPCStreamService = newInstance;
    }

    @Override
    public synchronized Set<InstanceNodeSessionId> getReachableInstanceNodes() {
        return this.cachedReachableNodes;
    }

    @Override
    public synchronized Set<LogicalNodeId> getReachableLogicalNodes() {
        return this.cachedReachableLogicalNodes;
    }

    @Override
    public <T> T getRemotableService(Class<T> iface, NetworkDestination destination) {
        if (destination == null) {
            throw new IllegalArgumentException("The 'destination' argument can not be null");
        }
        if (!iface.isAnnotationPresent(RemotableService.class)) {
            throw new IllegalArgumentException("The requested interface is not a " + RemotableService.class.getSimpleName() + ": " + iface.getName());
        }
        this.serviceRequestCounter.count(iface.getName());
        if (destination instanceof ResolvableNodeId) {
            ResolvableNodeId nodeId = (ResolvableNodeId)destination;
            return this.getServiceProxy(iface, nodeId, null);
        }
        if (destination instanceof ReliableRPCStreamHandle) {
            ReliableRPCStreamHandle reliableRPCStream = (ReliableRPCStreamHandle)destination;
            return this.getServiceProxy(iface, reliableRPCStream.getDestinationNodeId(), reliableRPCStream);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ReliableRPCStreamHandle createReliableRPCStream(ResolvableNodeId targetNodeId) throws RemoteOperationException {
        LogicalNodeSessionId resolvedTargetNodeId;
        try {
            resolvedTargetNodeId = this.idResolutionService.resolveToLogicalNodeSessionId(targetNodeId);
        }
        catch (IdentifierException e) {
            throw new RemoteOperationException("Failed to resolve node id " + targetNodeId + " to a reachable instance: " + e.toString());
        }
        String streamId = this.getRemotableService(RemotableReliableRPCStreamService.class, resolvedTargetNodeId).createReliableRPCStream();
        return this.reliableRPCStreamService.createLocalSetupForRemoteStreamId(resolvedTargetNodeId, streamId);
    }

    @Override
    public void closeReliableRPCStream(ReliableRPCStreamHandle streamHandle) throws RemoteOperationException {
        this.getRemotableService(RemotableReliableRPCStreamService.class, streamHandle.getDestinationNodeId()).disposeReliableRPCStream(streamHandle.getStreamId());
    }

    private <T> T getServiceProxy(Class<T> iface, ResolvableNodeId nodeId, ReliableRPCStreamHandle reliableRPCStreamHandle) {
        Objects.requireNonNull(nodeId);
        if (this.platformService.matchesLocalInstance(nodeId)) {
            LogicalNodeSessionId targetLogicalNodeInstanceId;
            if (this.forceLocalRPCSerialization) {
                this.log.debug((Object)("Creating service proxy for local service as the 'force RPC serialization' flag is set: " + iface.getName()));
                return this.createSerializingServiceProxy(iface, nodeId, reliableRPCStreamHandle);
            }
            T localService = this.resolveLocalService(iface);
            if (localService == null) {
                throw new IllegalStateException("Unexpected state: There is no local instance of service " + iface.getName());
            }
            try {
                targetLogicalNodeInstanceId = this.idResolutionService.resolveToLogicalNodeSessionId(nodeId);
            }
            catch (IdentifierException e) {
                throw new RuntimeException("Internal error: resolution of instance-local node id failed", e);
            }
            return this.createDirectCallServiceProxy(this.localDefaultLogicalNodeSessionId, targetLogicalNodeInstanceId, iface, localService);
        }
        return this.createSerializingServiceProxy(iface, nodeId, reliableRPCStreamHandle);
    }

    @Override
    public String getFormattedNetworkInformation(String type) {
        return this.routingService.getFormattedNetworkInformation(type);
    }

    private <T> T createSerializingServiceProxy(Class<T> iface, ResolvableNodeId targetNodeId, ReliableRPCStreamHandle reliableRPCStreamHandle) {
        return (T)this.remoteServiceHandler.createServiceProxy(targetNodeId, iface, null, reliableRPCStreamHandle);
    }

    private <T> T createDirectCallServiceProxy(final LogicalNodeSessionId callerLogicalNodeSessionId, final LogicalNodeSessionId targetLogicalNodeSessionId, final Class<T> serviceIface, final T serviceImpl) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                ThreadContextMemento previousThreadContext = ServiceCallContextUtils.attachServiceCallDataToThreadContext(callerLogicalNodeSessionId, targetLogicalNodeSessionId, serviceIface.getSimpleName(), method.getName());
                try {
                    Object object = method.invoke(serviceImpl, args);
                    return object;
                }
                finally {
                    previousThreadContext.restore();
                }
            }
        };
        return (T)Proxy.newProxyInstance(serviceIface.getClassLoader(), new Class[]{serviceIface}, handler);
    }

    private <T> T resolveLocalService(Class<? super T> iface) {
        Object service = this.localServiceResolver.getLocalService(iface.getName());
        if (service != null) {
            return (T)service;
        }
        throw new IllegalStateException(SERVICE_NOT_AVAILABLE_ERROR + iface.getName());
    }
}

