/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.network.internal;

import de.rcenvironment.core.communication.uplink.network.internal.CommonUplinkLowLevelProtocolWrapper;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkConnectionLowLevelEventHandler;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkConnectionRefusedException;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkProtocolConfiguration;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkProtocolErrorType;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.core.utils.common.StreamConnectionEndpoint;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;

public class ServerSideUplinkLowLevelProtocolWrapper
extends CommonUplinkLowLevelProtocolWrapper {
    public static final String ERROR_MESSAGE_CONNECTION_SETUP_FAILED = "Error during connection setup";

    public ServerSideUplinkLowLevelProtocolWrapper(StreamConnectionEndpoint connectionEndpoint, UplinkConnectionLowLevelEventHandler eventHandler, String logIdentity) {
        super(connectionEndpoint, eventHandler, logIdentity);
    }

    @Override
    protected void runHandshakeSequence() throws UplinkConnectionRefusedException {
        MessageBlock responseData;
        MessageBlock handshakeData;
        try {
            if (this.verboseLoggingEnabled) {
                this.log.debug((Object)(String.valueOf(this.logPrefix) + "Expecting handshake init"));
            }
            this.expectHandshakeInit();
        }
        catch (ProtocolException e) {
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.PROTOCOL_VERSION_MISMATCH, e.getMessage(), false);
        }
        catch (IOException e) {
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.LOW_LEVEL_CONNECTION_ERROR, "Error while receiving remote handshake initialization" + e.toString(), false);
        }
        catch (TimeoutException timeoutException) {
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.LOW_LEVEL_CONNECTION_ERROR, "Timeout while receiving remote handshake initialization", false);
        }
        try {
            this.sendHandshakeInit();
        }
        catch (IOException e) {
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.LOW_LEVEL_CONNECTION_ERROR, "Error while trying to send initial handshake reponse: " + e.toString(), false);
        }
        try {
            handshakeData = this.expectHandshakeData();
        }
        catch (UplinkConnectionRefusedException e) {
            throw e;
        }
        catch (TimeoutException timeoutException) {
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.PROTOCOL_VIOLATION, "Failed to receive client data within " + UplinkProtocolConfiguration.getCurrent().getHandshakeResponseTimeout() + " msec, closing the connection", true);
        }
        catch (IOException e) {
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.LOW_LEVEL_CONNECTION_ERROR, "Error receiving client handshake data: " + e.toString(), false);
        }
        try {
            responseData = this.processHandshakeDataAndGenerateResponse(handshakeData);
        }
        catch (ProtocolException e) {
            String errorMarker = LogUtils.logExceptionAsSingleLineAndAssignUniqueMarker((Log)this.log, (String)(String.valueOf(this.logPrefix) + "Error while processing handshake data, closing incoming connection"), (Throwable)e);
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.PROTOCOL_VIOLATION, "Error during connection setup (internal error log marker " + errorMarker + ")", true);
        }
        catch (UplinkConnectionRefusedException e) {
            throw e;
        }
        try {
            this.sendHandshakeData(responseData);
        }
        catch (IOException e) {
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.LOW_LEVEL_CONNECTION_ERROR, "Error while trying to send handshake reponse data: " + e.toString(), false);
        }
        try {
            handshakeData = this.expectHandshakeData();
        }
        catch (IOException e) {
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.LOW_LEVEL_CONNECTION_ERROR, "Error while waiting for the client's handshake confirmation: " + e.getMessage(), false);
        }
        catch (UplinkConnectionRefusedException e) {
            throw e;
        }
        catch (TimeoutException timeoutException) {
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.PROTOCOL_VIOLATION, "Failed to receive the client's handshake confirmation within " + UplinkProtocolConfiguration.getCurrent().getHandshakeResponseTimeout() + " msec, closing the connection", true);
        }
    }

    private MessageBlock processHandshakeDataAndGenerateResponse(MessageBlock handshakeData) throws ProtocolException, UplinkConnectionRefusedException {
        if (this.verboseLoggingEnabled) {
            this.log.debug((Object)(String.valueOf(this.logPrefix) + "Processing handshake data: " + new String(handshakeData.getData())));
        }
        Map<String, String> incomingData = this.messageConverter.decodeHandshakeData(handshakeData);
        HashMap<String, String> responseMap = new HashMap<String, String>();
        this.eventHandler.provideOrProcessHandshakeData(incomingData, responseMap);
        return this.messageConverter.encodeHandshakeData(responseMap);
    }
}

