/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.network.internal;

import de.rcenvironment.core.communication.uplink.common.internal.MessageType;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import java.util.Objects;

public class MessageBlock {
    private final MessageType type;
    private final byte[] data;

    public MessageBlock(MessageType type, byte[] data) throws ProtocolException {
        this.type = type;
        this.data = Objects.requireNonNull(data);
        if (data.length > 262144) {
            throw new ProtocolException(StringUtils.format((String)"The message data block of %d bytes exceeds the maximum of %d bytes", (Object[])new Object[]{data.length, 262144}));
        }
    }

    public MessageBlock(int type, byte[] data) throws ProtocolException {
        this(MessageType.resolve((byte)type), data);
    }

    public MessageBlock(MessageType messageType) throws ProtocolException {
        this(messageType.getCode(), new byte[0]);
    }

    public MessageType getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getDataLength() {
        return this.data.length;
    }
}

