/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.command.spi;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.AbstractCommandParameter;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.ParsedIntegerParameter;

public class IntegerParameter
extends AbstractCommandParameter {
    private final Integer standardValue;

    public IntegerParameter(Integer standarValue, String name, String description) {
        super(name, description);
        this.standardValue = standarValue;
    }

    @Override
    public ParsedIntegerParameter parseToken(String token, CommandContext context) throws CommandException {
        try {
            int number = Integer.parseInt(token);
            return new ParsedIntegerParameter(number);
        }
        catch (NumberFormatException numberFormatException) {
            throw CommandException.syntaxError("integer parameter could not be parsed", context);
        }
    }

    @Override
    public ParsedIntegerParameter standardValue() {
        return new ParsedIntegerParameter(this.standardValue);
    }
}

