/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.authorization.cryptography.internal;

import de.rcenvironment.core.authorization.cryptography.api.CryptographyOperationsProvider;
import de.rcenvironment.core.authorization.cryptography.api.SymmetricKey;
import de.rcenvironment.core.authorization.cryptography.internal.AbstractCryptographyOperationsProvider;
import de.rcenvironment.core.authorization.cryptography.internal.SymmetricKeyImpl;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.osgi.service.component.annotations.Component;

@Component
public class BCCryptographyOperationsProviderImpl
extends AbstractCryptographyOperationsProvider
implements CryptographyOperationsProvider {
    private static final String ERROR_MESSAGE_INITIALIZING_SYMMETRIC_CIPHER = "Error initializing symmetric cipher";
    private static final String ERROR_MESSAGE_GENERIC_CRYPTO_ERROR = "Error during cryptographic operation";
    private static final String BC_PROVIDER_ID = "BC";
    private static final String SYMMETRIC_CIPHER_ID = "AES";
    private final Log log = LogFactory.getLog(this.getClass());
    private SecureRandom sharedSecureRandom;

    public BCCryptographyOperationsProviderImpl() {
        if (Security.getProvider(BC_PROVIDER_ID) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            this.log.debug((Object)"Installed BouncyCastle provider");
        }
        this.sharedSecureRandom = new SecureRandom();
    }

    @Override
    public SymmetricKey generateSymmetricKey() throws OperationFailureException {
        KeyGenerator kg;
        try {
            kg = KeyGenerator.getInstance(SYMMETRIC_CIPHER_ID, BC_PROVIDER_ID);
            kg.init(256);
        }
        catch (InvalidParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new OperationFailureException(ERROR_MESSAGE_INITIALIZING_SYMMETRIC_CIPHER, (Throwable)e);
        }
        SecretKey rawKey = kg.generateKey();
        String encodedKey = this.encodeRawKey(rawKey, 32);
        String completeEncoded = "1:" + encodedKey;
        if (completeEncoded.length() != SYMMETRIC_KEY_EXPECTED_ENCODED_LENGTH) {
            throw new OperationFailureException("Internal error: unexpected length of serialized key");
        }
        return new SymmetricKeyImpl(rawKey, completeEncoded);
    }

    @Override
    public byte[] encrypt(SymmetricKey key, byte[] input) throws OperationFailureException {
        try {
            Cipher cipher = Cipher.getInstance(SYMMETRIC_CIPHER_ID, BC_PROVIDER_ID);
            cipher.init(1, this.getRawKeyFromWrapper(key));
            return cipher.doFinal(input);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new OperationFailureException(ERROR_MESSAGE_INITIALIZING_SYMMETRIC_CIPHER, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new OperationFailureException("Invalid encryption key: " + e.toString());
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new OperationFailureException(ERROR_MESSAGE_GENERIC_CRYPTO_ERROR, (Throwable)e);
        }
    }

    @Override
    public byte[] decrypt(SymmetricKey key, byte[] input) throws OperationFailureException {
        try {
            Cipher cipher = Cipher.getInstance(SYMMETRIC_CIPHER_ID, BC_PROVIDER_ID);
            cipher.init(2, this.getRawKeyFromWrapper(key));
            return cipher.doFinal(input);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new OperationFailureException(ERROR_MESSAGE_INITIALIZING_SYMMETRIC_CIPHER, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new OperationFailureException("Invalid encryption key: " + e.toString());
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new OperationFailureException(ERROR_MESSAGE_GENERIC_CRYPTO_ERROR, (Throwable)e);
        }
    }

    @Override
    public String encodeSymmetricKey(SymmetricKey key) {
        return key.getEncodedForm();
    }

    @Override
    public SymmetricKey decodeSymmetricKey(String input) throws OperationFailureException {
        if (input.length() != SYMMETRIC_KEY_EXPECTED_ENCODED_LENGTH) {
            throw new OperationFailureException("Unexpected length of received key data: " + input);
        }
        if (!input.startsWith("1:")) {
            throw new OperationFailureException("Unexpected key format (missing version identifier): " + input);
        }
        SecretKeySpec rawKey = this.decodeRawKey(input.substring("1:".length()), 32);
        return new SymmetricKeyImpl(rawKey, input);
    }

    private String encodeRawKey(SecretKey rawKey, int expectedByteLength) throws OperationFailureException {
        byte[] encoded = rawKey.getEncoded();
        if (encoded.length != expectedByteLength) {
            throw new OperationFailureException("Unexpected native key representation: " + Hex.encodeHexString((byte[])encoded));
        }
        return this.encodeByteArray(encoded);
    }

    private SecretKeySpec decodeRawKey(String input, int expectedByteLength) throws OperationFailureException {
        if (input == null) {
            throw new OperationFailureException("Key data cannot be null");
        }
        byte[] decodeByteArray = this.decodeByteArray(input);
        if (decodeByteArray.length != expectedByteLength) {
            throw new IllegalStateException("Unexpected key material (invalid length): " + Hex.encodeHexString((byte[])decodeByteArray));
        }
        SecretKeySpec rawKey = new SecretKeySpec(decodeByteArray, SYMMETRIC_CIPHER_ID);
        return rawKey;
    }

    private SecretKey getRawKeyFromWrapper(SymmetricKey wrapper) {
        return ((SymmetricKeyImpl)wrapper).getSecretKey();
    }
}

