/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.authorization.cryptography.api;

import de.rcenvironment.core.authorization.cryptography.api.SymmetricKey;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;

public interface CryptographyOperationsProvider {
    public static final int SYMMETRIC_KEY_NATIVE_BIT_LENGTH = 256;
    public static final int SYMMETRIC_KEY_NATIVE_BYTE_LENGTH = 32;
    public static final String SYMMETRIC_KEY_CURRENT_VERSION_PREFIX = "1:";
    public static final int SYMMETRIC_KEY_EXPECTED_ENCODED_LENGTH = 43 + "1:".length();

    public SymmetricKey generateSymmetricKey() throws OperationFailureException;

    public byte[] encrypt(SymmetricKey var1, byte[] var2) throws OperationFailureException;

    public String encryptAndEncodeByteArray(SymmetricKey var1, byte[] var2) throws OperationFailureException;

    public String encryptAndEncodeString(SymmetricKey var1, String var2) throws OperationFailureException;

    public byte[] decrypt(SymmetricKey var1, byte[] var2) throws OperationFailureException;

    public byte[] decodeAndDecryptByteArray(SymmetricKey var1, String var2) throws OperationFailureException;

    public String decodeAndDecryptString(SymmetricKey var1, String var2) throws OperationFailureException;

    public String encodeByteArray(byte[] var1);

    public byte[] decodeByteArray(String var1);

    public String encodeSymmetricKey(SymmetricKey var1);

    public SymmetricKey decodeSymmetricKey(String var1) throws OperationFailureException;
}

