/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.authentication;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public abstract class User
implements Serializable {
    private static final long serialVersionUID = 8062621616567258257L;
    private final Date timeUntilValid;
    private int validityInDays;

    public User(int validityInDays) {
        if (validityInDays <= 0) {
            throw new IllegalArgumentException();
        }
        this.validityInDays = validityInDays;
        Date now = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        cal.add(5, validityInDays);
        this.timeUntilValid = cal.getTime();
    }

    public boolean isValid() {
        return this.timeUntilValid.after(new Date());
    }

    public Date getTimeUntilValid() {
        return this.timeUntilValid;
    }

    public int getValidityInDays() {
        return this.validityInDays;
    }

    public boolean same(User other) {
        return this.getUserId().equals(other.getUserId()) && this.getDomain().equals(other.getDomain());
    }

    public String toString() {
        return String.valueOf(this.getUserId()) + "@" + this.getDomain();
    }

    public abstract String getUserId();

    public abstract String getDomain();

    public abstract Type getType();

    public int hashCode() {
        return this.getUserId().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof User) {
            User user = (User)o;
            return user.getUserId().equals(this.getUserId());
        }
        return false;
    }

    public static enum Type {
        single,
        ldap;

    }
}

