/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.modules.concurrency.internal;

import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.BlockingResponseMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockingResponseMapperImpl<TKey, TResponse>
implements BlockingResponseMapper<TKey, TResponse> {
    private final Map<TKey, CompletableFuture<Optional<TResponse>>> requestFutures = new HashMap<TKey, CompletableFuture<Optional<TResponse>>>();
    private final AsyncTaskService asyncTaskService;
    private final Log log = LogFactory.getLog(this.getClass());

    public BlockingResponseMapperImpl(AsyncTaskService asyncTaskService) {
        this.asyncTaskService = asyncTaskService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Optional<TResponse>> registerRequest(TKey key, int timeoutMsec) {
        CompletableFuture<Optional<TResponse>> future = new CompletableFuture<Optional<TResponse>>();
        Map<TKey, CompletableFuture<Optional<TResponse>>> map = this.requestFutures;
        synchronized (map) {
            this.requestFutures.put(key, future);
        }
        this.asyncTaskService.scheduleAfterDelay("BlockingResponseMapper: Check for response timeouts", () -> this.checkForTimeout(key), (long)timeoutMsec);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerResponse(TKey key, TResponse response) {
        CompletableFuture<Optional<TResponse>> pendingFuture;
        Map<TKey, CompletableFuture<Optional<TResponse>>> map = this.requestFutures;
        synchronized (map) {
            pendingFuture = this.requestFutures.remove(key);
        }
        if (pendingFuture != null) {
            pendingFuture.complete(Optional.of(response));
        } else {
            this.log.debug((Object)("Received a response for request key " + key + ", but the timeout was already reached"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForTimeout(TKey key) {
        CompletableFuture<Optional<TResponse>> pendingFuture;
        Map<TKey, CompletableFuture<Optional<TResponse>>> map = this.requestFutures;
        synchronized (map) {
            pendingFuture = this.requestFutures.remove(key);
        }
        if (pendingFuture != null) {
            this.log.debug((Object)("Reached response timeout for request key " + key));
            pendingFuture.complete(Optional.empty());
        }
    }
}

