/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.ssh.jsch;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.ssh.jsch.SshParameterException;
import java.io.File;
import java.security.SignatureException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JschSessionFactory {
    private static final int SERVER_ALIVE_INTERVAL = 5000;
    private static final String MAX_AUTH_TRIES_CONFIG_KEY = "MaxAuthTries";
    private static final String MAX_AUTH_TRIES = "1";
    private static Log log = LogFactory.getLog(JschSessionFactory.class);

    private JschSessionFactory() {
    }

    public static Session setupSession(String host, int port, String user, String keyfileLocation, String authPhrase, Logger connectionLogger) throws JSchException, SshParameterException {
        int i = 5;
        while (true) {
            try {
                return JschSessionFactory.setupSessionInternal(host, port, user, keyfileLocation, authPhrase, connectionLogger);
            }
            catch (JSchException e) {
                Throwable cause = e.getCause();
                String message = e.getMessage();
                if (cause != null && cause instanceof SignatureException || message != null && message.contains("java.security.SignatureException")) {
                    log.debug((Object)"SignatureException occured, retry connecting...");
                    if (--i != 0) continue;
                    throw e;
                }
                throw e;
                if (i > 0) continue;
                return null;
            }
            break;
        }
    }

    private static Session setupSessionInternal(String host, int port, String user, String keyfileLocation, String authPhrase, Logger connectionLogger) throws JSchException, SshParameterException {
        JSch jsch = new JSch();
        Session jschSession = jsch.getSession(user, host, port);
        jschSession.setConfig("StrictHostKeyChecking", "no");
        keyfileLocation = JschSessionFactory.normalizeKeyfilePath(keyfileLocation);
        if (host.length() == 0) {
            throw new SshParameterException("The host name or address cannot be empty");
        }
        if (port < 0) {
            throw new SshParameterException("The port must be greater than zero");
        }
        if (user.length() == 0) {
            throw new SshParameterException("The user name cannot be empty");
        }
        if (keyfileLocation.length() == 0) {
            if (authPhrase.length() == 0) {
                throw new SshParameterException("The authentication phrase cannot be empty");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting up JSCH/SSH connection, password authentication, host='" + host + "', user='" + user + "'"));
            }
            UserInfoAdapter ui = new UserInfoAdapter(authPhrase);
            jschSession.setUserInfo((UserInfo)ui);
        } else {
            keyfileLocation = JschSessionFactory.resolveAndVerifyKeyfilePath(keyfileLocation);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting up JSCH/SSH connection, keyfile authentication, host='" + host + "', user='" + user + "', keyfile='" + keyfileLocation + "'"));
            }
            jsch.addIdentity(keyfileLocation, authPhrase);
        }
        JSch.setLogger((Logger)connectionLogger);
        jschSession.setServerAliveInterval(5000);
        jschSession.setConfig(MAX_AUTH_TRIES_CONFIG_KEY, MAX_AUTH_TRIES);
        jschSession.connect();
        return jschSession;
    }

    public static Logger createDelegateLogger(Log apacheCommonsLogger) {
        return new ACLDelegate(apacheCommonsLogger, 1);
    }

    private static String normalizeKeyfilePath(String location) throws SshParameterException {
        if (location == null) {
            location = "";
        }
        return location.trim();
    }

    private static String resolveAndVerifyKeyfilePath(String location) throws SshParameterException {
        location = location.replace("~", System.getProperty("user.home"));
        File sshKeyFile = new File(location);
        location = sshKeyFile.getAbsolutePath();
        if (!sshKeyFile.isFile()) {
            throw new SshParameterException("SSH keyfile '" + location + "' does not exist");
        }
        return location;
    }

    private static final class ACLDelegate
    implements Logger {
        private static final String FORWARDED_LOG_LINE_PREFIX = "SSH connection: ";
        private static final String LOG_FILTER_FULL_MESSAGE_1 = "CheckCiphers: chacha20-poly1305@openssh.com";
        private static final String LOG_FILTER_FULL_MESSAGE_2 = "CheckKexes: curve25519-sha256,curve25519-sha256@libssh.org,curve448-sha512";
        private static final String LOG_FILTER_FULL_MESSAGE_3 = "CheckSignatures: ssh-ed25519,ssh-ed448";
        private static final String LOG_FILTER_FULL_MESSAGE_4 = "ssh_ecdsa_verify: ecdsa-sha2-nistp521 signature true";
        private static final String LOG_FILTER_FULL_MESSAGE_5 = "server-sig-algs=<ecdsa-sha2-nistp256-cert-v01@openssh.com,ecdsa-sha2-nistp384-cert-v01@openssh.com,ecdsa-sha2-nistp521-cert-v01@openssh.com,rsa-sha2-512-cert-v01@openssh.com,rsa-sha2-256-cert-v01@openssh.com,ecdsa-sha2-nistp256,ecdsa-sha2-nistp384,ecdsa-sha2-nistp521,sk-ecdsa-sha2-nistp256@openssh.com,rsa-sha2-512,rsa-sha2-256,ssh-rsa>";
        private static final String LOG_FILTER_FULL_MESSAGE_6 = "expecting SSH_MSG_KEX_ECDH_REPLY";
        private static final String LOG_FILTER_STARTS_WITH_1 = "server proposal: ";
        private static final String LOG_FILTER_STARTS_WITH_2 = "client proposal: ";
        private static final String LOG_FILTER_ENDS_WITH_1 = " sent";
        private static final String LOG_FILTER_ENDS_WITH_2 = " received";
        private final Log apacheCommonsLogger;
        private final int minLevel;

        private ACLDelegate(Log apacheCommonsLogger, int minLevel) {
            this.apacheCommonsLogger = apacheCommonsLogger;
            this.minLevel = minLevel;
        }

        public void log(int level, String rawMessage) {
            if (level >= this.minLevel) {
                if (level == 0) {
                    this.apacheCommonsLogger.debug((Object)(FORWARDED_LOG_LINE_PREFIX + rawMessage + " [L0]"));
                } else if (level == 1) {
                    if (this.minLevel > 0 && (rawMessage.equals(LOG_FILTER_FULL_MESSAGE_1) || rawMessage.equals(LOG_FILTER_FULL_MESSAGE_2) || rawMessage.equals(LOG_FILTER_FULL_MESSAGE_3) || rawMessage.equals(LOG_FILTER_FULL_MESSAGE_4) || rawMessage.equals(LOG_FILTER_FULL_MESSAGE_5) || rawMessage.equals(LOG_FILTER_FULL_MESSAGE_6) || rawMessage.startsWith(LOG_FILTER_STARTS_WITH_1) || rawMessage.startsWith(LOG_FILTER_STARTS_WITH_2) || rawMessage.endsWith(LOG_FILTER_ENDS_WITH_1) || rawMessage.endsWith(LOG_FILTER_ENDS_WITH_2))) {
                        return;
                    }
                    this.apacheCommonsLogger.debug((Object)(FORWARDED_LOG_LINE_PREFIX + rawMessage));
                } else if (level == 2) {
                    if (rawMessage.startsWith("Permanently added ")) {
                        this.apacheCommonsLogger.debug((Object)(FORWARDED_LOG_LINE_PREFIX + rawMessage.replace("Permanently added ", "(Disabled) Would permanently add ")));
                    } else if (rawMessage.startsWith("an exception ")) {
                        this.apacheCommonsLogger.debug((Object)(FORWARDED_LOG_LINE_PREFIX + rawMessage.replace("an exception during authentication\n", "Caught an exception during authentication: ")));
                    } else {
                        this.apacheCommonsLogger.warn((Object)(FORWARDED_LOG_LINE_PREFIX + rawMessage + " [L2]"));
                    }
                } else {
                    this.apacheCommonsLogger.error((Object)(FORWARDED_LOG_LINE_PREFIX + rawMessage + "[L" + level + "]"));
                }
            }
        }

        public boolean isEnabled(int level) {
            return level >= this.minLevel;
        }
    }

    private static final class UserInfoAdapter
    implements UserInfo,
    UIKeyboardInteractive {
        private String pw;

        UserInfoAdapter(String pw) {
            this.pw = pw;
        }

        public String getPassphrase() {
            log.warn((Object)"SSH called getPassphrase() unexpectedly");
            return null;
        }

        public String getPassword() {
            log.warn((Object)"SSH called getPassword() unexpectedly");
            return this.pw;
        }

        public boolean promptPassphrase(String arg0) {
            log.warn((Object)("SSH login sent a passphrase prompt (answered with no passphrase): " + arg0));
            return false;
        }

        public boolean promptPassword(String arg0) {
            log.debug((Object)("SSH login sent a password prompt: " + arg0));
            return true;
        }

        public boolean promptYesNo(String arg0) {
            log.warn((Object)("SSH login sent a yes/no prompt (answered 'no'): " + arg0));
            return false;
        }

        public void showMessage(String arg0) {
            log.debug((Object)("SSH login sent a message: " + arg0));
        }

        public String[] promptKeyboardInteractive(String arg0, String arg1, String arg2, String[] arg3, boolean[] arg4) {
            if (log.isDebugEnabled()) {
                log.debug((Object)StringUtils.format((String)"Simulating keyboard-interactive login; display parameters: %s, %s, %s, %d", (Object[])new Object[]{arg0, arg1, arg2, arg3.length}));
            }
            return new String[]{this.pw};
        }
    }
}

