/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common.xml.impl;

import de.rcenvironment.core.utils.common.xml.EMappingMode;
import de.rcenvironment.core.utils.common.xml.XMLException;
import de.rcenvironment.core.utils.common.xml.XMLMapperConstants;
import de.rcenvironment.core.utils.common.xml.XMLMappingInformation;
import de.rcenvironment.core.utils.common.xml.XMLNamespaceContext;
import de.rcenvironment.core.utils.common.xml.XSLTErrorHandler;
import de.rcenvironment.core.utils.common.xml.api.XMLMapperService;
import de.rcenvironment.core.utils.common.xml.api.XMLSupportService;
import de.rcenvironment.toolkit.utils.text.TextLinesReceiver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.serialize.MessageEmitter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLMapperServiceImpl
implements XMLMapperService {
    public static final String XPATH_DELIMITER = "/";
    private TransformerFactory tFactory = null;
    private XMLSupportService xmlSupport;
    private Log log = LogFactory.getLog(this.getClass());

    public XMLMapperServiceImpl() {
        this.tFactory = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
        this.tFactory.setErrorListener(new XSLTErrorHandler());
    }

    public void bindXMLSupportService(XMLSupportService service) {
        this.xmlSupport = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transformXMLFileWithXSLT(File sourceFile, File resultFile, File xsltFile, TextLinesReceiver logReceiver) throws XMLException {
        Transformer transformer = null;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileOutputStream resultFileOutputStream = new FileOutputStream(resultFile);){
                transformer = this.tFactory.newTransformer(new StreamSource(xsltFile));
                transformer.setErrorListener(new XSLTErrorHandler());
                MessageEmitter em = new MessageEmitter();
                StringWriter writer = new StringWriter();
                em.setWriter((Writer)writer);
                ((Controller)transformer).setMessageEmitter((Receiver)em);
                Object object = XMLMapperConstants.GLOBAL_MAPPING_LOCK;
                synchronized (object) {
                    StreamSource streamSource = new StreamSource(sourceFile);
                    transformer.transform(streamSource, new StreamResult(resultFileOutputStream));
                    em.close();
                    writer.close();
                }
                resultFileOutputStream.close();
                StringReader reader = new StringReader(writer.toString());
                LineIterator it = IOUtils.lineIterator((Reader)reader);
                while (it.hasNext()) {
                    String line = it.nextLine();
                    if (logReceiver != null) {
                        logReceiver.addLine("XSL:Message:" + line);
                    }
                    this.log.info((Object)("XSL:Message:" + line));
                }
                reader.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | TransformerException e) {
            throw new XMLException(e);
        }
    }

    protected void transformXMLFileWithXMLMappingInformation(Document sourceDoc, Document targetDoc, Document mappingsDoc) throws XPathExpressionException, XMLException {
        List<XMLMappingInformation> mappings = this.readXMLMapping(mappingsDoc);
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new XMLNamespaceContext(sourceDoc));
        block4: for (XMLMappingInformation mapInfo : mappings) {
            String targetNodeName;
            Node targetParentNode;
            EMappingMode mappingMode = mapInfo.getMode();
            String sourceXPath = mapInfo.getSourceXPath();
            String targetXPath = mapInfo.getTargetXPath();
            if (mappingMode == EMappingMode.DeleteOnly) {
                this.xmlSupport.deleteElement(targetDoc, targetXPath);
                continue;
            }
            NodeList sourceNodes = (NodeList)xpath.evaluate(sourceXPath, sourceDoc, XPathConstants.NODESET);
            if (sourceNodes.getLength() == 0) {
                throw new XMLException("No source elements found for map:source='" + sourceXPath);
            }
            switch (mappingMode) {
                case Append: {
                    Node sourceNode = sourceNodes.item(0);
                    Element sourceElement = null;
                    if (sourceNode.getNodeType() == 1) {
                        sourceElement = (Element)sourceNode;
                    } else if (sourceNode.getNodeType() == 9) {
                        sourceElement = sourceDoc.getDocumentElement();
                    }
                    if (sourceElement == null) {
                        throw new XMLException("Source node has an unsupported type.");
                    }
                    Document mappingDoc = this.createXPathMappings(sourceElement, mapInfo);
                    this.transformXMLFileWithXMLMappingInformation(sourceDoc, targetDoc, mappingDoc);
                    continue block4;
                }
                case Delete: {
                    this.xmlSupport.deleteElement(targetDoc, targetXPath);
                    break;
                }
                default: {
                    throw new XMLException("Unknown mapping mode: '" + mappingMode.toString() + "'");
                }
            }
            String[] targetPath = targetXPath.split(XPATH_DELIMITER);
            StringBuilder tmpPath = new StringBuilder();
            int i = 0;
            while (i < targetPath.length - 1) {
                if (targetPath[i].length() > 0) {
                    tmpPath.append(XPATH_DELIMITER).append(targetPath[i]);
                }
                ++i;
            }
            String targetParentPath = tmpPath.toString();
            if (targetParentPath.length() == 0) {
                targetParentNode = this.xmlSupport.createElementTree(targetDoc, targetXPath);
                targetNodeName = "";
            } else {
                targetParentNode = this.xmlSupport.createElementTree(targetDoc, targetParentPath);
                targetNodeName = targetPath[targetPath.length - 1];
            }
            int sourceIndex = 0;
            while (sourceIndex < sourceNodes.getLength()) {
                Node targetElement;
                Node sourceNode = sourceNodes.item(sourceIndex);
                Element sourceElement = null;
                if (sourceNode.getNodeType() == 1) {
                    sourceElement = (Element)sourceNode;
                } else if (sourceNode.getNodeType() == 9) {
                    sourceElement = sourceDoc.getDocumentElement();
                }
                if (sourceElement == null) {
                    throw new XMLException("Source node has an unsupported type.");
                }
                Element importElement = (Element)targetDoc.importNode(sourceElement, true);
                if (targetNodeName.length() == 0) {
                    targetElement = targetParentNode;
                } else {
                    targetElement = this.xmlSupport.createElement(targetDoc, targetNodeName);
                    targetParentNode.appendChild(targetElement);
                }
                if (targetElement == null) {
                    targetElement = this.xmlSupport.createElement(targetDoc, sourceElement.getNodeName());
                    targetDoc.appendChild(targetElement);
                }
                NamedNodeMap attrs = importElement.getAttributes();
                int i2 = 0;
                while (i2 < attrs.getLength()) {
                    Attr importAttr = (Attr)targetDoc.importNode(attrs.item(i2), true);
                    targetElement.getAttributes().setNamedItem(importAttr);
                    ++i2;
                }
                while (importElement.hasChildNodes()) {
                    targetElement.appendChild(importElement.getFirstChild());
                }
                ++sourceIndex;
            }
        }
    }

    @Override
    public void transformXMLFileWithXMLMappingInformation(File sourceFile, File targetFile, File mappingsFile) throws XPathExpressionException, XMLException {
        Document mappingsDoc = this.xmlSupport.readXMLFromFile(mappingsFile);
        this.transformXMLFileWithXMLMappingInformation(sourceFile, targetFile, mappingsDoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transformXMLFileWithXMLMappingInformation(File sourceFile, File targetFile, Document mappingsDoc) throws XPathExpressionException, XMLException {
        Object object = XMLMapperConstants.GLOBAL_MAPPING_LOCK;
        synchronized (object) {
            Document sourceDoc = this.xmlSupport.readXMLFromFile(sourceFile);
            Document targetDoc = targetFile.exists() ? this.xmlSupport.readXMLFromFile(targetFile) : this.xmlSupport.createDocument();
            this.transformXMLFileWithXMLMappingInformation(sourceDoc, targetDoc, mappingsDoc);
            this.xmlSupport.writeXMLtoFile(targetDoc, targetFile);
        }
    }

    protected List<XMLMappingInformation> readXMLMapping(Document mappingsDoc) throws XMLException {
        LinkedList<XMLMappingInformation> mappings = new LinkedList<XMLMappingInformation>();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(new XMLNamespaceContext(mappingsDoc));
            NodeList nodeList = (NodeList)xpath.evaluate("/map:mappings/map:mapping", mappingsDoc, XPathConstants.NODESET);
            int i = 0;
            while (i < nodeList.getLength()) {
                Node target;
                XMLMappingInformation mapInfo = new XMLMappingInformation();
                Element current = (Element)nodeList.item(i);
                NamedNodeMap attrs = current.getAttributes();
                int j = 0;
                while (j < attrs.getLength()) {
                    Attr mapAttr = (Attr)attrs.item(j);
                    if (mapAttr.getName().equals("mode")) {
                        if (mapAttr.getValue().equals("delete")) {
                            mapInfo.setMode(EMappingMode.Delete);
                        } else if (mapAttr.getValue().equals("delete-only")) {
                            mapInfo.setMode(EMappingMode.DeleteOnly);
                        } else if (mapAttr.getValue().equals("append")) {
                            mapInfo.setMode(EMappingMode.Append);
                        } else {
                            throw new XMLException("Unknown mapping mode: '" + mapAttr.getValue() + "'");
                        }
                    }
                    ++j;
                }
                Node source = (Node)xpath.evaluate("map:source", current, XPathConstants.NODE);
                if (source != null) {
                    mapInfo.setSourceXPath(source.getTextContent().trim());
                    if (mapInfo.getSourceXPath().length() == 0) {
                        throw new XMLException("Empty <map:source> element found in mapping file");
                    }
                } else if (mapInfo.getMode() != EMappingMode.DeleteOnly) {
                    throw new XMLException("No <map:source> element found in mapping file");
                }
                if ((target = (Node)xpath.evaluate("map:target", current, XPathConstants.NODE)) != null) {
                    mapInfo.setTargetXPath(target.getTextContent().trim());
                    if (mapInfo.getTargetXPath().length() == 0) {
                        throw new XMLException("Empty <map:target> element found in mapping file");
                    }
                } else {
                    throw new XMLException("No <map:target> element found in mapping file");
                }
                mappings.add(mapInfo);
                ++i;
            }
        }
        catch (XPathExpressionException e) {
            throw new XMLException("XML mapping error. No mapping nodes (/map:mappings/map:mapping) found in the mapping file. Please ensure that your mapping file contains the corresponding nodes and uses the corresponding namespace (xmlns:map=\"https://rcenvironment.de/2015/mapping\")", e);
        }
        return mappings;
    }

    private Document createXPathMappings(Element sourceElement, XMLMappingInformation mapInfo) throws XMLException {
        try {
            String sourceString = this.xmlSupport.writeXMLToString(sourceElement);
            StreamSource source = new StreamSource(new StringReader(sourceString));
            Document mappingDoc = this.xmlSupport.createDocument();
            DOMResult result = new DOMResult(mappingDoc);
            StreamSource inStreamXPath = new StreamSource(this.getClass().getClassLoader().getResourceAsStream("CreateXPaths.xslt"));
            Transformer transformer = this.tFactory.newTransformer(inStreamXPath);
            transformer.setErrorListener(new XSLTErrorHandler());
            transformer.setParameter("sourceXPath", mapInfo.getSourceXPath());
            transformer.setParameter("targetXPath", mapInfo.getTargetXPath());
            transformer.transform(source, result);
            return mappingDoc;
        }
        catch (TransformerException e) {
            throw new XMLException("Failed to create XPath mapping", e);
        }
    }
}

