/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common;

import de.rcenvironment.core.utils.common.CrossPlatformFilenameUtils;
import de.rcenvironment.core.utils.common.FileCompressionFormat;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FileCompressionService {
    private static final Log LOG = LogFactory.getLog(FileCompressionService.class);
    private static final String COMPRESS_IO_ISSUE = "Compress: Was not able to compress due to an IO issue: '%s'";
    private static final String EXPAND_THE_SOURCE_WAS_EMPTY = "Expand: The source was null.";
    private static final String EXPAND_IO_ISSUE = "Expand: Was not able to expand due to an IO issue: '%s'";
    private static final List<? extends FilenameFilter> FILTERS = Arrays.asList(new FilenameFilter(){

        @Override
        public boolean filter(File file) {
            return CrossPlatformFilenameUtils.isNFSFile(file.getName());
        }
    });

    private FileCompressionService() {
    }

    public static Boolean compressDirectoryToFile(File sourceDirectory, File destinationFile, FileCompressionFormat format, Boolean integrateSourceDirectory) {
        if (destinationFile == null) {
            LOG.error((Object)"Compress: The destination file was null.");
            return false;
        }
        if (format == null) {
            LOG.error((Object)"Compress: The desired compression format was null.");
            return false;
        }
        if (!destinationFile.getParentFile().exists() && !destinationFile.getParentFile().mkdirs()) {
            LOG.error((Object)String.format("Compress: Was not able to create the desired destination directories '%s'.", destinationFile.getParentFile()));
            return false;
        }
        if (destinationFile.isDirectory()) {
            LOG.error((Object)"Compress: The desired destination is a directory instead of a file.");
            return false;
        }
        if (sourceDirectory == null) {
            LOG.error((Object)"Compress: The source directory was null.");
            return false;
        }
        Path sourcePath = sourceDirectory.toPath();
        Boolean assumeSourceDirectoryExist = Files.exists(sourcePath, new LinkOption[0]) ? Boolean.valueOf(true) : (Files.notExists(sourcePath, new LinkOption[0]) ? Boolean.valueOf(false) : Boolean.valueOf(false));
        if (!assumeSourceDirectoryExist.booleanValue()) {
            LOG.error((Object)"Compress: It seems that the source directory does not exist.");
            return false;
        }
        try {
            Throwable throwable = null;
            Object var7_10 = null;
            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destinationFile));){
                return FileCompressionService.compressDirectoryToOutputStream(sourceDirectory, bos, format, integrateSourceDirectory);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)String.format("Compress: Was not able to compress due to a file not found issue: '%s'", e.getMessage()));
            return false;
        }
        catch (IOException e) {
            LOG.error((Object)String.format(COMPRESS_IO_ISSUE, e.getMessage()));
            return false;
        }
    }

    public static Boolean compressDirectoryToOutputStream(File sourceDirectory, OutputStream destination, FileCompressionFormat format, Boolean integrateSourceDirectory) {
        OutputStream outputStream;
        if (sourceDirectory == null) {
            LOG.error((Object)"Compress: The source directory was null.");
            return false;
        }
        if (destination == null) {
            LOG.error((Object)"Compress: The destination output stream was null.");
            return false;
        }
        if (format == null) {
            LOG.error((Object)"Compress: The desired compression format was null.");
            return false;
        }
        Path sourcePath = sourceDirectory.toPath();
        Boolean assumeSourceDirectoryExist = Files.exists(sourcePath, new LinkOption[0]) ? Boolean.valueOf(true) : (Files.notExists(sourcePath, new LinkOption[0]) ? Boolean.valueOf(false) : Boolean.valueOf(false));
        if (!assumeSourceDirectoryExist.booleanValue()) {
            LOG.error((Object)"Compress: It seems that the source directory does not exist.");
            return false;
        }
        if (!sourceDirectory.isDirectory()) {
            LOG.error((Object)"Compress: The source is a file instead of a directory.");
            return false;
        }
        if (format.applyGzipToArchiveStream()) {
            try {
                outputStream = new GZIPOutputStream(destination);
            }
            catch (IOException e) {
                LOG.error((Object)"Error creating GZip stream", (Throwable)e);
                return false;
            }
        } else {
            outputStream = destination;
        }
        try {
            Throwable e = null;
            Object var8_12 = null;
            try (ArchiveOutputStream aos = new ArchiveStreamFactory().createArchiveOutputStream(format.getArchiveStreamType(), outputStream);){
                return FileCompressionService.compress(aos, sourceDirectory, integrateSourceDirectory);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            LOG.error((Object)String.format(COMPRESS_IO_ISSUE, e.getMessage()));
            return false;
        }
        catch (ArchiveException e) {
            LOG.error((Object)String.format("Compress: Was not able to compress due to an archive issue: '%s'", e.getMessage()));
            return false;
        }
    }

    public static ByteArrayOutputStream compressDirectoryToByteStream(File sourceDirectory, FileCompressionFormat format, Boolean integrateSourceDirectory) {
        BufferedOutputStream bos;
        block13: {
            ByteArrayOutputStream byteArrayOutputStream;
            block14: {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Throwable throwable = null;
                Object var5_7 = null;
                bos = new BufferedOutputStream(baos);
                try {
                    Boolean result = FileCompressionService.compressDirectoryToOutputStream(sourceDirectory, bos, format, integrateSourceDirectory);
                    if (!result.booleanValue()) break block13;
                    byteArrayOutputStream = baos;
                    if (bos == null) break block14;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (bos != null) {
                                bos.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Object)String.format(COMPRESS_IO_ISSUE, e.getMessage()));
                        return null;
                    }
                }
                bos.close();
            }
            return byteArrayOutputStream;
        }
        if (bos != null) {
            bos.close();
        }
        return null;
    }

    public static byte[] compressDirectoryToByteArray(File sourceDirectory, FileCompressionFormat format, Boolean integrateSourceDirectory) {
        ByteArrayOutputStream optionalStream = FileCompressionService.compressDirectoryToByteStream(sourceDirectory, format, integrateSourceDirectory);
        if (optionalStream == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ByteArrayOutputStream baos = optionalStream;){
                return baos.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error((Object)String.format(COMPRESS_IO_ISSUE, e.getMessage()));
            return null;
        }
    }

    public static Boolean expandCompressedDirectoryFromFile(File sourceCompressed, File destinationDirectory, FileCompressionFormat format) {
        if (sourceCompressed == null) {
            LOG.error((Object)EXPAND_THE_SOURCE_WAS_EMPTY);
            return false;
        }
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceCompressed));){
                return FileCompressionService.expandCompressedDirectoryFromInputStream(bis, destinationDirectory, format);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)String.format("Expand: Was not able to expand due to a file not found issue: '%s'", e.getMessage()));
            return false;
        }
        catch (IOException e) {
            LOG.error((Object)String.format(EXPAND_IO_ISSUE, e.getMessage()));
            return false;
        }
    }

    public static Boolean expandCompressedDirectoryFromInputStream(InputStream sourceCompressed, File destinationDirectory, FileCompressionFormat format) {
        InputStream inputStream;
        if (sourceCompressed == null) {
            LOG.error((Object)EXPAND_THE_SOURCE_WAS_EMPTY);
            return false;
        }
        if (destinationDirectory == null) {
            LOG.error((Object)"Expand: The destination directory i.e. destinationDirectory was null.");
            return false;
        }
        if (format == null) {
            LOG.error((Object)"Expand: The desired compression format was null.");
            return false;
        }
        if (!destinationDirectory.exists() && !destinationDirectory.mkdirs()) {
            LOG.error((Object)String.format("Expand: Was not able to create the desired destination directory '%s'.", destinationDirectory.getPath()));
            return false;
        }
        if (!destinationDirectory.isDirectory()) {
            LOG.error((Object)"Expand: The destination is a file instead of a directory.");
            return false;
        }
        if (format.applyGzipToArchiveStream()) {
            try {
                inputStream = new GZIPInputStream(sourceCompressed);
            }
            catch (IOException e) {
                LOG.error((Object)"Error creating GZip stream", (Throwable)e);
                return false;
            }
        } else {
            inputStream = sourceCompressed;
        }
        try {
            Throwable e = null;
            Object var5_9 = null;
            try (ArchiveInputStream ais = new ArchiveStreamFactory().createArchiveInputStream(format.getArchiveStreamType(), inputStream);){
                return FileCompressionService.uncompress(ais, destinationDirectory);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            LOG.error((Object)String.format(EXPAND_IO_ISSUE, e.getMessage()));
            return false;
        }
        catch (ArchiveException e) {
            LOG.error((Object)String.format("Expand: Was not able to expand due to an archive issue: '%s'", e.getMessage()));
            return false;
        }
    }

    public static Boolean expandCompressedDirectoryFromByteStream(ByteArrayInputStream sourceCompressed, File destinationDirectory, FileCompressionFormat format) {
        if (sourceCompressed == null) {
            LOG.error((Object)EXPAND_THE_SOURCE_WAS_EMPTY);
            return false;
        }
        if (sourceCompressed.available() == 0) {
            LOG.warn((Object)"Expand: The given input stream was empty.");
            return false;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedInputStream bis = new BufferedInputStream(sourceCompressed);){
                return FileCompressionService.expandCompressedDirectoryFromInputStream(bis, destinationDirectory, format);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error((Object)String.format(EXPAND_IO_ISSUE, e.getMessage()));
            return false;
        }
    }

    public static Boolean expandCompressedDirectoryFromByteArray(byte[] sourceCompressed, File destinationDirectory, FileCompressionFormat format) {
        if (sourceCompressed == null) {
            LOG.error((Object)EXPAND_THE_SOURCE_WAS_EMPTY);
            return false;
        }
        if (sourceCompressed.length == 0) {
            LOG.warn((Object)"Expand: The given array was empty.");
            return false;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ByteArrayInputStream bais = new ByteArrayInputStream(sourceCompressed);){
                return FileCompressionService.expandCompressedDirectoryFromInputStream(bais, destinationDirectory, format);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error((Object)String.format(EXPAND_IO_ISSUE, e.getMessage()));
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Boolean compress(ArchiveOutputStream outputStream, File sourceDirectory, Boolean integrateSourceDirectory) {
        if (outputStream == null) {
            LOG.error((Object)"Was not able to compress due to missing output stream.");
            return false;
        }
        if (sourceDirectory == null) {
            LOG.error((Object)"Was not able to compress due to missing source directory.");
            return false;
        }
        ArchiveOutputStream os = outputStream;
        File source = sourceDirectory;
        if (os instanceof TarArchiveOutputStream) {
            ((TarArchiveOutputStream)os).setLongFileMode(3);
        }
        String sourceName = integrateSourceDirectory != false ? String.format("%s%s", source.getName(), File.separator) : "";
        block7: for (File file : FileUtils.listFilesAndDirs((File)source, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE)) {
            try {
                void var8_12;
                for (FilenameFilter filenameFilter : FILTERS) {
                    if (filenameFilter.filter(file)) continue block7;
                }
                if (file.equals(source)) {
                    if (!integrateSourceDirectory.booleanValue()) continue;
                    String string = sourceName;
                } else {
                    String string = String.format("%s%s", sourceName, StringUtils.difference((String)source.getCanonicalPath(), (String)file.getCanonicalPath()).substring(1));
                }
                os.putArchiveEntry(os.createArchiveEntry(file, (String)var8_12));
                if (file.isFile()) {
                    Object object = null;
                    Object var10_15 = null;
                    try (FileInputStream is = new FileInputStream(file);){
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                os.closeArchiveEntry();
            }
            catch (IOException iOException) {
                LOG.error((Object)String.format("Was not able to compress the file '%s'.", file.getPath()));
                return false;
            }
        }
        return true;
    }

    private static Boolean uncompress(ArchiveInputStream inputStream, File destinationDirectory) {
        String destinationPath;
        if (inputStream == null) {
            LOG.error((Object)"Was not able to uncompress due to missing input stream.");
            return false;
        }
        if (destinationDirectory == null) {
            LOG.error((Object)"Was not able to uncompres due to missing destination directory.");
            return false;
        }
        try {
            destinationPath = destinationDirectory.getCanonicalPath();
        }
        catch (IOException e) {
            LOG.error((Object)String.format("Was not able to construct the destination path for uncompres an archive: %s", e.getMessage()));
            return false;
        }
        ArchiveEntry entry = null;
        ArchiveInputStream is = inputStream;
        do {
            try {
                File directory;
                entry = is.getNextEntry();
                if (entry == null) break;
                String parentOfFile = entry.isDirectory() ? entry.getName() : new File(entry.getName()).getParent();
                if (parentOfFile != null && !parentOfFile.isEmpty() && !(directory = new File(destinationDirectory, parentOfFile)).exists()) {
                    FileUtils.forceMkdir((File)directory);
                }
                if (entry.isDirectory()) continue;
                File destinationFile = new File(destinationDirectory, entry.getName());
                if (!destinationFile.getCanonicalPath().startsWith(destinationPath)) {
                    LOG.warn((Object)String.format("Detected a zip slip attack while uncompress a file. The affected file is '%s'.The attack was prevented.", destinationDirectory.getCanonicalPath()));
                    return false;
                }
                Throwable throwable = null;
                Object var8_11 = null;
                try (FileOutputStream os = new FileOutputStream(destinationFile);){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioe) {
                LOG.error((Object)String.format("Was not able to uncompress the archive: '%s'", ioe.getMessage()));
                return false;
            }
        } while (entry != null);
        return true;
    }

    private static interface FilenameFilter {
        public boolean filter(File var1);
    }
}

