/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.headless.textui;

import com.googlecode.lanterna.TerminalFacade;
import com.googlecode.lanterna.gui.Action;
import com.googlecode.lanterna.gui.Component;
import com.googlecode.lanterna.gui.DefaultBackgroundRenderer;
import com.googlecode.lanterna.gui.GUIScreen;
import com.googlecode.lanterna.gui.GUIScreenBackgroundRenderer;
import com.googlecode.lanterna.gui.Interactable;
import com.googlecode.lanterna.gui.Window;
import com.googlecode.lanterna.gui.component.Label;
import com.googlecode.lanterna.gui.component.PasswordBox;
import com.googlecode.lanterna.gui.component.RadioCheckBoxList;
import com.googlecode.lanterna.gui.component.TextBox;
import com.googlecode.lanterna.gui.dialog.DialogButtons;
import com.googlecode.lanterna.gui.dialog.DialogResult;
import com.googlecode.lanterna.gui.dialog.ListSelectDialog;
import com.googlecode.lanterna.gui.dialog.MessageBox;
import com.googlecode.lanterna.gui.dialog.TextInputDialog;
import com.googlecode.lanterna.gui.layout.LayoutParameter;
import com.googlecode.lanterna.gui.listener.WindowAdapter;
import com.googlecode.lanterna.gui.listener.WindowListener;
import com.googlecode.lanterna.input.Key;
import de.rcenvironment.core.configuration.ConfigurationException;
import de.rcenvironment.core.configuration.bootstrap.BootstrapConfiguration;
import de.rcenvironment.core.configuration.ui.LanternaUtils;
import de.rcenvironment.core.embedded.ssh.api.SshAccount;
import de.rcenvironment.core.embedded.ssh.api.SshAccountConfigurationService;
import de.rcenvironment.core.mail.SMTPServerConfiguration;
import de.rcenvironment.core.mail.SMTPServerConfigurationService;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationTextUI {
    private static final String OPTION_CHANGE_PASSWORD = "Change password";
    private static final String OPTION_CONVERT_TO_RA_ACCOUNT = "Convert to a Remote Access account (change \"role\")";
    private static final int DEFAULT_TEXT_FIELD_WIDTH = 40;
    private static final String OPTION_ADD_SSH_ACCOUNT = "Remote Access: Add a new SSH account";
    private static final String OPTION_EDIT_SSH_ACCOUNTS = "Remote Access: Edit existing SSH accounts";
    private static final String OPTION_CONFIGURE_SMTP_SERVER = "Mail: Configure SMTP mail server";
    private static final String OPTION_ENABLE_ACCOUNT = "Enable account";
    private static final String OPTION_DISABLE_ACCOUNT = "Disable account";
    private static final String OPTION_DELETE_ACCOUNT = "Permanently delete account";
    private static final String REMOTE_ACCESS_ROLE_ID = "remote_access_user";
    private static final String REMOTE_ACCESS_ROLE_ID_ALIAS = "remote access";
    private final SshAccountConfigurationService sshAccountOperations;
    private final SMTPServerConfigurationService smtpServerConfigurationOperations;
    private GUIScreen guiScreen;
    private final Log log = LogFactory.getLog(this.getClass());

    public ConfigurationTextUI(SshAccountConfigurationService sshConfigurationService, SMTPServerConfigurationService smtpServerConfigurationOperations) {
        this.sshAccountOperations = sshConfigurationService;
        this.smtpServerConfigurationOperations = smtpServerConfigurationOperations;
    }

    public void run() {
        this.guiScreen = TerminalFacade.createGUIScreen();
        if (this.guiScreen == null) {
            this.log.error((Object)"Failed to initialize text-mode UI; terminating");
            return;
        }
        String profileName = BootstrapConfiguration.getInstance().getProfile().getLocationDependentName();
        this.guiScreen.setBackgroundRenderer((GUIScreenBackgroundRenderer)new DefaultBackgroundRenderer("RCE Configuration Shell, editing profile : " + profileName));
        this.guiScreen.getScreen().startScreen();
        String verifyError = this.sshAccountOperations.verifyExpectedStateForConfigurationEditing();
        if (verifyError == null) {
            try {
                this.runMainLoop();
            }
            catch (RuntimeException e) {
                LanternaUtils.showErrorMessageBox((GUIScreen)this.guiScreen, (String)"There was an internal error running the configuration menu. Please check the log file for details");
                this.log.error((Object)"Uncaught RuntimeException in text UI", (Throwable)e);
            }
        } else {
            LanternaUtils.showErrorMessageBox((GUIScreen)this.guiScreen, (String)verifyError);
        }
        this.guiScreen.getScreen().stopScreen();
    }

    private void runMainLoop() {
        String action;
        block10: while ((action = this.showMainMenu()) != null) {
            switch (action) {
                case "Remote Access: Add a new SSH account": {
                    this.showAddAccountDialog();
                    continue block10;
                }
                case "Remote Access: Edit existing SSH accounts": {
                    this.showSelectExistingAccountDialog();
                    continue block10;
                }
                case "Mail: Configure SMTP mail server": {
                    this.guiScreen.showWindow((Window)new ConfigureSMTPServerWindow(), GUIScreen.Position.CENTER);
                    continue block10;
                }
            }
            this.log.error((Object)("Invalid action: " + action));
        }
        return;
    }

    private String showMainMenu() {
        ArrayList<String> options = new ArrayList<String>();
        options.add(OPTION_ADD_SSH_ACCOUNT);
        options.add(OPTION_EDIT_SSH_ACCOUNTS);
        options.add(OPTION_CONFIGURE_SMTP_SERVER);
        String result = (String)ListSelectDialog.showDialog((GUIScreen)this.guiScreen, (String)"Select Action", null, (Object[])options.toArray());
        return result;
    }

    private void showAddAccountDialog() {
        this.guiScreen.showWindow((Window)new AddAccountWindow(), GUIScreen.Position.CENTER);
    }

    private void showSelectExistingAccountDialog() {
        SortedMap accountMap;
        ArrayList<SshAccountUIEntry> options = new ArrayList<SshAccountUIEntry>();
        try {
            accountMap = this.sshAccountOperations.getStaticAccountsByLoginName();
        }
        catch (ConfigurationException configurationException) {
            this.log.error((Object)"Error getting account data", (Throwable)configurationException);
            LanternaUtils.showErrorMessageBox((GUIScreen)this.guiScreen, (String)configurationException.getMessage());
            return;
        }
        for (Map.Entry entry : accountMap.entrySet()) {
            SshAccount account;
            String loginName;
            String id = (String)entry.getKey();
            if (!id.equals(loginName = (account = (SshAccount)entry.getValue()).getLoginName())) {
                this.log.error((Object)StringUtils.format((String)"Internal consistency error: account returned with map id '%s', but the account user name is '%s'", (Object[])new Object[]{id, loginName}));
            }
            String displayText = this.isRemoteAccessAccount(account) ? loginName : String.valueOf(loginName) + " [custom configuration]";
            if (!account.isEnabled()) {
                displayText = String.valueOf(displayText) + " [disabled]";
            }
            options.add(new SshAccountUIEntry(displayText, account));
        }
        if (options.isEmpty()) {
            LanternaUtils.showErrorMessageBox((GUIScreen)this.guiScreen, (String)"There are no SSH accounts (yet)!");
            return;
        }
        SshAccountUIEntry sshAccountUIEntry = (SshAccountUIEntry)ListSelectDialog.showDialog((GUIScreen)this.guiScreen, (String)"Select an account to edit", null, (Object[])options.toArray());
        if (sshAccountUIEntry == null) {
            return;
        }
        this.showEditSelectedAccountDialog(sshAccountUIEntry.getAccount());
    }

    private void showEditSelectedAccountDialog(SshAccount account) {
        String loginName = account.getLoginName();
        ArrayList<String> options = new ArrayList<String>();
        options.add(OPTION_CHANGE_PASSWORD);
        if (!this.isRemoteAccessAccount(account)) {
            options.add(OPTION_CONVERT_TO_RA_ACCOUNT);
        }
        if (account.isEnabled()) {
            options.add(OPTION_DISABLE_ACCOUNT);
        } else {
            options.add(OPTION_ENABLE_ACCOUNT);
        }
        options.add(OPTION_DELETE_ACCOUNT);
        String selection = (String)ListSelectDialog.showDialog((GUIScreen)this.guiScreen, (String)("Configure Account \"" + loginName + "\""), null, (Object[])options.toArray());
        if (selection == null) {
            return;
        }
        try {
            switch (selection) {
                case "Change password": {
                    String newPW = TextInputDialog.showPasswordInputBox((GUIScreen)this.guiScreen, (String)OPTION_CHANGE_PASSWORD, (String)("Enter the new password for account \"" + loginName + "\":"), (String)"");
                    if (StringUtils.isNullorEmpty((String)newPW)) {
                        LanternaUtils.showErrorMessageBox((GUIScreen)this.guiScreen, (String)"Password change aborted");
                        return;
                    }
                    this.sshAccountOperations.updatePasswordHash(loginName, newPW);
                    LanternaUtils.showSuccessMessageBox((GUIScreen)this.guiScreen, (String)"Account password updated");
                    break;
                }
                case "Convert to a Remote Access account (change \"role\")": {
                    this.sshAccountOperations.updateRole(loginName, REMOTE_ACCESS_ROLE_ID);
                    LanternaUtils.showSuccessMessageBox((GUIScreen)this.guiScreen, (String)"Converted to \"Remote Access\" account");
                    break;
                }
                case "Enable account": {
                    this.sshAccountOperations.setAccountEnabled(loginName, true);
                    LanternaUtils.showSuccessMessageBox((GUIScreen)this.guiScreen, (String)"Account enabled");
                    return;
                }
                case "Disable account": {
                    this.sshAccountOperations.setAccountEnabled(loginName, false);
                    LanternaUtils.showSuccessMessageBox((GUIScreen)this.guiScreen, (String)"Account disabled");
                    return;
                }
                case "Permanently delete account": {
                    DialogResult confirmation = MessageBox.showMessageBox((GUIScreen)this.guiScreen, (String)"Confirm account deletion", (String)("Really delete account \"" + loginName + "\"?"), (DialogButtons)DialogButtons.YES_NO);
                    if (confirmation != DialogResult.YES) {
                        return;
                    }
                    this.sshAccountOperations.deleteAccount(loginName);
                    LanternaUtils.showSuccessMessageBox((GUIScreen)this.guiScreen, (String)("Account \"" + loginName + "\" deleted"));
                    return;
                }
                default: {
                    LanternaUtils.showErrorMessageBox((GUIScreen)this.guiScreen, (String)"Internal error: no such option");
                    break;
                }
            }
        }
        catch (ConfigurationException e) {
            LanternaUtils.showErrorMessageBox((GUIScreen)this.guiScreen, (String)("Operation failed: " + e.getMessage()));
        }
    }

    private boolean isRemoteAccessAccount(SshAccount account) {
        return REMOTE_ACCESS_ROLE_ID.equals(account.getRole()) || REMOTE_ACCESS_ROLE_ID_ALIAS.equals(account.getRole());
    }

    private class AddAccountWindow
    extends Window {
        private TextBox textBoxName;
        private PasswordBox textBoxPassword;

        AddAccountWindow() {
            super("Add a new Remote Access account");
            final Action okAction = new Action(){

                public void doAction() {
                    try {
                        String loginName = AddAccountWindow.this.textBoxName.getText();
                        String password = AddAccountWindow.this.textBoxPassword.getText();
                        ((AddAccountWindow)AddAccountWindow.this).ConfigurationTextUI.this.sshAccountOperations.createAccount(loginName, password);
                        AddAccountWindow.this.close();
                        LanternaUtils.showSuccessMessageBox((GUIScreen)((AddAccountWindow)AddAccountWindow.this).ConfigurationTextUI.this.guiScreen, (String)("The account \"" + loginName + "\" was successfully added."));
                    }
                    catch (ConfigurationException e) {
                        LanternaUtils.showErrorMessageBox((GUIScreen)((AddAccountWindow)AddAccountWindow.this).ConfigurationTextUI.this.guiScreen, (String)("Failed to create the account: " + e.getMessage()));
                    }
                }
            };
            final Action cancelAction = new Action(){

                public void doAction() {
                    AddAccountWindow.this.close();
                }
            };
            this.textBoxName = new CustomTextBox("", 40, okAction);
            this.textBoxPassword = new CustomPasswordBox("", 40, okAction);
            this.addComponent((Component)new Label("Login name:"), new LayoutParameter[0]);
            this.addComponent((Component)this.textBoxName, new LayoutParameter[0]);
            this.addComponent((Component)new Label("Password:"), new LayoutParameter[0]);
            this.addComponent((Component)this.textBoxPassword, new LayoutParameter[0]);
            this.addComponent((Component)LanternaUtils.createOkCancelButtonPanel((Action)okAction, (Action)cancelAction), new LayoutParameter[0]);
            this.addWindowListener((WindowListener)new WindowAdapter(){

                public void onUnhandledKeyboardInteraction(Window arg0, Key key) {
                    if (key.getKind() == Key.Kind.Escape) {
                        cancelAction.doAction();
                        return;
                    }
                    if (key.getKind() == Key.Kind.Enter) {
                        okAction.doAction();
                        return;
                    }
                    ((AddAccountWindow)AddAccountWindow.this).ConfigurationTextUI.this.log.debug((Object)("Unhandled key in text-mode UI: " + key));
                }
            });
        }
    }

    private class ConfigureSMTPServerWindow
    extends Window {
        private TextBox textBoxHost;
        private TextBox textBoxPort;
        private SetCheckedItemRadioCheckBoxList radioCheckBoxEncryption;
        private TextBox textBoxUsername;
        private PasswordBox passwordBoxPassword;
        private TextBox textBoxSender;

        ConfigureSMTPServerWindow() {
            super("SMTP mail server configuration");
            final Action okAction = new Action(){

                public void doAction() {
                    try {
                        int port;
                        String host = ConfigureSMTPServerWindow.this.textBoxHost.getText();
                        try {
                            port = Integer.parseInt(ConfigureSMTPServerWindow.this.textBoxPort.getText());
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ConfigurationException("Invalid port number.");
                        }
                        String encryption = (String)ConfigureSMTPServerWindow.this.radioCheckBoxEncryption.getCheckedItem();
                        String username = ConfigureSMTPServerWindow.this.textBoxUsername.getText();
                        String password = ConfigureSMTPServerWindow.this.passwordBoxPassword.getText();
                        String sender = ConfigureSMTPServerWindow.this.textBoxSender.getText();
                        ((ConfigureSMTPServerWindow)ConfigureSMTPServerWindow.this).ConfigurationTextUI.this.smtpServerConfigurationOperations.configureSMTPServer(host, port, encryption, username, password, sender);
                        ConfigureSMTPServerWindow.this.close();
                        LanternaUtils.showSuccessMessageBox((GUIScreen)((ConfigureSMTPServerWindow)ConfigureSMTPServerWindow.this).ConfigurationTextUI.this.guiScreen, (String)"Successfully stored the SMTP server configuration.");
                    }
                    catch (ConfigurationException e) {
                        LanternaUtils.showErrorMessageBox((GUIScreen)((ConfigureSMTPServerWindow)ConfigureSMTPServerWindow.this).ConfigurationTextUI.this.guiScreen, (String)("Unable to store the configuration: " + e.getMessage()));
                    }
                }
            };
            final Action cancelAction = new Action(){

                public void doAction() {
                    ConfigureSMTPServerWindow.this.close();
                }
            };
            this.addComponent((Component)new Label("Host:"), new LayoutParameter[0]);
            this.textBoxHost = new CustomTextBox("", 40, okAction);
            this.addComponent((Component)this.textBoxHost, new LayoutParameter[0]);
            this.addComponent((Component)new Label("Port:"), new LayoutParameter[0]);
            this.textBoxPort = new CustomTextBox("", 40, okAction);
            this.addComponent((Component)this.textBoxPort, new LayoutParameter[0]);
            this.addComponent((Component)new Label("Encryption:"), new LayoutParameter[0]);
            this.radioCheckBoxEncryption = new SetCheckedItemRadioCheckBoxList();
            this.radioCheckBoxEncryption.addItem("explicit");
            this.radioCheckBoxEncryption.addItem("implicit");
            this.addComponent((Component)this.radioCheckBoxEncryption, new LayoutParameter[0]);
            this.addComponent((Component)new Label("Username:"), new LayoutParameter[0]);
            this.textBoxUsername = new CustomTextBox("", 40, okAction);
            this.addComponent((Component)this.textBoxUsername, new LayoutParameter[0]);
            this.addComponent((Component)new Label("Password:"), new LayoutParameter[0]);
            this.passwordBoxPassword = new CustomPasswordBox("", 40, okAction);
            this.addComponent((Component)this.passwordBoxPassword, new LayoutParameter[0]);
            this.addComponent((Component)new Label("Sender:"), new LayoutParameter[0]);
            this.textBoxSender = new CustomTextBox("", 40, okAction);
            this.addComponent((Component)this.textBoxSender, new LayoutParameter[0]);
            SMTPServerConfiguration smtpServerConfiguration = ConfigurationTextUI.this.smtpServerConfigurationOperations.getSMTPServerConfiguration();
            if (smtpServerConfiguration != null) {
                this.textBoxHost.setText(smtpServerConfiguration.getHost());
                this.textBoxPort.setText(Integer.toString(smtpServerConfiguration.getPort()));
                this.radioCheckBoxEncryption.setCheckedItem(smtpServerConfiguration.getEncryption());
                this.textBoxUsername.setText(smtpServerConfiguration.getUsername());
                this.passwordBoxPassword.setText(smtpServerConfiguration.getPassword());
                this.textBoxSender.setText(smtpServerConfiguration.getSenderAsString());
            }
            this.addComponent((Component)LanternaUtils.createOkCancelButtonPanel((Action)okAction, (Action)cancelAction), new LayoutParameter[0]);
            this.addWindowListener((WindowListener)new WindowAdapter(){

                public void onUnhandledKeyboardInteraction(Window arg0, Key key) {
                    if (key.getKind() == Key.Kind.Escape) {
                        cancelAction.doAction();
                        return;
                    }
                    if (key.getKind() == Key.Kind.Enter) {
                        okAction.doAction();
                        return;
                    }
                    ((ConfigureSMTPServerWindow)ConfigureSMTPServerWindow.this).ConfigurationTextUI.this.log.debug((Object)("Unhandled key in text-mode UI: " + key));
                }
            });
        }
    }

    private class CustomPasswordBox
    extends PasswordBox {
        private Action enterAction;

        CustomPasswordBox(String initialContent, int width, Action enterAction) {
            super(initialContent, width);
            this.enterAction = enterAction;
        }

        public void setText(String text) {
            if (text != null) {
                super.setText(text);
            }
        }

        public Interactable.Result keyboardInteraction(Key key) {
            if (key.getKind() == Key.Kind.Enter) {
                if (this.enterAction != null) {
                    this.enterAction.doAction();
                }
                return Interactable.Result.EVENT_HANDLED;
            }
            return super.keyboardInteraction(key);
        }
    }

    private class CustomTextBox
    extends TextBox {
        private Action enterAction;

        CustomTextBox(String initialContent, int width, Action enterAction) {
            super(initialContent, width);
            this.enterAction = enterAction;
        }

        public void setText(String text) {
            if (text != null) {
                super.setText(text);
            }
        }

        public Interactable.Result keyboardInteraction(Key key) {
            if (key.getKind() == Key.Kind.Enter) {
                if (this.enterAction != null) {
                    this.enterAction.doAction();
                }
                return Interactable.Result.EVENT_HANDLED;
            }
            return super.keyboardInteraction(key);
        }
    }

    private class SetCheckedItemRadioCheckBoxList
    extends RadioCheckBoxList {
        private static final int CLEAR_SELECTION_INDEX = -1;

        private SetCheckedItemRadioCheckBoxList() {
        }

        public void setCheckedItem(Object item) {
            this.setCheckedItemIndex(-1);
            int i = 0;
            while (i < this.getNrOfItems()) {
                if (this.getItemAt(i).equals(item)) {
                    this.setCheckedItemIndex(i);
                    break;
                }
                ++i;
            }
        }
    }

    private class SshAccountUIEntry {
        private String displayText;
        private SshAccount account;

        SshAccountUIEntry(String displayText, SshAccount account) {
            this.displayText = displayText;
            this.account = account;
        }

        public SshAccount getAccount() {
            return this.account;
        }

        public String toString() {
            return this.displayText;
        }
    }
}

