/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.system.api.model;

import de.rcenvironment.core.monitoring.system.api.model.ProcessInformation;
import de.rcenvironment.core.monitoring.system.internal.SystemMonitoringUtils;
import java.io.Serializable;
import java.util.List;

public class FullSystemAndProcessDataSnapshot
implements Serializable {
    private static final long serialVersionUID = 4316060053937251752L;
    private double totalNodeCPUusage;
    private double systemIdle;
    private long totalNodeRAMUsage;
    private long totalNodeSystemRAM;
    private List<ProcessInformation> rceSubProcesses;
    private List<ProcessInformation> rceOwnProcesses;

    public FullSystemAndProcessDataSnapshot(double totalNodeCPUusage, long totalNodeRAMUsage, long totalNodeSystemRAM, double systemIdle, List<ProcessInformation> rceSubProcesses, List<ProcessInformation> rceOwnProcesses) {
        this.totalNodeCPUusage = totalNodeCPUusage;
        this.totalNodeRAMUsage = totalNodeRAMUsage;
        this.totalNodeSystemRAM = totalNodeSystemRAM;
        this.systemIdle = systemIdle;
        this.rceSubProcesses = rceSubProcesses;
        this.rceOwnProcesses = rceOwnProcesses;
    }

    public List<ProcessInformation> getRceSubProcesses() {
        return this.rceSubProcesses;
    }

    public List<ProcessInformation> getRceProcessesInfo() {
        return this.rceOwnProcesses;
    }

    public double getNodeCPUusage() {
        return this.totalNodeCPUusage;
    }

    public long getNodeRAMUsage() {
        return this.totalNodeRAMUsage;
    }

    public long getNodeSystemRAM() {
        return this.totalNodeSystemRAM;
    }

    public double getIdle() {
        return this.systemIdle;
    }

    public double getTotalRceOwnProcessesCpuUsage() {
        double usage = 0.0;
        for (ProcessInformation pinf : this.rceOwnProcesses) {
            usage += pinf.getCpuUsage();
        }
        return usage;
    }

    public long getTotalRceOwnProcessesRamUsage() {
        long usage = 0L;
        for (ProcessInformation pinf : this.rceOwnProcesses) {
            usage += pinf.getRamUsage();
        }
        return usage;
    }

    public double getTotalSubProcessesCpuUsage() {
        return this.calcTotalChildrenCpuUsage(this.rceSubProcesses);
    }

    private double calcTotalChildrenCpuUsage(List<ProcessInformation> list) {
        double usage = 0.0;
        for (ProcessInformation info : list) {
            usage += info.getCpuUsage() + this.calcTotalChildrenCpuUsage(info.getChildren());
        }
        return usage;
    }

    public double getOtherProcessCpuUsage() {
        return SystemMonitoringUtils.clampToPercentageOrNAN(this.totalNodeCPUusage - this.getTotalRceOwnProcessesCpuUsage() - this.getTotalSubProcessesCpuUsage());
    }

    public int hashCode() {
        int result = 1;
        result = this.rceOwnProcesses == null ? (result *= 31) : 31 * result + this.rceOwnProcesses.hashCode();
        result = this.rceSubProcesses == null ? (result *= 31) : 31 * result + this.rceSubProcesses.hashCode();
        long temp = Double.doubleToLongBits(this.systemIdle);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.totalNodeCPUusage);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.totalNodeRAMUsage ^ this.totalNodeRAMUsage >>> 32);
        result = 31 * result + (int)(this.totalNodeSystemRAM ^ this.totalNodeSystemRAM >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FullSystemAndProcessDataSnapshot other = (FullSystemAndProcessDataSnapshot)obj;
        if (this.rceOwnProcesses == null ? other.rceOwnProcesses != null : !this.rceOwnProcesses.equals(other.rceOwnProcesses)) {
            return false;
        }
        if (this.rceSubProcesses == null ? other.rceSubProcesses != null : !this.rceSubProcesses.equals(other.rceSubProcesses)) {
            return false;
        }
        if (Double.doubleToLongBits(this.systemIdle) != Double.doubleToLongBits(other.systemIdle)) {
            return false;
        }
        if (Double.doubleToLongBits(this.totalNodeCPUusage) != Double.doubleToLongBits(other.totalNodeCPUusage)) {
            return false;
        }
        if (this.totalNodeRAMUsage != other.totalNodeRAMUsage) {
            return false;
        }
        return this.totalNodeSystemRAM == other.totalNodeSystemRAM;
    }

    public String toString() {
        double totalRceUsage = this.getTotalRceOwnProcessesCpuUsage();
        double totalChildUsage = this.getTotalSubProcessesCpuUsage();
        double idle = this.getIdle();
        StringBuilder sb = new StringBuilder();
        sb.append("Total node cpu usage: " + this.totalNodeCPUusage + "\n");
        sb.append("Total node ram: " + this.totalNodeSystemRAM + "\n");
        sb.append("Total used ram: " + this.totalNodeRAMUsage + "\n");
        sb.append("RCE cpu usage: " + totalRceUsage + "%" + "\n");
        sb.append("RCE Sub-Processes: " + totalChildUsage + "%" + "\n");
        for (ProcessInformation child : this.rceSubProcesses) {
            sb.append(child.toString());
        }
        sb.append("System Idle: " + idle + "%" + "\n");
        sb.append("Other processes: " + (100.0 - totalRceUsage - totalChildUsage - idle) + "%" + "\n");
        return sb.toString();
    }
}

