/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.instancemanagement.internal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.LogFactory;

public final class InstanceOperationsUtils {
    public static final String TIMEOUT_REACHED_MESSAGE = "Timeout reached while trying to acquire the lock, aborting startup of instance with id: %s.";
    public static final String UNEXPECTED_ERROR_WHEN_TRYING_TO_ACQUIRE_A_FILE_LOCK_ON = "Unexpected error when trying to acquire a file lock on ";
    public static final String IM_LOCK_FILE_ACCESS_PERMISSIONS = "rw";
    public static final String INSTALLATION_ID_FILE_NAME = "installation";
    private static final String IM_LOCK_FILE_NAME = "instancemanagement.lock";
    private static final String SHUTDOWN_FILE_NAME = "shutdown.dat";
    private static final String SLASH = "/";

    private InstanceOperationsUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean lockIMLockFile(File profile, long timeout) throws IOException {
        File lockfile = new File(String.valueOf(profile.getAbsolutePath()) + SLASH + IM_LOCK_FILE_NAME);
        lockfile.createNewFile();
        FileLock lock = null;
        if (!lockfile.isFile()) {
            throw new IOException("Lockfile isn't available.");
        }
        try {
            Throwable throwable = null;
            Object var6_6 = null;
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(lockfile, IM_LOCK_FILE_ACCESS_PERMISSIONS);){
                lock = randomAccessFile.getChannel().tryLock();
                if (lock != null) return true;
                long timestamp = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
                while (true) {
                    if (timestamp - TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) >= -timeout) {
                        return false;
                    }
                    lock = randomAccessFile.getChannel().tryLock();
                    if (lock != null) {
                        return true;
                    }
                    Thread.sleep(20L);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(UNEXPECTED_ERROR_WHEN_TRYING_TO_ACQUIRE_A_FILE_LOCK_ON);
        }
    }

    public static boolean isProfileLocked(File profileDir) throws IOException {
        if (!profileDir.isDirectory()) {
            throw new IOException("Profile directory " + profileDir.getAbsolutePath() + " can not be created or is not a directory");
        }
        File lockfile = new File(profileDir, "instance.lock");
        int attempt = 1;
        while (true) {
            block6: {
                if (lockfile.isFile()) break block6;
                return false;
            }
            try {
                return InstanceOperationsUtils.testProfileLockOnce(lockfile);
            }
            catch (IOException | OverlappingFileLockException e) {
                if (attempt >= 5) {
                    throw new IOException("Failed to check the profile lock at " + lockfile.getAbsolutePath() + " for " + attempt + " times; giving up", e);
                }
                LogFactory.getLog(InstanceOperationsUtils.class).debug((Object)("Failed to check the profile lock at " + lockfile.getAbsolutePath() + ", most likely due to another thread performing the same check concurrently (" + e.toString() + "); will retry"));
                ++attempt;
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean testProfileLockOnce(File lockfile) throws IOException, OverlappingFileLockException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(lockfile, IM_LOCK_FILE_ACCESS_PERMISSIONS);){
                FileLock lock = randomAccessFile.getChannel().tryLock();
                if (lock == null) return true;
                lock.release();
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IOException(UNEXPECTED_ERROR_WHEN_TRYING_TO_ACQUIRE_A_FILE_LOCK_ON + lockfile, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean detectShutdownFile(String path) throws IOException {
        WatchService watcher = FileSystems.getDefault().newWatchService();
        Path shutdownFile = Paths.get(String.valueOf(path) + SLASH + "internal" + SLASH + SHUTDOWN_FILE_NAME, new String[0]);
        Path shutdownFileDir = shutdownFile.getParent();
        File file = new File(shutdownFileDir.toString());
        shutdownFileDir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        while (!Thread.currentThread().isInterrupted()) {
            WatchKey watchKey;
            try {
                if (file.isDirectory()) {
                    File[] fileArray = file.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        if (f.getName().equals(SHUTDOWN_FILE_NAME)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                if (!(watchKey = watcher.take()).isValid()) {
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("Shutdown watcher task was interrupted.");
            }
            List<WatchEvent<?>> watchEvents = watchKey.pollEvents();
            for (WatchEvent<?> event : watchEvents) {
                Path createdFileRelativePath;
                Path createdFileAbsolutePath;
                if (!event.kind().equals(StandardWatchEventKinds.ENTRY_CREATE) || !(createdFileAbsolutePath = shutdownFileDir.resolve(createdFileRelativePath = (Path)event.context())).equals(shutdownFile)) continue;
                int i = 0;
                while (i < 2) {
                    if (Files.size(Paths.get(createdFileAbsolutePath.toUri())) != 0L) {
                        return true;
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException("Interrupted while waiting for shutdown file to appear");
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public static void deleteInstanceLockFromProfileFolder(File profileDir) {
        File[] fileArray = profileDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File fileInProfileDir = fileArray[n2];
            if (fileInProfileDir.isFile() && "instance.lock".equals(fileInProfileDir.getName())) {
                fileInProfileDir.delete();
                break;
            }
            ++n2;
        }
    }
}

