/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.timeline;

import de.rcenvironment.core.gui.workflow.view.timeline.ResizeListener;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineComponentCanvas;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineComponentRow;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TimelineComponentList
extends ScrolledComposite
implements ControlListener {
    private List<ResizeListener> resizeListener = new ArrayList<ResizeListener>();
    private Composite left = null;
    private Composite right = null;
    private SashForm list = null;
    private Map<Label, String> oldTextBuffer = new HashMap<Label, String>();

    public TimelineComponentList(Composite parent) {
        super(parent, 512);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.list = new SashForm((Composite)this, 256);
        this.list.setLayoutData((Object)gridData);
        this.setContent((Control)this.list);
        this.setAlwaysShowScrollBars(true);
        this.setExpandVertical(true);
        this.setExpandHorizontal(true);
        this.addControlListener(this);
        this.setShowFocusedControl(true);
        FormLayout form = new FormLayout();
        this.setLayout((Layout)form);
        this.left = new Composite((Composite)this.list, 0);
        this.left.addControlListener((ControlListener)this);
        GridLayout gridLayout = new GridLayout(1, false);
        this.left.setLayout((Layout)gridLayout);
        this.right = new Composite((Composite)this.list, 0);
        gridLayout = new GridLayout(1, false);
        this.right.setLayout((Layout)gridLayout);
        this.setWeights(new int[]{1, 7});
    }

    public void setWeights(int[] weights) {
        this.list.setWeights(weights);
    }

    public int[] getWeights() {
        return this.list.getWeights();
    }

    public void addComponentRow(TimelineComponentRow row) {
        String tooltipText = String.valueOf(row.getName()) + " - " + TimelineView.getComponentNameFromId(row.getComponentID(), (Object)this);
        CLabel nameLabel = new CLabel(this.left, 0);
        nameLabel.setImage(row.getIcon());
        nameLabel.setToolTipText(tooltipText);
        nameLabel.setText(row.getName());
        nameLabel.setBackground(this.getBackground());
        nameLabel.setMargins(nameLabel.getLeftMargin(), 0, nameLabel.getRightMargin(), 0);
        int labelHeight = nameLabel.computeSize((int)-1, (int)-1).y;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = labelHeight;
        TimelineComponentCanvas canvas = new TimelineComponentCanvas(this.right, row.getVisibleStartTime(), row.getVisibleEndTime());
        canvas.setLayoutData(gridData);
        canvas.setWorkflowEndTime(row.getWorkflowEndTime());
        canvas.setActivities(row.getActivities());
    }

    public void clear() {
        Control current;
        Control[] controlArray = this.left.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            current = controlArray[n2];
            current.dispose();
            if (current instanceof Label) {
                current.dispose();
            }
            ++n2;
        }
        controlArray = this.right.getChildren();
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            current = controlArray[n2];
            if (current instanceof TimelineComponentCanvas) {
                current.dispose();
            }
            ++n2;
        }
        this.left.layout();
        this.right.layout();
        this.oldTextBuffer.clear();
    }

    public void setTimeArea(Date startTime, Date endTime) {
        Control[] controlArray = this.right.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control currentRow = controlArray[n2];
            if (currentRow instanceof TimelineComponentCanvas) {
                TimelineComponentCanvas currentCanvas = (TimelineComponentCanvas)currentRow;
                currentCanvas.setVisibleTimeArea(startTime, endTime);
            }
            ++n2;
        }
    }

    public void setTimeTableComponentRows(TimelineComponentRow[] rows) {
        this.clear();
        if (rows == null || rows.length == 0) {
            return;
        }
        List<TimelineComponentRow> sortedRows = Arrays.asList(rows);
        Collections.sort(sortedRows);
        for (TimelineComponentRow currentRow : sortedRows) {
            this.addComponentRow(currentRow);
        }
        this.left.layout();
        this.right.layout();
    }

    public void controlMoved(ControlEvent arg0) {
    }

    public void controlResized(ControlEvent arg0) {
        if (arg0.getSource().equals((Object)this)) {
            Rectangle r = this.getClientArea();
            this.setMinSize(this.list.computeSize(r.width, -1));
        } else {
            this.notifyResizeListener();
        }
        this.redraw();
    }

    public void addResizeListener(ResizeListener a) {
        this.resizeListener.add(a);
    }

    public void notifyResizeListener() {
        for (ResizeListener current : this.resizeListener) {
            current.resized();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.left.setBackground(color);
        this.right.setBackground(color);
    }
}

