/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands.endpoint;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.RemoveDynamicEndpointCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import java.util.List;

public class RemoveDynamicInputWithOutputCommand
extends RemoveDynamicEndpointCommand {
    protected final String dynEndpointId;

    public RemoveDynamicInputWithOutputCommand(String dynEndpointId, List<String> names, Refreshable ... refreshable) {
        super(EndpointType.INPUT, dynEndpointId, names, refreshable);
        this.dynEndpointId = dynEndpointId;
    }

    @Override
    public void execute() {
        for (String name : this.names) {
            EndpointDescriptionsManager outputDescriptionsManager = this.getProperties().getOutputDescriptionsManager();
            outputDescriptionsManager.removeDynamicEndpointDescription(name);
        }
        super.execute();
    }

    @Override
    public void undo() {
        EndpointDescriptionsManager outputDescriptionsManager = this.getProperties().getOutputDescriptionsManager();
        for (String name : this.names) {
            EndpointDescription oldDesc = (EndpointDescription)this.oldDescriptions.get(name);
            outputDescriptionsManager.addDynamicEndpointDescription(this.dynEndpointId, oldDesc.getName(), oldDesc.getDataType(), oldDesc.getMetaData());
        }
        super.undo();
    }
}

