/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.views.contributors;

import de.rcenvironment.core.communication.utils.NetworkContactPointUtils;
import de.rcenvironment.core.gui.communication.views.contributors.AbstractNetworkConnectionDialog;
import java.util.Map;
import org.eclipse.swt.widgets.Shell;

public class EditNetworkConnectionDialog
extends AbstractNetworkConnectionDialog {
    protected static final String ERROR_MESSAGE = "One of the configured connection settings was invalid and was not passed to the dialog.";
    private static final String COLON = ":";
    private static final String DIALOG_TITLE = "Edit Connection";
    private static final String HINT = "Note: The connection will not be saved.\nTo create permanent connections, edit the configuration files.\nChanges will be applied after restarting the connection.";

    public EditNetworkConnectionDialog(Shell parentShell, String connectionName, String networkContactPointID) {
        super(parentShell, connectionName, networkContactPointID);
        if (this.networkContactPointID.startsWith("activemq-tcp:")) {
            this.networkContactPointID = this.networkContactPointID.replace("activemq-tcp:", "");
        }
        this.host = this.networkContactPointID.substring(0, this.networkContactPointID.indexOf(COLON));
        if (this.networkContactPointID.contains("(")) {
            int index = this.networkContactPointID.indexOf("(");
            String settings = this.networkContactPointID.substring(index);
            settings = settings.replaceAll("[()]", "");
            this.setConnectionSettings(settings);
            this.port = this.networkContactPointID.substring(this.networkContactPointID.indexOf(COLON) + 1, index);
            String network = this.networkContactPointID.substring(0, index);
            if (this.connectionName.equals(network)) {
                this.activateDefaultName();
            } else {
                this.deactivateDefaultName();
            }
        } else {
            this.port = this.networkContactPointID.substring(this.networkContactPointID.indexOf(COLON) + 1);
            if (this.connectionName.equals(this.networkContactPointID)) {
                this.activateDefaultName();
            } else {
                this.deactivateDefaultName();
            }
        }
        this.hint = HINT;
    }

    private void setConnectionSettings(String settings) {
        try {
            Map attributes = NetworkContactPointUtils.parseAttributePart((String)settings);
            if (attributes.containsKey("connectOnStartup")) {
                this.connectionSettings.setConnectOnStartup(Boolean.valueOf((String)attributes.get("connectOnStartup")));
            }
            if (attributes.containsKey("autoRetry")) {
                this.connectionSettings.setAutoRetry(Boolean.valueOf((String)attributes.get("autoRetry")));
            }
            if (attributes.containsKey("useDefaultSettings")) {
                this.connectionSettings.setUseDefaultSettings(Boolean.valueOf((String)attributes.get("useDefaultSettings")));
            }
            this.connectionSettings.setUseDefaultSettings(!attributes.containsKey("autoRetryInitialDelay") && !attributes.containsKey("autoRetryMaximumDelay") && !attributes.containsKey("autoRetryDelayMultiplier"));
            if (!(attributes.containsKey("autoRetryInitialDelay") && attributes.containsKey("autoRetryMaximumDelay") && attributes.containsKey("autoRetryDelayMultiplier"))) {
                this.errorMessage = ERROR_MESSAGE;
            }
            if (attributes.containsKey("autoRetryInitialDelay") && this.checkIfInputIsPositiveLong((String)attributes.get("autoRetryInitialDelay"))) {
                this.connectionSettings.setAutoRetryInitialDelay(Long.valueOf((String)attributes.get("autoRetryInitialDelay")));
            } else {
                this.connectionSettings.setAutoRetryInitialDelay(0L);
                this.errorMessage = ERROR_MESSAGE;
            }
            if (attributes.containsKey("autoRetryMaximumDelay") && this.checkIfInputIsPositiveLong((String)attributes.get("autoRetryMaximumDelay"))) {
                this.connectionSettings.setAutoRetryMaximumDelay(Long.valueOf((String)attributes.get("autoRetryMaximumDelay")));
            } else {
                this.connectionSettings.setAutoRetryMaximumDelay(0L);
                this.errorMessage = ERROR_MESSAGE;
            }
            if (attributes.containsKey("autoRetryDelayMultiplier") && this.checkIfInputIsValidMultiplier((String)attributes.get("autoRetryDelayMultiplier"))) {
                this.connectionSettings.setAutoRetryDelayMultiplier(Double.valueOf((String)attributes.get("autoRetryDelayMultiplier")));
            } else {
                this.connectionSettings.setAutoRetryDelayMultiplier(0.0);
                this.errorMessage = ERROR_MESSAGE;
            }
            if (Boolean.FALSE.equals(Boolean.valueOf((String)attributes.get("autoRetry")))) {
                this.errorMessage = null;
            }
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("The connection settings format is incorrect. The edit dialog cannot be displayed." + ex.toString());
        }
    }

    private boolean checkIfInputIsPositiveLong(String newS) {
        try {
            return Long.parseLong(newS) > 0L;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean checkIfInputIsValidMultiplier(String input) {
        return Double.valueOf(input) >= 1.0 && !input.equals("Infinity") && !input.equals("-Infinity");
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }
}

