/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.internal;

import de.rcenvironment.core.configuration.internal.OsgiServiceRegistryAccessFactory;
import de.rcenvironment.core.toolkitbridge.api.StaticToolkitHolder;
import de.rcenvironment.core.utils.common.service.AdditionalServiceDeclaration;
import de.rcenvironment.core.utils.common.service.AdditionalServicesProvider;
import de.rcenvironment.core.utils.common.service.AdditionalServicesRegistrationService;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import de.rcenvironment.toolkit.modules.statistics.api.CounterCategory;
import de.rcenvironment.toolkit.modules.statistics.api.StatisticsFilterLevel;
import de.rcenvironment.toolkit.modules.statistics.api.StatisticsTrackerService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.FrameworkUtil;

public class OsgiAdditionalServicesRegistrationServiceImpl
implements AdditionalServicesRegistrationService {
    private final Map<AdditionalServicesProvider, ServiceRegistryPublisherAccess> sraMap = new HashMap<AdditionalServicesProvider, ServiceRegistryPublisherAccess>();
    private final OsgiServiceRegistryAccessFactory serviceRegistryAccessFactory;
    private final Log log = LogFactory.getLog(this.getClass());
    private final CounterCategory counterCategory;

    public OsgiAdditionalServicesRegistrationServiceImpl() {
        this.serviceRegistryAccessFactory = new OsgiServiceRegistryAccessFactory(FrameworkUtil.getBundle(this.getClass()).getBundleContext());
        this.counterCategory = ((StatisticsTrackerService)StaticToolkitHolder.getService(StatisticsTrackerService.class)).getCounterCategory("Additional Service registrations via AdditionalServicesProvider API", StatisticsFilterLevel.DEVELOPMENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAdditionalServicesProvider(AdditionalServicesProvider additionalServicesProvider) {
        Map<AdditionalServicesProvider, ServiceRegistryPublisherAccess> map = this.sraMap;
        synchronized (map) {
            if (this.sraMap.get(additionalServicesProvider) != null) {
                throw new IllegalStateException("Duplicate registration of ListenerProvider " + additionalServicesProvider);
            }
            ServiceRegistryPublisherAccess sra = this.serviceRegistryAccessFactory.createPublisherAccessFor(additionalServicesProvider);
            this.sraMap.put(additionalServicesProvider, sra);
            for (AdditionalServiceDeclaration declaration : additionalServicesProvider.defineAdditionalServices()) {
                Object implementation;
                Class clazz = declaration.getServiceClass();
                if (!clazz.isInstance(implementation = declaration.getImplementation())) {
                    throw new IllegalStateException("Invalid ListenerDeclaration: implementation does not implement declared interface " + clazz + ": " + implementation);
                }
                this.log.debug((Object)("Registering " + clazz.getSimpleName() + " listener on behalf of " + additionalServicesProvider));
                sra.registerService(clazz, implementation);
                this.counterCategory.count(clazz.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAdditionalServicesProvider(AdditionalServicesProvider listenerProvider) {
        Map<AdditionalServicesProvider, ServiceRegistryPublisherAccess> map = this.sraMap;
        synchronized (map) {
            ServiceRegistryPublisherAccess sra = this.sraMap.get(listenerProvider);
            if (sra == null) {
                throw new IllegalStateException("No registration found for ListenerProvider " + listenerProvider);
            }
            this.sraMap.remove(listenerProvider);
            this.log.debug((Object)("Disposing listeners of " + listenerProvider));
            sra.dispose();
        }
    }
}

