/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.bootstrap.ui;

import com.googlecode.lanterna.TerminalFacade;
import com.googlecode.lanterna.gui.DefaultBackgroundRenderer;
import com.googlecode.lanterna.gui.GUIScreen;
import com.googlecode.lanterna.gui.GUIScreenBackgroundRenderer;
import com.googlecode.lanterna.terminal.Terminal;
import de.rcenvironment.core.configuration.ui.LanternaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ErrorTextUI {
    private static final String BACKGROUND_MESSAGE = "Error during startup...";
    private GUIScreen guiScreen;
    private String errorMessage;
    private Terminal terminal;
    private final Log log = LogFactory.getLog(this.getClass());

    public ErrorTextUI(String errorMessage, Terminal terminal) {
        this.errorMessage = errorMessage;
        this.terminal = terminal;
    }

    public ErrorTextUI(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void run() {
        this.guiScreen = this.terminal != null ? TerminalFacade.createGUIScreen((Terminal)this.terminal) : TerminalFacade.createGUIScreen();
        if (this.guiScreen == null) {
            this.log.error((Object)"Failed to initialize text-mode UI; terminating");
            return;
        }
        this.guiScreen.setBackgroundRenderer((GUIScreenBackgroundRenderer)new DefaultBackgroundRenderer(BACKGROUND_MESSAGE));
        this.guiScreen.getScreen().startScreen();
        LanternaUtils.showErrorMessageBox((GUIScreen)this.guiScreen, (String)this.errorMessage);
        this.guiScreen.getScreen().stopScreen();
    }
}

