/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.bootstrap;

import de.rcenvironment.core.configuration.bootstrap.EclipseLaunchParameters;
import de.rcenvironment.core.configuration.bootstrap.ParameterException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RuntimeDetection {
    private static final String ECLIPSE_COMMANDS_SYSTEM_PROPERTY = "eclipse.commands";
    private static final String ECLIPSE_APPLICATION_SYSTEM_PROPERTY = "eclipse.application";
    private static final String SUREFIRE_APPLICATION_IDENTIFIER = "org.eclipse.tycho.surefire.osgibooter.headlesstest";
    private static final String APPLICATION = "application (default)";
    private static final String OSGI_SUREFIRE_TEST = "OSGi Tycho/Surefire test";
    private static final String ECLIPSE_PLUGIN_TEST = "Eclipse \"JUnit Plug-In\" test";
    private static final String PLAIN_JAVA_TEST = "plain Java (assuming JUnit)";
    private static final RuntimeDetection INSTANCE = new RuntimeDetection();
    private final String environment = this.detectEnvironment();
    private boolean simulatedServiceActivationAllowed;

    private RuntimeDetection() {
        this.getTransientLogger().debug((Object)("Detected " + this.environment + " environment"));
    }

    private String detectEnvironment() {
        EclipseLaunchParameters launchParameters = EclipseLaunchParameters.getInstance();
        if (launchParameters.containsToken("-testproperties")) {
            try {
                String applicationParameter = launchParameters.getNamedParameter("-application", "-application");
            }
            catch (ParameterException e) {
                String applicationParameter = "<" + e.toString() + ">";
            }
            return OSGI_SUREFIRE_TEST;
        }
        if (launchParameters.containsToken("-testLoaderClass")) {
            return ECLIPSE_PLUGIN_TEST;
        }
        if (System.getProperty(ECLIPSE_COMMANDS_SYSTEM_PROPERTY) != null) {
            return APPLICATION;
        }
        return PLAIN_JAVA_TEST;
    }

    public static boolean isTestEnvironment() {
        return RuntimeDetection.INSTANCE.environment != APPLICATION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allowSimulatedServiceActivation() {
        RuntimeDetection runtimeDetection = INSTANCE;
        synchronized (runtimeDetection) {
            RuntimeDetection.INSTANCE.simulatedServiceActivationAllowed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isImplicitServiceActivationDenied() {
        if (RuntimeDetection.INSTANCE.environment == APPLICATION) {
            return false;
        }
        RuntimeDetection runtimeDetection = INSTANCE;
        synchronized (runtimeDetection) {
            return !RuntimeDetection.INSTANCE.simulatedServiceActivationAllowed;
        }
    }

    private Log getTransientLogger() {
        return LogFactory.getLog(this.getClass());
    }
}

