/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.authorization.api.AuthorizationAccessGroupKeyData;
import de.rcenvironment.core.authorization.api.AuthorizationPermissionSet;
import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.authorization.cryptography.api.CryptographyOperationsProvider;
import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.communication.management.WorkflowHostService;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.authorization.api.ComponentExecutionAuthorizationService;
import de.rcenvironment.core.component.authorization.api.RemotableComponentExecutionAuthorizationService;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.execution.api.RemotableComponentExecutionControllerService;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.workflow.execution.api.PersistentWorkflowDescriptionLoaderService;
import de.rcenvironment.core.component.workflow.execution.api.RemotableWorkflowExecutionControllerService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowDescriptionValidationResult;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionHandle;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowFileException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.component.workflow.execution.spi.WorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamanagement.MetaDataService;
import de.rcenvironment.core.eventlog.api.EventLog;
import de.rcenvironment.core.eventlog.api.EventLogConstants;
import de.rcenvironment.core.eventlog.api.EventLogEntry;
import de.rcenvironment.core.eventlog.api.EventType;
import de.rcenvironment.core.notification.DistributedNotificationService;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncExceptionListener;
import de.rcenvironment.toolkit.modules.concurrency.api.CallablesGroup;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component
public class WorkflowExecutionServiceImpl
implements WorkflowExecutionService {
    private static final Log LOG = LogFactory.getLog(WorkflowExecutionServiceImpl.class);
    private static final int ACTIVE_WORKFLOW_HEARTBEAT_NOTIFICATION_INTERVAL_MSEC = 6000;
    private final boolean verboseLogging = DebugSettings.getVerboseLoggingEnabled((String)"WorkflowExecution");
    private CommunicationService communicationService;
    private DistributedNotificationService notificationService;
    private PersistentWorkflowDescriptionLoaderService workflowDescriptionLoaderService;
    private PlatformService platformService;
    private WorkflowHostService workflowHostService;
    private RemotableWorkflowExecutionControllerService wfExeCtrlService;
    private ComponentExecutionAuthorizationService componentExecutionAuthorizationService;
    private DistributedComponentKnowledgeService componentKnowledgeService;
    private AuthorizationService authorizationService;
    private CryptographyOperationsProvider cryptographyOperationsProvider;
    private RemotableComponentExecutionControllerService componentExecutionControllerService;
    private Set<WorkflowExecutionInformation> workflowExecutionInformations;
    private Object wfExeFetchLock = new Object();
    private ScheduledFuture<?> heartbeatSendFuture;
    private MetaDataService metaDataService;

    @Activate
    protected void activate(BundleContext context) {
        this.heartbeatSendFuture = ConcurrencyUtils.getAsyncTaskService().scheduleAtFixedInterval("Send heartbeat for active workflows", this::sendHeartbeatForActiveWorkflows, 6000L);
    }

    @Deactivate
    protected void deactivate() {
        if (this.heartbeatSendFuture != null) {
            this.heartbeatSendFuture.cancel(true);
        }
    }

    @Override
    public WorkflowDescription loadWorkflowDescriptionFromFileConsideringUpdates(File wfFile, WorkflowDescriptionLoaderCallback callback) throws WorkflowFileException {
        return this.workflowDescriptionLoaderService.loadWorkflowDescriptionFromFileConsideringUpdates(wfFile, callback);
    }

    @Override
    public WorkflowDescription loadWorkflowDescriptionFromFileConsideringUpdates(File wfFile, WorkflowDescriptionLoaderCallback callback, boolean abortIfWorkflowUpdateRequired) throws WorkflowFileException {
        return this.workflowDescriptionLoaderService.loadWorkflowDescriptionFromFileConsideringUpdates(wfFile, callback, abortIfWorkflowUpdateRequired);
    }

    @Override
    public WorkflowDescription loadWorkflowDescriptionFromFile(File wfFile, WorkflowDescriptionLoaderCallback callback) throws WorkflowFileException {
        return this.workflowDescriptionLoaderService.loadWorkflowDescriptionFromFile(wfFile, callback);
    }

    @Override
    public WorkflowDescriptionValidationResult validateAvailabilityOfNodesAndComponentsFromLocalKnowledge(WorkflowDescription workflowDescription) {
        LogicalNodeId missingControllerNodeId = null;
        HashMap<String, LogicalNodeId> missingComponentsNodeIds = new HashMap<String, LogicalNodeId>();
        LogicalNodeId controllerNode = workflowDescription.getControllerNode();
        if (controllerNode == null) {
            controllerNode = this.platformService.getLocalDefaultLogicalNodeId();
        }
        if (!this.workflowHostService.getLogicalWorkflowHostNodesAndSelf().contains(controllerNode)) {
            missingControllerNodeId = controllerNode;
        }
        DistributedComponentKnowledge compKnowledge = this.componentKnowledgeService.getCurrentSnapshot();
        for (WorkflowNode node : workflowDescription.getWorkflowNodes()) {
            LogicalNodeId componentNode = node.getComponentDescription().getNode();
            if (componentNode == null) {
                componentNode = this.platformService.getLocalDefaultLogicalNodeId();
            }
            if (ComponentUtils.hasComponent((Collection)compKnowledge.getAllInstallations(), (String)node.getComponentDescription().getIdentifier(), (LogicalNodeId)componentNode)) continue;
            missingComponentsNodeIds.put(node.getName(), componentNode);
        }
        if (missingControllerNodeId == null && missingComponentsNodeIds.isEmpty()) {
            return WorkflowDescriptionValidationResult.createResultForSuccess();
        }
        return WorkflowDescriptionValidationResult.createResultForFailure(missingControllerNodeId, missingComponentsNodeIds);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Map<String, String> validateRemoteWorkflowControllerVisibilityOfComponents(WorkflowDescription wfDescription) {
        componentRefs = new ArrayList<String>();
        for (WorkflowNode wfDescNode : wfDescription.getWorkflowNodes()) {
            compLocation = wfDescNode.getComponentDescription().getNode();
            if (this.platformService.matchesLocalInstance((ResolvableNodeId)compLocation)) continue;
            componentRefs.add(StringUtils.escapeAndConcat((String[])new String[]{wfDescNode.getIdentifierAsObject().toString(), wfDescNode.getComponentIdentifierWithVersion(), compLocation.getLogicalNodeIdString()}));
        }
        remoteWFExecControllerService = (RemotableWorkflowExecutionControllerService)this.communicationService.getRemotableService(RemotableWorkflowExecutionControllerService.class, (NetworkDestination)wfDescription.getControllerNode());
        try {
            return remoteWFExecControllerService.verifyComponentVisibility(componentRefs);
        }
        catch (RemoteOperationException e) {
            result = new HashMap<String, String>();
            ** for (wfDescNode : wfDescription.getWorkflowNodes())
        }
lbl-1000:
        // 1 sources

        {
            result.put(wfDescNode.getIdentifierAsObject().toString(), "Failed to query the selected workflow controller about component visibility: " + e.getMessage());
            continue;
        }
lbl17:
        // 1 sources

        return result;
    }

    @Override
    public WorkflowExecutionInformation startWorkflowExecution(WorkflowExecutionContext wfExeCtx) throws WorkflowExecutionException, RemoteOperationException {
        WorkflowExecutionInformation workflowExecutionInformation = this.createExecutionController(wfExeCtx);
        try {
            this.performStartOnExecutionController(workflowExecutionInformation.getWorkflowExecutionHandle());
        }
        catch (ExecutionControllerException e) {
            throw new WorkflowExecutionException("Failed to execute workflow", (Exception)((Object)e));
        }
        return workflowExecutionInformation;
    }

    private WorkflowExecutionInformation createExecutionController(WorkflowExecutionContext wfExeCtx) throws RemoteOperationException, WorkflowExecutionException {
        WorkflowExecutionInformation result;
        Map<String, String> authTokens = this.acquireExecutionAuthorizationTokensForComponents(wfExeCtx.getWorkflowDescription());
        boolean controllerLocationIsLocalNode = this.platformService.matchesLocalInstance((ResolvableNodeId)wfExeCtx.getNodeId());
        EventLogEntry eventLogEntry = EventLog.newEntry((EventType)EventType.WORKFLOW_REQUEST_INITIATED).set("workflow_run_id", wfExeCtx.getExecutionIdentifier()).set("workflow_controller_node", wfExeCtx.getNodeId().getLogicalNodeIdString()).set("workflow_controller_is_local_node", EventLogConstants.trueFalseValueFromBoolean((boolean)controllerLocationIsLocalNode));
        try {
            result = this.getExecutionControllerService((ResolvableNodeId)wfExeCtx.getNodeId()).createExecutionController(wfExeCtx, authTokens, !controllerLocationIsLocalNode);
            eventLogEntry.set("success", "yes");
            EventLog.append((EventLogEntry)eventLogEntry);
        }
        catch (WorkflowExecutionException | RemoteOperationException e) {
            eventLogEntry.set("success", "no");
            EventLog.append((EventLogEntry)eventLogEntry);
            throw e;
        }
        return result;
    }

    private void performStartOnExecutionController(WorkflowExecutionHandle handle) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionControllerService((ResolvableNodeId)handle.getLocation()).performStart(handle.getIdentifier());
    }

    @Override
    public void cancel(WorkflowExecutionHandle handle) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionControllerService((ResolvableNodeId)handle.getLocation()).performCancel(handle.getIdentifier());
    }

    @Override
    public void pause(WorkflowExecutionHandle handle) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionControllerService((ResolvableNodeId)handle.getLocation()).performPause(handle.getIdentifier());
    }

    @Override
    public void resume(WorkflowExecutionHandle handle) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionControllerService((ResolvableNodeId)handle.getLocation()).performResume(handle.getIdentifier());
    }

    @Override
    public void dispose(WorkflowExecutionHandle handle) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionControllerService((ResolvableNodeId)handle.getLocation()).performDispose(handle.getIdentifier());
    }

    @Override
    public void deleteFromDataManagement(WorkflowExecutionHandle handle) throws ExecutionControllerException {
        Long wfDataManagementId;
        try {
            wfDataManagementId = this.getWorkflowDataManagementId(handle);
        }
        catch (ExecutionControllerException | RemoteOperationException e) {
            throw new ExecutionControllerException("Failed to determine the storage id of workflow run " + handle.getIdentifier(), e);
        }
        try {
            this.metaDataService.deleteWorkflowRun(wfDataManagementId, (NetworkDestination)handle.getLocation());
        }
        catch (CommunicationException e) {
            throw new ExecutionControllerException("Could not delete workflow run " + wfDataManagementId, (Throwable)e);
        }
    }

    @Override
    public WorkflowState getWorkflowState(WorkflowExecutionHandle handle) throws ExecutionControllerException, RemoteOperationException {
        return this.getExecutionControllerService((ResolvableNodeId)handle.getLocation()).getWorkflowState(handle.getIdentifier());
    }

    @Override
    public Long getWorkflowDataManagementId(WorkflowExecutionHandle handle) throws ExecutionControllerException, RemoteOperationException {
        return this.getExecutionControllerService((ResolvableNodeId)handle.getLocation()).getWorkflowDataManagementId(handle.getIdentifier());
    }

    @Override
    public Set<WorkflowExecutionInformation> getLocalWorkflowExecutionInformations() {
        try {
            return new HashSet<WorkflowExecutionInformation>(this.wfExeCtrlService.getWorkflowExecutionInformations());
        }
        catch (ExecutionControllerException | RemoteOperationException e) {
            throw new IllegalStateException("Failed to get local workflow execution information; cause: " + e.toString());
        }
    }

    @Override
    public Set<WorkflowExecutionInformation> getWorkflowExecutionInformations() {
        return this.getWorkflowExecutionInformations(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<WorkflowExecutionInformation> getWorkflowExecutionInformations(boolean forceRefresh) {
        if (!forceRefresh && this.workflowExecutionInformations != null) {
            return new HashSet<WorkflowExecutionInformation>(this.workflowExecutionInformations);
        }
        Object object = this.wfExeFetchLock;
        synchronized (object) {
            if (forceRefresh || this.workflowExecutionInformations == null) {
                HashSet<WorkflowExecutionInformation> tempWfExeInfos = new HashSet<WorkflowExecutionInformation>();
                CallablesGroup callablesGroup = ConcurrencyUtils.getFactory().createCallablesGroup(Collection.class);
                Iterator iterator = this.workflowHostService.getWorkflowHostNodesAndSelf().iterator();
                while (iterator.hasNext()) {
                    InstanceNodeSessionId node;
                    final InstanceNodeSessionId finalNode = node = (InstanceNodeSessionId)iterator.next();
                    callablesGroup.add((Callable)new Callable<Collection>(){

                        @Override
                        @TaskDescription(value="Distributed query: getWorkflowInformations()")
                        public Collection<WorkflowExecutionInformation> call() throws Exception {
                            RemotableWorkflowExecutionControllerService executionControllerService = WorkflowExecutionServiceImpl.this.getExecutionControllerService((ResolvableNodeId)finalNode);
                            try {
                                return executionControllerService.getWorkflowExecutionInformations();
                            }
                            catch (RemoteOperationException e) {
                                LOG.error((Object)StringUtils.format((String)"Failed to query remote workflows on node %s; cause: %s", (Object[])new Object[]{finalNode, e.toString()}));
                                return null;
                            }
                        }
                    });
                }
                List results = callablesGroup.executeParallel(new AsyncExceptionListener(){

                    public void onAsyncException(Exception e) {
                        LOG.warn((Object)"Exception during asynchrous execution", (Throwable)e);
                    }
                });
                for (Collection singleResult : results) {
                    if (singleResult == null) continue;
                    tempWfExeInfos.addAll(singleResult);
                }
                this.workflowExecutionInformations = tempWfExeInfos;
            }
            return new HashSet<WorkflowExecutionInformation>(this.workflowExecutionInformations);
        }
    }

    private RemotableWorkflowExecutionControllerService getExecutionControllerService(ResolvableNodeId node) throws RemoteOperationException {
        return (RemotableWorkflowExecutionControllerService)this.communicationService.getRemotableService(RemotableWorkflowExecutionControllerService.class, (NetworkDestination)node);
    }

    @Reference
    protected void bindCommunicationService(CommunicationService newService) {
        this.communicationService = newService;
    }

    @Reference
    protected void bindNotificationService(DistributedNotificationService newService) {
        this.notificationService = newService;
    }

    @Reference
    protected void bindPlatformService(PlatformService newService) {
        this.platformService = newService;
    }

    @Reference
    protected void bindComponentExecutionControllerService(RemotableComponentExecutionControllerService newService) {
        this.componentExecutionControllerService = newService;
    }

    @Reference
    protected void bindPersistentWorkflowDescriptionLoaderService(PersistentWorkflowDescriptionLoaderService newService) {
        this.workflowDescriptionLoaderService = newService;
    }

    @Reference
    protected void bindWorkflowHostService(WorkflowHostService newService) {
        this.workflowHostService = newService;
    }

    @Reference
    protected void bindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService newService) {
        this.componentKnowledgeService = newService;
    }

    @Reference
    protected void bindWorkflowExecutionControllerService(RemotableWorkflowExecutionControllerService newService) {
        this.wfExeCtrlService = newService;
    }

    @Reference
    protected void bindMetaDataService(MetaDataService newService) {
        this.metaDataService = newService;
    }

    @Reference
    protected void bindComponentExecutionAuthorizationService(ComponentExecutionAuthorizationService newService) {
        this.componentExecutionAuthorizationService = newService;
    }

    @Reference
    protected void bindAuthorizationService(AuthorizationService newService) {
        this.authorizationService = newService;
    }

    @Reference
    protected void bindCryptographyOperationsProvider(CryptographyOperationsProvider newService) {
        this.cryptographyOperationsProvider = newService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> acquireExecutionAuthorizationTokensForComponents(WorkflowDescription workflowDescription) throws WorkflowExecutionException {
        final HashMap<String, String> resultMap = new HashMap<String, String>();
        final DistributedComponentKnowledge distrCompKnowledge = this.componentKnowledgeService.getCurrentSnapshot();
        CallablesGroup callablesGroup = ConcurrencyUtils.getFactory().createCallablesGroup(WorkflowExecutionException.class);
        for (final WorkflowNode wfDescriptionNode : workflowDescription.getWorkflowNodes()) {
            if (!wfDescriptionNode.isEnabled()) continue;
            callablesGroup.add((Callable)new Callable<WorkflowExecutionException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @TaskDescription(value="Acquire access token for component")
                public WorkflowExecutionException call() throws Exception {
                    try {
                        String accessToken = WorkflowExecutionServiceImpl.this.acquireOrRegisterExecutionAuthorizationToken(wfDescriptionNode, distrCompKnowledge);
                        Map map = resultMap;
                        synchronized (map) {
                            resultMap.put(wfDescriptionNode.getIdentifierAsObject().toString(), accessToken);
                        }
                        return null;
                    }
                    catch (OperationFailureException | RemoteOperationException e) {
                        String message = "Failed to acquire permission to execute component \"" + wfDescriptionNode.getName() + "\" on " + wfDescriptionNode.getComponentDescription().getNode();
                        LOG.error((Object)(String.valueOf(message) + ": " + e.toString()));
                        return new WorkflowExecutionException(message, (Exception)e);
                    }
                }
            });
        }
        List exceptions = callablesGroup.executeParallel(null);
        for (WorkflowExecutionException e : exceptions) {
            if (e == null) continue;
            throw e;
        }
        HashMap<String, String> hashMap = resultMap;
        synchronized (hashMap) {
            return resultMap;
        }
    }

    private String acquireOrRegisterExecutionAuthorizationToken(WorkflowNode wfDescriptionNode, DistributedComponentKnowledge distrCompKnowledge) throws RemoteOperationException, OperationFailureException {
        String accessToken;
        ComponentDescription componentDescription = wfDescriptionNode.getComponentDescription();
        LogicalNodeId compLocation = componentDescription.getNode();
        String compIdWithoutVersion = componentDescription.getComponentInterface().getIdentifier();
        String compVersion = componentDescription.getComponentInterface().getVersion();
        if (compLocation == null || this.platformService.matchesLocalInstance((ResolvableNodeId)compLocation)) {
            accessToken = this.componentExecutionAuthorizationService.createAndRegisterExecutionTokenForLocalComponent(compIdWithoutVersion);
        } else {
            Optional<DistributedComponentEntry> distrComponentEntryResult = this.resolveComponentIdToDistributedComponentEntry(distrCompKnowledge, compLocation, compIdWithoutVersion);
            if (!distrComponentEntryResult.isPresent()) {
                throw new OperationFailureException("Could not resolve component id " + compIdWithoutVersion + " to an accessible component on instance " + compLocation.getAssociatedDisplayName());
            }
            DistributedComponentEntry distrComponentEntry = distrComponentEntryResult.get();
            AuthorizationPermissionSet matchingPermissionSet = distrComponentEntry.getMatchingPermissionSet();
            LOG.debug((Object)StringUtils.format((String)"Determined [%s] as the list of available authorization group(s) for component '%s' on %s", (Object[])new Object[]{matchingPermissionSet, compIdWithoutVersion, compLocation}));
            RemotableComponentExecutionAuthorizationService remoteService = (RemotableComponentExecutionAuthorizationService)this.communicationService.getRemotableService(RemotableComponentExecutionAuthorizationService.class, (NetworkDestination)compLocation);
            if (matchingPermissionSet.isPublic()) {
                accessToken = remoteService.requestExecutionTokenForPublicComponent(compIdWithoutVersion, compVersion);
            } else if (!matchingPermissionSet.isLocalOnly()) {
                AuthorizationAccessGroup sharedAccessGroup = (AuthorizationAccessGroup)matchingPermissionSet.getAccessGroups().iterator().next();
                String encryptedAccessToken = remoteService.requestEncryptedExecutionTokenViaGroupMembership(compIdWithoutVersion, compVersion, sharedAccessGroup.getFullId());
                AuthorizationAccessGroupKeyData groupKeyData = this.authorizationService.getKeyDataForGroup(sharedAccessGroup);
                accessToken = this.cryptographyOperationsProvider.decodeAndDecryptString(groupKeyData.getSymmetricKey(), encryptedAccessToken);
                if (!accessToken.contains(":group:")) {
                    throw new OperationFailureException("Failed to decrypt the component execution token for component " + componentDescription.getName());
                }
            } else {
                throw new OperationFailureException("Failed to acquire permission to execute component \"" + componentDescription.getName() + "\": There are no shared authorization groups between the local instance " + "and the instance providing the component");
            }
        }
        return accessToken;
    }

    private Optional<DistributedComponentEntry> resolveComponentIdToDistributedComponentEntry(DistributedComponentKnowledge distrCompKnowledge, LogicalNodeId compLocation, String compIdWithoutVersion) {
        for (DistributedComponentEntry componentEntry : distrCompKnowledge.getKnownSharedInstallationsOnNode((ResolvableNodeId)compLocation, false)) {
            if (!componentEntry.getComponentInterface().getIdentifier().equals(compIdWithoutVersion)) continue;
            return Optional.of(componentEntry);
        }
        return Optional.empty();
    }

    private void sendHeartbeatForActiveWorkflows() {
        Set<WorkflowExecutionInformation> wfExeInfoSnapshot = this.getWorkflowExecutionInformation();
        for (WorkflowExecutionInformation wfExeInfo : wfExeInfoSnapshot) {
            String wfExeId = wfExeInfo.getExecutionIdentifier();
            switch (wfExeInfo.getWorkflowState()) {
                case INIT: 
                case STARTING: 
                case PREPARING: 
                case RUNNING: 
                case PAUSING: 
                case PAUSED: 
                case RESUMING: 
                case CANCELING: 
                case CANCELING_AFTER_FAILED: {
                    if (this.verboseLogging) {
                        LOG.debug((Object)StringUtils.format((String)"Sending heartbeat notification for active workflow '%s' (%s)", (Object[])new Object[]{wfExeInfo.getInstanceName(), wfExeId}));
                    }
                    this.notificationService.send("rce.component.workflow.state:" + wfExeId, (Serializable)((Object)WorkflowState.IS_ALIVE.name()));
                    break;
                }
            }
        }
    }

    private Set<WorkflowExecutionInformation> getWorkflowExecutionInformation() {
        HashSet<WorkflowExecutionInformation> wfExeInfoSnapshot = new HashSet<WorkflowExecutionInformation>();
        try {
            wfExeInfoSnapshot.addAll(this.wfExeCtrlService.getWorkflowExecutionInformations());
        }
        catch (ExecutionControllerException | RemoteOperationException e) {
            LOG.error((Object)("Failed to fetch local workflow execution informations: " + e.getMessage()));
        }
        return wfExeInfoSnapshot;
    }
}

