/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.workflow.execution.function;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import de.rcenvironment.core.authorization.AuthorizationException;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.datamanagement.DataManagementService;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.datamodel.types.api.ShortTextTD;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class OutputAdapterComponent
extends DefaultComponent {
    private ComponentContext context;

    public boolean treatStartAsComponentRun() {
        return false;
    }

    public void setComponentContext(ComponentContext componentContext) {
        this.context = componentContext;
    }

    public void processInputs() throws ComponentException {
        String outputDirectoryPath = this.context.getConfigurationValue("outputFolder");
        HashMap<String, Object> outputsMap = new HashMap<String, Object>();
        for (String inputName : this.context.getInputs()) {
            TypedDatum nonreplacedInput = this.context.readInput(inputName);
            DataType inputType = this.context.getInputDataType(inputName);
            String replacedInput = this.copyInputToFilesystemIfFile(nonreplacedInput, inputType);
            outputsMap.put(inputName, replacedInput);
        }
        File outputDirectory = new File(outputDirectoryPath);
        this.writeOutputsMapToDirectory(outputsMap, outputDirectory);
    }

    private String copyInputToFilesystemIfFile(TypedDatum nonreplacedInput, DataType inputType) throws ComponentException {
        Object replacedInput = DataType.FileReference.equals((Object)inputType) ? this.tryCopyFileToLocalFilesystem((FileReferenceTD)nonreplacedInput) : (DataType.DirectoryReference.equals((Object)inputType) ? this.tryCopyDirectoryToLocalFilesystem((DirectoryReferenceTD)nonreplacedInput) : nonreplacedInput);
        TypedDatumSerializer typedDatumSerializer = this.getTypedDatumSerializer();
        return typedDatumSerializer.serialize((TypedDatum)replacedInput);
    }

    private ShortTextTD tryCopyFileToLocalFilesystem(FileReferenceTD nonreplacedDatum) throws ComponentException {
        try {
            File tempFile = this.createTemporaryFile();
            this.getDataManagementService().copyReferenceToLocalFile(nonreplacedDatum.getFileReference(), tempFile, this.context.getStorageNetworkDestination());
            LogFactory.getLog(((Object)((Object)this)).getClass()).info((Object)StringUtils.format((String)"Copied file to '%s'", (Object[])new Object[]{tempFile}));
            TypedDatumFactory typedDatumFactory = this.getTypedDatumFactory();
            return typedDatumFactory.createShortText(tempFile.getAbsolutePath());
        }
        catch (AuthorizationException | CommunicationException | IOException e) {
            throw new ComponentException("Error when copying outer inputs to inner ones", e);
        }
    }

    private ShortTextTD tryCopyDirectoryToLocalFilesystem(DirectoryReferenceTD nonreplacedDatum) throws ComponentException {
        try {
            File tempDir = this.createTemporaryDirectory();
            this.getDataManagementService().copyReferenceToLocalDirectory(nonreplacedDatum.getDirectoryReference(), tempDir, this.context.getStorageNetworkDestination());
            String absolutePathToCopiedDirectory = Paths.get(tempDir.getAbsolutePath(), nonreplacedDatum.getDirectoryName()).toString();
            LogFactory.getLog(((Object)((Object)this)).getClass()).info((Object)StringUtils.format((String)"Copied directory to '%s'", (Object[])new Object[]{tempDir}));
            TypedDatumFactory typedDatumFactory = this.getTypedDatumFactory();
            return typedDatumFactory.createShortText(absolutePathToCopiedDirectory);
        }
        catch (AuthorizationException | CommunicationException | IOException e) {
            throw new ComponentException("Error when copying outer inputs to inner ones", e);
        }
    }

    private DataManagementService getDataManagementService() {
        return (DataManagementService)this.context.getService(DataManagementService.class);
    }

    private TypedDatumFactory getTypedDatumFactory() {
        return ((TypedDatumService)this.context.getService(TypedDatumService.class)).getFactory();
    }

    private TypedDatumSerializer getTypedDatumSerializer() {
        return ((TypedDatumService)this.context.getService(TypedDatumService.class)).getSerializer();
    }

    protected File createTemporaryFile() throws IOException {
        return TempFileServiceAccess.getInstance().createTempFileFromPattern("*");
    }

    protected File createTemporaryDirectory() throws IOException {
        return TempFileServiceAccess.getInstance().createManagedTempDir();
    }

    protected void writeOutputsMapToDirectory(Map<String, Object> outputsMap, File outputDirectory) throws ComponentException {
        File outputsFile = new File(outputDirectory, "outputs.json");
        LogFactory.getLog(((Object)((Object)this)).getClass()).info((Object)StringUtils.format((String)"Writing to directory %s", (Object[])new Object[]{outputDirectory}));
        ObjectWriter writer = new ObjectMapper().writer();
        try {
            writer.writeValue(outputsFile, outputsMap);
        }
        catch (IOException e) {
            throw new ComponentException("Could not write outputs file", (Throwable)e);
        }
    }
}

