/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.command.spi;

import de.rcenvironment.core.command.spi.AbstractParsedCommandParameter;
import de.rcenvironment.core.command.spi.CommandFlag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ParsedCommandModifiers {
    private List<AbstractParsedCommandParameter> positionalParameters;
    private Set<CommandFlag> activeFlags;
    private Map<String, AbstractParsedCommandParameter> activeNamedParameters;

    public ParsedCommandModifiers() {
        this.positionalParameters = new ArrayList<AbstractParsedCommandParameter>();
        this.activeFlags = new HashSet<CommandFlag>();
        this.activeNamedParameters = new HashMap<String, AbstractParsedCommandParameter>();
    }

    public ParsedCommandModifiers(List<AbstractParsedCommandParameter> positionalParameters, Set<CommandFlag> activeFlags, Map<String, AbstractParsedCommandParameter> activeNamedParameters) {
        this.positionalParameters = positionalParameters;
        this.activeFlags = activeFlags;
        this.activeNamedParameters = activeNamedParameters;
    }

    public ParsedCommandModifiers(AbstractParsedCommandParameter[] positionalParameters, CommandFlag[] activeFlags, Map<String, AbstractParsedCommandParameter> activeNamedParameters) {
        this.positionalParameters = Arrays.asList(positionalParameters);
        this.activeFlags = new HashSet<CommandFlag>(Arrays.asList(activeFlags));
        this.activeNamedParameters = activeNamedParameters;
    }

    public boolean isEmpty() {
        return this.positionalParameters.isEmpty() && this.activeFlags.isEmpty() && this.activeNamedParameters.isEmpty();
    }

    public AbstractParsedCommandParameter getPositionalCommandParameter(int index) {
        if (this.positionalParameters.size() > index) {
            return this.positionalParameters.get(index);
        }
        return null;
    }

    public boolean hasCommandFlag(String flag) {
        Optional<CommandFlag> foundFlag = this.activeFlags.stream().filter(f -> f.isFitting(flag)).findFirst();
        return foundFlag.isPresent();
    }

    public Set<CommandFlag> getActiveFlags() {
        return this.activeFlags;
    }

    public boolean hasParsedParameter(String parameter) {
        return this.activeNamedParameters.get(parameter) != null;
    }

    public AbstractParsedCommandParameter getCommandParameter(String parameter) {
        if (this.activeNamedParameters.containsKey(parameter)) {
            return this.activeNamedParameters.get(parameter);
        }
        return null;
    }

    public Set<String> getNamedParameterList() {
        return this.activeNamedParameters.keySet();
    }
}

