/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.command.internal.handlers;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.ParsedCommandModifiers;
import de.rcenvironment.core.command.spi.ParsedStringParameter;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class EquinoxConsoleCommandInvoker {
    private static final String OSGI_COMMAND_FUNCTION = "osgi.command.function";
    private static final String OSGI_COMMAND_SCOPE = "osgi.command.scope";
    private final Log log = LogFactory.getLog(this.getClass());
    private CommandContext context;

    public void execute(CommandContext pContext) throws CommandException {
        this.execute(pContext, pContext.getOutputReceiver());
    }

    public void execute(CommandContext pContext, TextOutputReceiver outputReceiver) throws CommandException {
        boolean matched;
        this.context = pContext;
        ParsedCommandModifiers modifiers = pContext.getParsedModifiers();
        ParsedStringParameter osgiCommandParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(0);
        String osgiCommand = osgiCommandParameter.getResult().split(" ")[0];
        if (osgiCommand == null || osgiCommand.isEmpty()) {
            throw CommandException.syntaxError("Missing OSGi command", this.context);
        }
        try {
            matched = this.equinoxCommandProviderImplementsRequestedCommand(osgiCommand);
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        if (!matched) {
            outputReceiver.addOutput("No matching OSGi command found. (Note that built-in commands like \"info\" or \"help\" may not be accessible.)");
            return;
        }
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference sref = bundleContext.getServiceReference("org.apache.felix.service.command.CommandProcessor");
        CommandProcessor commandProcessorService = (CommandProcessor)bundleContext.getService(sref);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        CommandSession session = commandProcessorService.createSession(IOUtils.toInputStream((String)""), (OutputStream)ps, (OutputStream)ps);
        try {
            List<String> tokens = Arrays.asList(osgiCommandParameter.getResult().split(" "));
            tokens.remove(0);
            String completeOsgiCommand = String.valueOf(osgiCommand) + " " + StringUtils.join(tokens, (char)' ');
            session.execute((CharSequence)completeOsgiCommand);
        }
        catch (Exception exception) {
            outputReceiver.addOutput("An error occured during the execution of the OSGi command.");
        }
        session.close();
        outputReceiver.addOutput(baos.toString());
    }

    private boolean equinoxCommandProviderImplementsRequestedCommand(String osgiCommand) {
        ServiceReference[] refs;
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        try {
            String filter = String.format("(&(%s=*)(%s=*))", OSGI_COMMAND_SCOPE, OSGI_COMMAND_FUNCTION);
            refs = bundleContext.getAllServiceReferences("org.eclipse.equinox.console.commands.EquinoxCommandProvider", filter);
        }
        catch (InvalidSyntaxException e) {
            this.log.error((Object)"Error getting service references", (Throwable)e);
            this.context.println("Internal error");
            throw new IllegalStateException();
        }
        boolean matched = false;
        ServiceReference[] serviceReferenceArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference ref = serviceReferenceArray[n2];
            Object functions = ref.getProperty(OSGI_COMMAND_FUNCTION);
            if (!functions.getClass().isArray()) {
                this.context.println("Error: Functions is not an array!");
                throw new IllegalStateException();
            }
            String[] functionsArray = (String[])functions;
            matched = Arrays.asList(functionsArray).contains(osgiCommand);
            if (matched) break;
            ++n2;
        }
        return matched;
    }
}

