/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.gui;

import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WarningErrorLabel
extends Composite {
    private static final int COMPOSITE_MIN_HEIGHT = 45;
    private static final int LABEL_WIDTH_HINT = 80;
    private Text upperText;
    private Text lowerText;
    private CLabel upperLabel;
    private CLabel lowerLabel;
    private final List<String> errors = new LinkedList<String>();
    private final List<String> warnings = new LinkedList<String>();
    private GridData labelGridData;
    private GridData textGridData;

    public WarningErrorLabel(Composite parent, int style) {
        super(parent, style);
        this.setVisible(true);
        GridLayout gd = new GridLayout(2, false);
        gd.marginWidth = 0;
        GridData thisGridData = new GridData(1808);
        this.setLayout((Layout)gd);
        this.setLayoutData(thisGridData);
        this.labelGridData = new GridData(1040);
        this.labelGridData.verticalAlignment = 128;
        this.labelGridData.horizontalAlignment = 131072;
        this.labelGridData.widthHint = 80;
        this.labelGridData.grabExcessVerticalSpace = true;
        this.textGridData = new GridData(1808);
        this.textGridData.minimumHeight = 45;
        this.textGridData.verticalIndent = 4;
        this.upperLabel = new CLabel((Composite)this, 131200);
        this.upperLabel.setLayoutData((Object)this.labelGridData);
        this.upperText = new Text((Composite)this, 520);
        this.upperText.setLayoutData((Object)this.textGridData);
        this.lowerLabel = new CLabel((Composite)this, 131200);
        this.lowerLabel.setLayoutData((Object)this.labelGridData);
        this.lowerText = new Text((Composite)this, 520);
        this.lowerText.setLayoutData((Object)this.textGridData);
    }

    public void addWarning(String warning) {
        this.warnings.add(warning);
        this.refresh();
    }

    public void addWarnings(Collection<String> warningsParam) {
        this.warnings.addAll(warningsParam);
        this.refresh();
    }

    public void clearWarnings() {
        this.warnings.clear();
        this.refresh();
    }

    public void addError(String error) {
        this.errors.add(error);
        this.refresh();
    }

    public void addErrors(Collection<String> errorsParam) {
        this.errors.addAll(errorsParam);
        this.refresh();
    }

    public void clearErrors() {
        this.errors.clear();
        this.refresh();
    }

    private void refresh() {
        this.upperText.dispose();
        this.lowerText.dispose();
        this.upperLabel.dispose();
        this.lowerLabel.dispose();
        if (!this.errors.isEmpty()) {
            this.upperLabel = new CLabel((Composite)this, 131200);
            this.upperLabel.setLayoutData((Object)this.labelGridData);
            this.upperLabel.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.ERROR_16));
            this.upperLabel.setText("Errors:");
            this.upperText = new Text((Composite)this, 520);
            this.upperText.setLayoutData((Object)this.textGridData);
            this.upperText.setText(String.join((CharSequence)"\n", this.errors));
        }
        if (!this.warnings.isEmpty()) {
            this.lowerLabel = new CLabel((Composite)this, 131200);
            this.lowerLabel.setLayoutData((Object)this.labelGridData);
            this.lowerLabel.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.WARNING_16));
            this.lowerLabel.setText("Warnings:");
            this.lowerText = new Text((Composite)this, 520);
            this.lowerText.setLayoutData((Object)this.textGridData);
            this.lowerText.setText(String.join((CharSequence)"\n", this.warnings));
        }
        this.layout();
    }
}

