/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.tt.CMAP;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.conversion.FontTableWriter;
import org.jpedal.fonts.tt.conversion.TTFontWriter;
import org.jpedal.utils.Sorts;

public class CMAPWriter
extends CMAP
implements FontTableWriter {
    int minCharCode = 65536;
    int maxCharCode = 0;

    public CMAPWriter(FontFile2 fontFile2, int n, Glyf glyf) {
        super(fontFile2, n, glyf);
    }

    private int createFormat4Map(PdfJavaGlyphs pdfJavaGlyphs) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        int n6;
        int[] nArray = new int[65536];
        for (n6 = 0; n6 < nArray.length; ++n6) {
            nArray[n6] = Integer.MAX_VALUE;
        }
        for (n6 = 0; n6 < pdfJavaGlyphs.getGlyphCount() + 1; ++n6) {
            object = pdfJavaGlyphs.getIndexForCharString(n6);
            if (object == null || (n5 = StandardFonts.getIDForGlyphName((String)object)) < 0 || n5 >= nArray.length) continue;
            nArray[n5] = n6;
        }
        int[] nArray2 = new int[40000];
        object = new int[40000];
        n5 = 0;
        boolean bl = false;
        for (n4 = 0; n4 < 65536; ++n4) {
            if (bl && nArray[n4] == Integer.MAX_VALUE) {
                bl = false;
                object[n5] = n4 - 1;
                ++n5;
                continue;
            }
            if (bl || nArray[n4] == Integer.MAX_VALUE) continue;
            bl = true;
            nArray2[n5] = n4;
        }
        if (nArray[65533] == Integer.MAX_VALUE) {
            nArray2[n5] = 65533;
            object[n5] = 65533;
            nArray[65533] = 1;
            ++n5;
        }
        if (nArray[65535] == Integer.MAX_VALUE) {
            nArray2[n5] = 65535;
            object[n5] = 65535;
            nArray[65535] = 1;
            ++n5;
        }
        n4 = n5 * 2;
        this.CMAPsegCount = new int[]{n4, 0, n4};
        int n7 = 1;
        while (n7 * 2 <= n5) {
            n7 *= 2;
        }
        this.CMAPsearchRange = new int[]{n7 *= 2, 0, n7};
        int n8 = 0;
        int n9 = n7 / 2;
        while (n9 > 1) {
            n9 /= 2;
            ++n8;
        }
        this.CMAPentrySelector = new int[]{n8, 0, n8};
        int n10 = n4 - n7;
        this.CMAPrangeShift = new int[]{n10, 0, n10};
        this.endCode = (int[])object;
        this.CMAPreserved = new int[]{0, 0, 0};
        this.startCode = nArray2;
        this.idRangeOffset = new int[n5];
        int n11 = 0;
        block5: for (n3 = 0; n3 < n5; ++n3) {
            n2 = nArray[nArray2[n3]] - nArray2[n3];
            for (n = nArray2[n3] + 1; n <= object[n3]; ++n) {
                if (nArray[n] - n == n2) continue;
                this.idRangeOffset[n3] = -1;
                n11 += object[n3] + true - nArray2[n3];
                continue block5;
            }
        }
        this.glyphIdArray = new int[n11];
        this.idDelta = new int[n5];
        n3 = 16 + n5 * 8;
        n2 = 0;
        for (n = 0; n < this.idRangeOffset.length; ++n) {
            if (this.idRangeOffset[n] == 0) {
                this.idDelta[n] = nArray[nArray2[n]] - nArray2[n] - 1;
                continue;
            }
            this.idRangeOffset[n] = n3 - (16 + n5 * 6 + n * 2);
            for (int i = nArray2[n]; i <= object[n]; ++i) {
                this.glyphIdArray[n2] = nArray[i] - 1;
                n3 += 2;
                ++n2;
            }
        }
        return 16 + n5 * 8 + n11 * 2;
    }

    public CMAPWriter(PdfFont pdfFont, PdfJavaGlyphs pdfJavaGlyphs) {
        int n = this.createFormat4Map(pdfJavaGlyphs);
        this.CMAPformats = new int[]{4, 0, 4};
        this.CMAPlength = new int[]{n, 262, n};
        this.CMAPlang = new int[]{0, 0, 0};
        this.platformID = new int[]{0, 1, 3};
        this.numberSubtables = 3;
        this.CMAPsubtables = new int[]{28, 28 + n * 2, 28 + n};
        this.platformSpecificID = new int[]{3, 0, 1};
        this.glyphIndexToChar = new int[3][262];
        int n2 = 0;
        StandardFonts.checkLoaded(n2);
        for (int i = 0; i < pdfJavaGlyphs.getGlyphCount() + 1; ++i) {
            String string = pdfJavaGlyphs.getIndexForCharString(i);
            if (string == null) continue;
            int n3 = StandardFonts.lookupCharacterIndex(string, 0);
            int n4 = i - 1;
            if (i == 1) {
                n4 = 1;
            }
            if (n3 < 0 || n3 >= 256) continue;
            this.glyphIndexToChar[1][n3] = n4;
        }
    }

    public byte[] writeTable() throws IOException {
        int n;
        int n2;
        int n3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n4 = this.numberSubtables;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n3 = 0; n3 < n4; ++n3) {
            arrayList.add(new Integer(n3));
        }
        byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.id));
        byteArrayOutputStream.write(TTFontWriter.setNextUint16(n4));
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = (Integer)arrayList.get(n3);
            int n6 = n2 = n5 < 0 ? 1 : 0;
            if (n5 < 0) {
                n5 = -n5;
            }
            if (n2 != 0) {
                byteArrayOutputStream.write(TTFontWriter.setNextUint16(0));
                byteArrayOutputStream.write(TTFontWriter.setNextUint16(3));
            } else {
                byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.platformID[n5]));
                byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.platformSpecificID[n5]));
            }
            byteArrayOutputStream.write(TTFontWriter.setNextUint32(this.CMAPsubtables[n5]));
        }
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            n = (Integer)arrayList.get(n2);
            if (n < 0) {
                n = -n;
            }
            nArray[n] = this.CMAPsubtables[n];
            nArray2[n2] = n;
        }
        nArray2 = Sorts.quicksort(nArray, nArray2);
        for (n2 = 0; n2 < n4; ++n2) {
            int n7;
            int n8;
            n = nArray2[n2];
            while (byteArrayOutputStream.size() < this.CMAPsubtables[n]) {
                byteArrayOutputStream.write(0);
            }
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.CMAPformats[n]));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.CMAPlength[n]));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.CMAPlang[n]));
            if (this.CMAPformats[n] == 0 && this.CMAPlength[n] == 262) {
                for (n8 = 0; n8 < 256; ++n8) {
                    byteArrayOutputStream.write(TTFontWriter.setNextUint8(this.glyphIndexToChar[n][n8]));
                }
                continue;
            }
            if (this.CMAPformats[n] != 4) continue;
            n8 = this.CMAPsegCount[n] / 2;
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.CMAPsegCount[n]));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.CMAPsearchRange[n]));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.CMAPentrySelector[n]));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.CMAPrangeShift[n]));
            for (n7 = 0; n7 < n8; ++n7) {
                byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.endCode[n7]));
            }
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.CMAPreserved[n]));
            for (n7 = 0; n7 < n8; ++n7) {
                byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.startCode[n7]));
            }
            for (n7 = 0; n7 < n8; ++n7) {
                byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.idDelta[n7]));
            }
            for (n7 = 0; n7 < n8; ++n7) {
                byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.idRangeOffset[n7]));
            }
            for (n7 = 0; n7 < this.glyphIdArray.length; ++n7) {
                byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.glyphIdArray[n7]));
            }
        }
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public int getIntValue(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = this.minCharCode;
                break;
            }
            case 1: {
                n2 = this.maxCharCode;
            }
        }
        return n2;
    }

    public int getMaxCharCode() {
        return this.maxCharCode;
    }
}

