/*
 * Decompiled with CFR 0.152.
 */
package de.vonloesch.pdf4eclipse.outline;

import de.vonloesch.pdf4eclipse.editors.PDFEditor;
import de.vonloesch.pdf4eclipse.model.IOutlineNode;
import de.vonloesch.pdf4eclipse.model.IPDFDestination;
import de.vonloesch.pdf4eclipse.outline.PDFFileContentProvider;
import de.vonloesch.pdf4eclipse.outline.PDFFileLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class PDFFileOutline
extends ContentOutlinePage {
    private IOutlineNode input;
    private PDFEditor editor;

    public PDFFileOutline(PDFEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new PDFFileContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new PDFFileLabelProvider());
        if (this.input != null) {
            viewer.setInput((Object)this.input);
        }
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                for (IOutlineNode domain : selection) {
                    IPDFDestination dest = domain.getDestination();
                    if (dest == null) continue;
                    PDFFileOutline.this.editor.gotoAction(dest);
                    return;
                }
            }
        });
    }

    public void setInput(IOutlineNode n) {
        this.input = n;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null) {
            viewer.setInput((Object)this.input);
        }
    }
}

