/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.utils.common;

public final class ConsistencyChecks {
    private ConsistencyChecks() {
    }

    public static void assertTrue(boolean value) {
        if (!value) {
            ConsistencyChecks.reportFailure("Expected expression to be true");
        }
    }

    public static void assertTrue(boolean value, String message) {
        if (!value) {
            ConsistencyChecks.reportFailure(message);
        }
    }

    public static void assertFalse(boolean value) {
        if (value) {
            ConsistencyChecks.reportFailure("Expected expression to be false");
        }
    }

    public static void assertFalse(boolean value, String message) {
        if (value) {
            ConsistencyChecks.reportFailure(message);
        }
    }

    public static void assertNotNull(Object value) {
        if (value == null) {
            ConsistencyChecks.reportFailure("Unexpected null reference");
        }
    }

    public static void assertNotNull(Object value, String message) {
        if (value == null) {
            ConsistencyChecks.reportFailure(message);
        }
    }

    public static void reportFailure(String detailMessage) {
        throw new AssertionError((Object)("Internal consistency error: " + detailMessage));
    }
}

