/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.modules.concurrency.internal;

import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedExecutionQueue;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.internal.ConcurrencyUtilsServiceHolder;
import de.rcenvironment.toolkit.modules.statistics.api.CounterCategory;
import de.rcenvironment.toolkit.modules.statistics.api.StatisticsFilterLevel;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncOrderedExecutionQueueImpl
implements AsyncOrderedExecutionQueue {
    private static final String ASYNC_TASK_DESCRIPTION = "AsyncOrderedExecutionQueue dispatch";
    private static final int MAXIMUM_QUEUE_CANCEL_WAIT_SECONDS = 30;
    private final CountDownLatch cancelCompleteLatch = new CountDownLatch(1);
    private final AsyncCallbackExceptionPolicy exceptionPolicy;
    private final AsyncTaskService threadPool;
    private final Deque<Runnable> queue;
    private final Runnable dispatchRunnable;
    private final CounterCategory elementCounter;
    private final Log log = LogFactory.getLog(this.getClass());

    public AsyncOrderedExecutionQueueImpl(AsyncCallbackExceptionPolicy exceptionPolicy, ConcurrencyUtilsServiceHolder internalServiceHolder) {
        this.exceptionPolicy = exceptionPolicy;
        this.threadPool = internalServiceHolder.getAsyncTaskService();
        this.queue = new LinkedList<Runnable>();
        this.dispatchRunnable = new DispatchRunnable();
        this.elementCounter = internalServiceHolder.getStatisticsTrackerService().getCounterCategory("AsyncOrderedExecutionQueue elements dispatched", StatisticsFilterLevel.DEVELOPMENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(Runnable task) {
        boolean isFirst;
        Deque<Runnable> deque = this.queue;
        synchronized (deque) {
            this.queue.addLast(task);
            isFirst = this.queue.size() == 1;
        }
        if (isFirst) {
            this.threadPool.execute(ASYNC_TASK_DESCRIPTION, this.dispatchRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAsync() {
        Deque<Runnable> deque = this.queue;
        synchronized (deque) {
            if (this.queue.isEmpty()) {
                this.cancelCompleteLatch.countDown();
            }
            this.queue.clear();
            this.queue.add(null);
        }
    }

    @Override
    public void cancelAndWaitForLastRunningTask() throws TimeoutException {
        this.cancelAsync();
        try {
            if (!this.cancelCompleteLatch.await(30L, TimeUnit.SECONDS)) {
                throw new TimeoutException("Maximum wait time for queue shutdown exceeded");
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.warn((Object)("Thread interrupted while waiting for queue shutdown; queue id: " + this.getLogId()));
        }
    }

    @Override
    @Deprecated
    public void cancel(boolean waitForShutdown) throws TimeoutException {
        if (waitForShutdown) {
            this.cancelAndWaitForLastRunningTask();
        } else {
            this.cancelAsync();
        }
    }

    private int getLogId() {
        return System.identityHashCode(this);
    }

    private final class DispatchRunnable
    implements Runnable {
        private DispatchRunnable() {
        }

        @Override
        public void run() {
            while (this.dispatchSingleElement()) {
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean dispatchSingleElement() {
            Runnable preExecutionFirst;
            Deque<Runnable> deque = AsyncOrderedExecutionQueueImpl.this.queue;
            synchronized (deque) {
                preExecutionFirst = AsyncOrderedExecutionQueueImpl.this.queue.peekFirst();
            }
            if (preExecutionFirst == null) {
                AsyncOrderedExecutionQueueImpl.this.log.debug((Object)("Queue cancelled, discarding queued trigger; queue id: " + AsyncOrderedExecutionQueueImpl.this.getLogId()));
                AsyncOrderedExecutionQueueImpl.this.cancelCompleteLatch.countDown();
                return false;
            }
            try {
                if (AsyncOrderedExecutionQueueImpl.this.elementCounter.isEnabled()) {
                    AsyncOrderedExecutionQueueImpl.this.elementCounter.countClass(preExecutionFirst);
                }
                preExecutionFirst.run();
            }
            catch (RuntimeException e) {
                switch (AsyncOrderedExecutionQueueImpl.this.exceptionPolicy) {
                    case LOG_AND_CANCEL_LISTENER: {
                        AsyncOrderedExecutionQueueImpl.this.log.error((Object)("Error in asynchronous callback; shutting down queue (as defined by exception policy); queue id: " + AsyncOrderedExecutionQueueImpl.this.getLogId()), (Throwable)e);
                        AsyncOrderedExecutionQueueImpl.this.cancelAsync();
                        return false;
                    }
                    case LOG_AND_PROCEED: {
                        AsyncOrderedExecutionQueueImpl.this.log.error((Object)("Error in asynchronous callback; continuing (as defined by exception policy); queue id: " + AsyncOrderedExecutionQueueImpl.this.getLogId()), (Throwable)e);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            deque = AsyncOrderedExecutionQueueImpl.this.queue;
            synchronized (deque) {
                Runnable postExecutionFirst;
                block16: {
                    postExecutionFirst = AsyncOrderedExecutionQueueImpl.this.queue.peekFirst();
                    if (postExecutionFirst != null) break block16;
                    AsyncOrderedExecutionQueueImpl.this.log.debug((Object)("Queue cancelled during a task's execution; stopping dispatcher and waiting for the running task to complete; queue id: " + AsyncOrderedExecutionQueueImpl.this.getLogId()));
                    AsyncOrderedExecutionQueueImpl.this.cancelCompleteLatch.countDown();
                    return false;
                }
                postExecutionFirst = AsyncOrderedExecutionQueueImpl.this.queue.removeFirst();
                if (preExecutionFirst != postExecutionFirst) {
                    throw new IllegalStateException("Queue corruption (queue id: " + AsyncOrderedExecutionQueueImpl.this.getLogId() + ")");
                }
                return !AsyncOrderedExecutionQueueImpl.this.queue.isEmpty();
            }
        }
    }
}

