/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.core.internal;

import de.rcenvironment.toolkit.core.api.ImmutableServiceRegistry;
import de.rcenvironment.toolkit.core.api.ToolkitException;
import de.rcenvironment.toolkit.core.spi.module.ClassFilter;
import de.rcenvironment.toolkit.core.spi.module.DefaultClassFilter;
import de.rcenvironment.toolkit.core.spi.module.ObjectGraph;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractObjectGraph
implements ObjectGraph {
    private ClassFilter publicInterfaceFilter = new DefaultClassFilter();
    private final Collection<Class<?>> interfacesToPublish = new ArrayList();
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public final void registerObject(Object object) {
        this.registerObject(object, this.getRelevantInterfaces(object.getClass()));
    }

    @Override
    public final void registerServiceClass(Class<?> implementationClass) {
        Collection<Class<?>> privateCandidates = this.getRelevantInterfaces(implementationClass);
        Collection<Class<?>> publicInterfaces = this.selectPublicInterfaces(privateCandidates);
        this.registerServiceClass(implementationClass, publicInterfaces, privateCandidates);
        this.interfacesToPublish.addAll(publicInterfaces);
    }

    @Override
    public void setPublicInterfaceFilter(ClassFilter filter) {
        this.publicInterfaceFilter = filter;
    }

    @Override
    public final ImmutableServiceRegistry instantiate() throws ToolkitException {
        return this.instantiateServices(this.interfacesToPublish);
    }

    protected abstract void registerObject(Object var1, Collection<Class<?>> var2);

    protected abstract void registerServiceClass(Object var1, Collection<Class<?>> var2, Collection<Class<?>> var3);

    protected abstract ImmutableServiceRegistry instantiateServices(Collection<Class<?>> var1) throws ToolkitException;

    protected final void logDebug(String text) {
        this.log.debug((Object)text);
    }

    private Collection<Class<?>> getRelevantInterfaces(Class<? extends Object> clazz) {
        ArrayList result = new ArrayList();
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> i = classArray[n2];
            if (!i.getName().startsWith("java")) {
                result.add(i);
            }
            ++n2;
        }
        return result;
    }

    private Collection<Class<?>> selectPublicInterfaces(Collection<Class<?>> privateCandidates) {
        ArrayList result = new ArrayList();
        for (Class<?> i : privateCandidates) {
            if (!this.publicInterfaceFilter.accept(i)) continue;
            result.add(i);
        }
        return result;
    }
}

