/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.internal;

import de.rcenvironment.core.configuration.bootstrap.BootstrapConfiguration;
import de.rcenvironment.core.utils.common.OSFamily;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.extras.testscriptrunner.definitions.common.TestScenarioExecutionContext;
import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.feature.FeatureWithLines;
import io.cucumber.core.feature.GluePath;
import io.cucumber.core.filter.Filters;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.options.RuntimeOptionsBuilder;
import io.cucumber.core.order.PickleOrder;
import io.cucumber.core.order.StandardPickleOrders;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.plugin.PluginFactory;
import io.cucumber.core.plugin.Plugins;
import io.cucumber.core.runtime.BackendServiceLoader;
import io.cucumber.core.runtime.BackendSupplier;
import io.cucumber.core.runtime.CucumberExecutionContext;
import io.cucumber.core.runtime.ExitStatus;
import io.cucumber.core.runtime.FeaturePathFeatureSupplier;
import io.cucumber.core.runtime.ObjectFactoryServiceLoader;
import io.cucumber.core.runtime.ObjectFactorySupplier;
import io.cucumber.core.runtime.RunnerSupplier;
import io.cucumber.core.runtime.SingletonObjectFactorySupplier;
import io.cucumber.core.runtime.SingletonRunnerSupplier;
import io.cucumber.core.runtime.SynchronizedEventBus;
import io.cucumber.core.runtime.TimeServiceEventBus;
import io.cucumber.core.snippets.SnippetType;
import io.cucumber.picocontainer.PicoFactory;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class CucumberTestFrameworkAdapter {
    private final Log log = LogFactory.getLog(this.getClass());
    private final List<URL> classFileUrlsForRedirectingGlueCodeSearch = new ArrayList<URL>();

    public CucumberTestFrameworkAdapter() {
        Bundle containingBundle = FrameworkUtil.getBundle(this.getClass());
        if (containingBundle != null) {
            String locationInfo = containingBundle.getLocation();
            this.log.debug((Object)("Original OSGi bundle location value: " + locationInfo));
            if (locationInfo.startsWith("initial@")) {
                locationInfo = locationInfo.substring("initial@".length());
            }
            if (!locationInfo.startsWith("reference:file:")) {
                throw new RuntimeException("Unexpected bundle location format (expected a 'reference:file:' prefix): " + locationInfo);
            }
            if (locationInfo.endsWith("/")) {
                String rewrittenUrlString = String.valueOf(locationInfo.replace("reference:", "")) + "target/classes/de/rcenvironment/extras/testscriptrunner";
                this.log.debug((Object)("Apparently running from an IDE; using rewritten class files location " + rewrittenUrlString));
                try {
                    this.classFileUrlsForRedirectingGlueCodeSearch.add(new URL(rewrittenUrlString));
                    this.classFileUrlsForRedirectingGlueCodeSearch.add(new URL(rewrittenUrlString.replace("testscriptrunner/", "testscriptrunner.tests/")));
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException("Failed to recreate URL from string " + rewrittenUrlString);
                }
            } else if (locationInfo.endsWith(".jar")) {
                String relativePathPart = locationInfo.replace("reference:file:", "");
                File installationDir = BootstrapConfiguration.getInstallationDir();
                File absolutePath = new File(installationDir, relativePathPart);
                if (!absolutePath.isFile()) {
                    throw new RuntimeException("Derived the absolute bundle path " + absolutePath + ", but it does not point at a JAR file");
                }
                URI jarFileUri = absolutePath.toURI();
                String assembledJarUrlStringWithInternalPath = "jar:" + jarFileUri.toString() + "!/de/rcenvironment/extras/testscriptrunner";
                this.log.debug((Object)("Apparently running from a standalone build, rewriting class file search URL to " + assembledJarUrlStringWithInternalPath));
                try {
                    this.classFileUrlsForRedirectingGlueCodeSearch.add(new URL(assembledJarUrlStringWithInternalPath));
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException("Failed to recreate URL from URI " + assembledJarUrlStringWithInternalPath);
                }
            } else {
                throw new RuntimeException("Unrecognized bundle location format: " + locationInfo);
            }
        }
    }

    public ExecutionResult executeTestScripts(File scriptLocationRoot, String tagNameSelection, TextOutputReceiver outputReceiver, String buildUnderTestId, File reportDir) throws IOException {
        return this.executeTestScripts(scriptLocationRoot, tagNameSelection, outputReceiver, buildUnderTestId, reportDir, ReportOutputFormat.PRETTY);
    }

    public ExecutionResult executeTestScripts(File scriptLocationRoot, String tagNameFilter, TextOutputReceiver outputReceiver, String buildUnderTestId, File reportDir, ReportOutputFormat reportFormat) throws IOException {
        String reportDirUriString = reportDir.toURI().toASCIIString();
        String reportFileName = "plain" + reportFormat.getReportFileSuffix();
        File reportFile = new File(reportDir, reportFileName);
        if (reportFile.isFile()) {
            reportFile.delete();
        }
        if (reportFile.isFile()) {
            throw new IOException("Failed to delete pre-existing report file " + reportFile.getAbsolutePath());
        }
        ExecutionContext executionContext = new ExecutionContext(reportFormat, reportDirUriString, reportFileName, tagNameFilter, scriptLocationRoot, outputReceiver);
        PrintStream oldStdOut = System.out;
        ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream();
        PrintStream outputWriter = new PrintStream((OutputStream)outputBuffer, false, "UTF-8");
        System.setOut(outputWriter);
        TestScenarioExecutionContext.setThreadLocalParameters(outputReceiver, buildUnderTestId, scriptLocationRoot);
        try {
            executionContext.runFeatureFiles();
        }
        finally {
            TestScenarioExecutionContext.discardThreadLocalParameters();
        }
        System.setOut(oldStdOut);
        outputWriter.close();
        if (reportFile.isFile()) {
            List reportLines = FileUtils.readLines((File)reportFile, (Charset)Charsets.UTF_8);
            List capturedStdOutLines = IOUtils.readLines((InputStream)new ByteArrayInputStream(outputBuffer.toByteArray()), (Charset)Charsets.UTF_8);
            ExecutionResultStatus executionResultStatus = executionContext.getExecutionResultStatus();
            return new ExecutionResult(reportLines, capturedStdOutLines, executionResultStatus);
        }
        return null;
    }

    private final class ExecutionContext {
        private final EventHandler<TestStepFinished> cucumberTestStepFinishedHandler = this::cucumberTestStepFinished;
        private final EventHandler<TestCaseFinished> cucumberTestCaseFinishedHandler = this::cucumberTestCaseResult;
        private final EventHandler<TestRunFinished> cucumberTestRunFinishedHandler = this::cucumberTestRunFinished;
        private Map<String, String> unsuccessfulScenarios = new HashMap<String, String>();
        private final ReportOutputFormat reportFormat;
        private final String reportDirUriString;
        private final String reportFileName;
        private final String tagNameFilter;
        private final File scriptLocationRoot;
        private final Supplier<ClassLoader> classloaderSupplier;
        private Filters tagFilters;
        private PickleOrder pickleOrder;
        private CucumberExecutionContext cucumberExecutionContext;
        private List<Feature> features;
        private ExecutorService executor;
        private TextOutputReceiver outputReceiver;
        private TestStatistics scenarioStatistics;
        private TestStatistics stepStatistics;
        private ExecutionResultStatus executionResultStatus;

        private ExecutionContext(ReportOutputFormat reportFormat, String reportDirUriString, String reportFileName, String tagNameFilter, File scriptLocationRoot, TextOutputReceiver outputReceiver) {
            this.scenarioStatistics = new TestStatistics();
            this.stepStatistics = new TestStatistics();
            this.reportFormat = reportFormat;
            this.reportDirUriString = reportDirUriString;
            this.reportFileName = reportFileName;
            this.tagNameFilter = tagNameFilter;
            this.scriptLocationRoot = scriptLocationRoot;
            this.outputReceiver = outputReceiver;
            ClassLoader upstreamClassLoader = this.getClass().getClassLoader();
            ClassLoaderWrapper classLoader = new ClassLoaderWrapper(upstreamClassLoader);
            this.classloaderSupplier = () -> classLoader;
            this.initializeCucumberRuntime();
        }

        private void initializeCucumberRuntime() {
            SynchronizedEventBus eventBus = SynchronizedEventBus.synchronize((EventBus)new TimeServiceEventBus(Clock.systemUTC(), UUID::randomUUID));
            String subdirForBDDReportFiles = "rce-bdd-reports";
            if (OSFamily.isLinux()) {
                subdirForBDDReportFiles = String.valueOf(subdirForBDDReportFiles) + "-" + System.getProperty("user.name");
            }
            File reportFolder = new File(System.getProperty("java.io.tmpdir"), subdirForBDDReportFiles);
            String cucumberReportFormatter = "";
            String cucumberReportFileSuffix = "";
            if (this.reportFormat.equals((Object)ReportOutputFormat.PRETTY)) {
                cucumberReportFormatter = ReportOutputFormat.PRETTY.getFormatSpecifier();
                cucumberReportFileSuffix = ReportOutputFormat.PRETTY.getReportFileSuffix();
            } else if (this.reportFormat.equals((Object)ReportOutputFormat.JSON)) {
                cucumberReportFormatter = ReportOutputFormat.JSON.getFormatSpecifier();
                cucumberReportFileSuffix = ReportOutputFormat.JSON.getReportFileSuffix();
            }
            long unixTime = Instant.now().getEpochSecond();
            String cucumberReportBaseName = "bdd-report-" + unixTime;
            File cucumberHtmlReportFile = new File(reportFolder, String.valueOf(cucumberReportBaseName) + ".html").getAbsoluteFile();
            File cucumberRequestedFormatReportFile = new File(reportFolder, String.valueOf(cucumberReportBaseName) + cucumberReportFileSuffix).getAbsoluteFile();
            try {
                FileUtils.writeStringToFile((File)new File(reportFolder, "bdd-report-latest-path-html"), (String)cucumberHtmlReportFile.toString(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                CucumberTestFrameworkAdapter.this.log.error((Object)"Failed to store report file location", (Throwable)e);
            }
            this.outputReceiver.addOutput("Location of HTML report file: " + cucumberHtmlReportFile.toString());
            this.outputReceiver.addOutput("Location of " + (Object)((Object)this.reportFormat) + " report file: " + cucumberRequestedFormatReportFile.toString());
            eventBus.registerHandlerFor(TestStepFinished.class, this.cucumberTestStepFinishedHandler);
            eventBus.registerHandlerFor(TestCaseFinished.class, this.cucumberTestCaseFinishedHandler);
            eventBus.registerHandlerFor(TestRunFinished.class, this.cucumberTestRunFinishedHandler);
            RuntimeOptionsBuilder cucumberRuntimeOptionsBuilder = new RuntimeOptionsBuilder().addGlue(GluePath.parse((String)"de.rcenvironment.extras.testscriptrunner")).setMonochrome(true).setSnippetType(SnippetType.CAMELCASE).setPickleOrder(StandardPickleOrders.lexicalUriOrder()).addTagFilter(TagExpressionParser.parse((String)"not @disabled or not @Disabled")).addPluginName(StringUtils.format((String)"%s:%s/%s", (Object[])new Object[]{this.reportFormat.getFormatSpecifier(), this.reportDirUriString, this.reportFileName})).setObjectFactoryClass(PicoFactory.class).addPluginName("pretty").addDefaultSummaryPrinterIfNotDisabled().addPluginName(String.valueOf(ReportOutputFormat.HTML.getFormatSpecifier()) + ":" + cucumberHtmlReportFile.toString()).addPluginName(String.valueOf(cucumberReportFormatter) + ":" + cucumberRequestedFormatReportFile.toString()).addFeature(FeatureWithLines.parse((String)this.scriptLocationRoot.getAbsolutePath()));
            if (!StringUtils.isNullorEmpty((String)this.tagNameFilter) && !this.tagNameFilter.equals("--all")) {
                StringBuilder buffer = new StringBuilder();
                String[] stringArray = this.tagNameFilter.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String trimmedPart;
                    String filterPart = stringArray[n2];
                    if (buffer.length() != 0) {
                        buffer.append(" or ");
                    }
                    if (!(trimmedPart = filterPart.trim()).startsWith("@")) {
                        buffer.append("@");
                    }
                    buffer.append(trimmedPart);
                    ++n2;
                }
                if (buffer.length() != 0) {
                    cucumberRuntimeOptionsBuilder.addTagFilter(TagExpressionParser.parse((String)buffer.toString()));
                }
            }
            RuntimeOptions cucumberRuntimeOptions = cucumberRuntimeOptionsBuilder.build();
            Supplier<UUID> uuidSupplier = () -> ExecutionContext.lambda$5((EventBus)eventBus);
            FeatureParser featureParser = new FeatureParser(uuidSupplier);
            FeaturePathFeatureSupplier featureSupplier = new FeaturePathFeatureSupplier(this.classloaderSupplier, (io.cucumber.core.feature.Options)cucumberRuntimeOptions, featureParser);
            this.features = featureSupplier.get();
            this.tagFilters = new Filters((io.cucumber.core.filter.Options)cucumberRuntimeOptions);
            this.pickleOrder = cucumberRuntimeOptions.getPickleOrder();
            ExitStatus exitStatus = new ExitStatus((Options)cucumberRuntimeOptions);
            Plugins cucumberPlugins = new Plugins(new PluginFactory(), (Options)cucumberRuntimeOptions);
            cucumberPlugins.addPlugin((Plugin)exitStatus);
            ObjectFactoryServiceLoader cucumberObjectFactoryServiceLoader = new ObjectFactoryServiceLoader(this.classloaderSupplier, (io.cucumber.core.backend.Options)cucumberRuntimeOptions);
            SingletonObjectFactorySupplier cucumberObjectFactorySupplier = new SingletonObjectFactorySupplier(cucumberObjectFactoryServiceLoader);
            BackendServiceLoader cucumberBackendSupplier = new BackendServiceLoader(this.classloaderSupplier, (ObjectFactorySupplier)cucumberObjectFactorySupplier);
            SingletonRunnerSupplier cucumberRunnerSupplier = new SingletonRunnerSupplier((io.cucumber.core.runner.Options)cucumberRuntimeOptions, (EventBus)eventBus, (BackendSupplier)cucumberBackendSupplier, (ObjectFactorySupplier)cucumberObjectFactorySupplier);
            this.cucumberExecutionContext = new CucumberExecutionContext((EventBus)eventBus, exitStatus, (RunnerSupplier)cucumberRunnerSupplier);
            cucumberPlugins.setEventBusOnEventListenerPlugins((EventPublisher)eventBus);
            this.executor = new SingleThreadedExecutionService();
        }

        private void cucumberTestRunFinished(TestRunFinished event) {
            this.outputReceiver.addOutput("-----------------------------------------------------------------------------------------------");
            this.outputReceiver.addOutput("Test Run Summary:");
            this.outputReceiver.addOutput("-----------------------------------------------------------------------------------------------");
            this.scenarioStatistics.printSummary(this.outputReceiver, "Scenario counts: ");
            this.stepStatistics.printSummary(this.outputReceiver, "Step counts: ");
            if (this.scenarioStatistics.totalCount > 0 && this.scenarioStatistics.totalCount == this.scenarioStatistics.passedCount) {
                this.executionResultStatus = ExecutionResultStatus.SUCCESSFUL;
                this.outputReceiver.addOutput("All scenarios passed successfully");
            } else {
                this.executionResultStatus = ExecutionResultStatus.UNSUCCESSFUL;
                this.outputReceiver.addOutput("Unsuccessful scenarios:");
                for (Map.Entry<String, String> unsuccessfulScenario : this.unsuccessfulScenarios.entrySet()) {
                    this.outputReceiver.addOutput("- " + unsuccessfulScenario.getKey() + ": " + unsuccessfulScenario.getValue());
                }
            }
            this.outputReceiver.addOutput("-----------------------------------------------------------------------------------------------");
        }

        private void cucumberTestStepFinished(TestStepFinished event) {
            if (event.getTestStep() instanceof PickleStepTestStep) {
                ++this.stepStatistics.totalCount;
                PickleStepTestStep testStep = (PickleStepTestStep)event.getTestStep();
                this.cucumberStepResult(testStep, event.getResult());
            }
        }

        private void cucumberStepResult(PickleStepTestStep testStep, Result result) {
            Status testStepResult = result.getStatus();
            if (testStepResult.equals((Object)Status.SKIPPED)) {
                ++this.stepStatistics.skippedCount;
            } else if (testStepResult.equals((Object)Status.UNDEFINED)) {
                ++this.stepStatistics.undefinedCount;
            } else if (testStepResult.equals((Object)Status.FAILED)) {
                ++this.stepStatistics.failedCount;
            } else if (testStepResult.equals((Object)Status.AMBIGUOUS)) {
                ++this.stepStatistics.ambiguousCount;
            } else if (testStepResult.equals((Object)Status.PENDING)) {
                ++this.stepStatistics.pendingCount;
            } else if (testStepResult.equals((Object)Status.PASSED)) {
                ++this.stepStatistics.passedCount;
            } else {
                CucumberTestFrameworkAdapter.this.log.warn((Object)("Ignoring unhandled test step outcome " + testStepResult));
            }
        }

        private void cucumberTestCaseResult(TestCaseFinished scenario) {
            ++this.scenarioStatistics.totalCount;
            Status testCaseStatus = scenario.getResult().getStatus();
            if (testCaseStatus.equals((Object)Status.PASSED)) {
                ++this.scenarioStatistics.passedCount;
            } else {
                this.unsuccessfulScenarios.put(scenario.getTestCase().getName(), scenario.getResult().getStatus().toString());
                if (testCaseStatus.equals((Object)Status.SKIPPED)) {
                    ++this.scenarioStatistics.skippedCount;
                    CucumberTestFrameworkAdapter.this.log.info((Object)"Skipped");
                } else if (testCaseStatus.equals((Object)Status.UNDEFINED)) {
                    ++this.scenarioStatistics.undefinedCount;
                    CucumberTestFrameworkAdapter.this.log.error((Object)"Undefined Scenario");
                } else if (testCaseStatus.equals((Object)Status.FAILED)) {
                    ++this.scenarioStatistics.failedCount;
                    CucumberTestFrameworkAdapter.this.log.error((Object)"Failed Scenario");
                } else if (testCaseStatus.equals((Object)Status.AMBIGUOUS)) {
                    ++this.scenarioStatistics.ambiguousCount;
                    CucumberTestFrameworkAdapter.this.log.error((Object)"Ambiguous Scenario");
                } else if (testCaseStatus.equals((Object)Status.PENDING)) {
                    ++this.scenarioStatistics.pendingCount;
                    CucumberTestFrameworkAdapter.this.log.error((Object)"Pending Scenario");
                }
            }
        }

        private ExecutionResultStatus getExecutionResultStatus() {
            return this.executionResultStatus;
        }

        private void runFeatureFiles() {
            this.cucumberExecutionContext.runFeatures(() -> this.runFeatureFiles(this.features));
        }

        private Runnable runPickle(Pickle pickleToRun) {
            return () -> this.cucumberExecutionContext.runTestCase(cucumberRunner -> cucumberRunner.runPickle(pickleToRun));
        }

        private void runFeatureFiles(List<Feature> featuresList) {
            featuresList.forEach(arg_0 -> ((CucumberExecutionContext)this.cucumberExecutionContext).beforeFeature(arg_0));
            List pickleList = featuresList.stream().flatMap(feature -> feature.getPickles().stream()).filter(this.tagFilters).collect(Collectors.collectingAndThen(Collectors.toList(), orderedPickleList -> this.pickleOrder.orderPickles(orderedPickleList).stream())).map(pickle -> this.executor.submit(this.runPickle((Pickle)pickle))).collect(Collectors.toList());
            this.executor.shutdown();
            for (Future pickle2 : pickleList) {
                try {
                    pickle2.get();
                }
                catch (ExecutionException e) {
                    CucumberTestFrameworkAdapter.this.log.error((Object)e);
                }
                catch (InterruptedException e) {
                    CucumberTestFrameworkAdapter.this.log.error((Object)e);
                    this.executor.shutdownNow();
                }
            }
        }

        private static /* synthetic */ UUID lambda$5(EventBus eventBus) {
            return eventBus.generateId();
        }

        private final class ClassLoaderWrapper
        extends ClassLoader {
            private ClassLoaderWrapper(ClassLoader parent) {
                super(parent);
            }

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                Enumeration<URL> originalResult = super.getResources(name);
                ArrayList<URL> originalResultAsList = new ArrayList<URL>();
                while (originalResult.hasMoreElements()) {
                    originalResultAsList.add(originalResult.nextElement());
                }
                originalResult = null;
                ArrayList resultList = new ArrayList();
                ((ExecutionContext)ExecutionContext.this).CucumberTestFrameworkAdapter.this.log.debug((Object)("Original classloader result of getResources(\"" + name + "\"):"));
                AtomicBoolean modified = new AtomicBoolean();
                originalResultAsList.forEach(url -> {
                    ((ExecutionContext)ExecutionContext.this).CucumberTestFrameworkAdapter.this.log.debug((Object)("  " + url));
                    if ("bundleresource".equals(url.getProtocol()) && !url.getPath().contains("META-INF")) {
                        if (((ExecutionContext)ExecutionContext.this).CucumberTestFrameworkAdapter.this.classFileUrlsForRedirectingGlueCodeSearch.isEmpty()) {
                            ((ExecutionContext)ExecutionContext.this).CucumberTestFrameworkAdapter.this.log.error((Object)"No URL registered to redirect the glue code class file search to");
                        }
                        if (!modified.get()) {
                            resultList.addAll(((ExecutionContext)ExecutionContext.this).CucumberTestFrameworkAdapter.this.classFileUrlsForRedirectingGlueCodeSearch);
                            modified.set(true);
                        }
                    } else {
                        resultList.add(url);
                    }
                });
                if (modified.get()) {
                    ((ExecutionContext)ExecutionContext.this).CucumberTestFrameworkAdapter.this.log.debug((Object)"Result substituted with:");
                    resultList.forEach(u -> ((ExecutionContext)ExecutionContext.this).CucumberTestFrameworkAdapter.this.log.debug((Object)("  " + u)));
                }
                return Collections.enumeration(resultList);
            }
        }
    }

    public static final class ExecutionResult {
        private List<String> reportFileLines;
        private List<String> capturedStdOutLines;
        private ExecutionResultStatus status;

        public ExecutionResult(List<String> reportLines, List<String> capturedStdOutLines, ExecutionResultStatus status) {
            this.reportFileLines = reportLines;
            this.capturedStdOutLines = capturedStdOutLines;
            this.status = status;
        }

        public List<String> getReportFileLines() {
            return this.reportFileLines;
        }

        public List<String> getCapturedStdOutLines() {
            return this.capturedStdOutLines;
        }

        public ExecutionResultStatus getExecutionResultStatus() {
            return this.status;
        }
    }

    public static enum ExecutionResultStatus {
        SUCCESSFUL,
        UNSUCCESSFUL;

    }

    public static enum ReportOutputFormat {
        PRETTY("pretty", ".txt"),
        JSON("json", ".json"),
        HTML("html", ".html");

        private final String formatSpecifier;
        private final String reportFileSuffix;

        private ReportOutputFormat(String formatSpecifierParam, String reportFileSuffixParam) {
            this.formatSpecifier = formatSpecifierParam;
            this.reportFileSuffix = reportFileSuffixParam;
        }

        public String getFormatSpecifier() {
            return this.formatSpecifier;
        }

        public String getReportFileSuffix() {
            return this.reportFileSuffix;
        }
    }

    private final class SingleThreadedExecutionService
    extends AbstractExecutorService {
        private SingleThreadedExecutionService() {
        }

        @Override
        public void execute(Runnable commandd) {
            commandd.run();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return true;
        }

        @Override
        public boolean isTerminated() {
            return true;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return true;
        }

        @Override
        public void shutdown() {
            CucumberTestFrameworkAdapter.this.log.debug((Object)"Cucumber execution thread shutting down");
        }
    }

    public class TestStatistics {
        public int passedCount = 0;
        public int failedCount = 0;
        public int ambiguousCount = 0;
        public int skippedCount = 0;
        public int pendingCount = 0;
        public int undefinedCount = 0;
        public int totalCount = 0;

        void printSummary(TextOutputReceiver outputReceiver, String prefix) {
            int unsuccessfulCount = this.totalCount - this.passedCount;
            if (unsuccessfulCount == 0) {
                outputReceiver.addOutput(StringUtils.format((String)"%s%d passed, 0 unsuccessful or skipped", (Object[])new Object[]{prefix, this.passedCount}));
            } else {
                outputReceiver.addOutput(StringUtils.format((String)"%s%d passed, %d unsuccessful or skipped (%d failed, %d skipped, %d pending, %d undefined, %d ambiguous)", (Object[])new Object[]{prefix, this.passedCount, unsuccessfulCount, this.passedCount, this.failedCount, this.skippedCount, this.pendingCount, this.undefinedCount, this.ambiguousCount}));
            }
        }
    }
}

