/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.common;

import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.executor.testutils.IntegrationTestExecutorUtils;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ManagedInstance;
import io.cucumber.java.Scenario;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;

public final class TestScenarioExecutionContext {
    private static final ThreadLocal<TextOutputReceiver> THREAD_LOCAL_PARAMETER_OUTPUT_RECEIVER = new ThreadLocal();
    private static final ThreadLocal<String> THREAD_LOCAL_PARAMETER_BUILD_ID = new ThreadLocal();
    private static final ThreadLocal<File> THREAD_LOCAL_PARAMETER_SCRIPT_LOCATION = new ThreadLocal();
    private final TextOutputReceiver outputReceiver;
    private final String buildUnderTestId;
    private IntegrationTestExecutorUtils.ExecutionResult currentExecutionResult;
    private Scenario initialScenarioObject;
    private Thread initialExecutionThread;
    private final Log log = LogFactory.getLog(this.getClass());
    private File testScriptLocation;
    private ManagedInstance lastInstanceWithSingleCommandExecution;
    private Map<String, ManagedInstance> instancesById = new HashMap<String, ManagedInstance>();
    private Set<ManagedInstance> enabledInstances = new HashSet<ManagedInstance>();

    public TestScenarioExecutionContext() {
        this.outputReceiver = Objects.requireNonNull(THREAD_LOCAL_PARAMETER_OUTPUT_RECEIVER.get());
        this.buildUnderTestId = Objects.requireNonNull(THREAD_LOCAL_PARAMETER_BUILD_ID.get());
        this.testScriptLocation = Objects.requireNonNull(THREAD_LOCAL_PARAMETER_SCRIPT_LOCATION.get());
    }

    public static void setThreadLocalParameters(TextOutputReceiver outputReceiverParam, String buildUnderTestIdParam, File testScriptDirectoryParam) {
        if (THREAD_LOCAL_PARAMETER_OUTPUT_RECEIVER.get() != null) {
            throw new IllegalStateException();
        }
        THREAD_LOCAL_PARAMETER_OUTPUT_RECEIVER.set(outputReceiverParam);
        THREAD_LOCAL_PARAMETER_BUILD_ID.set(buildUnderTestIdParam);
        THREAD_LOCAL_PARAMETER_SCRIPT_LOCATION.set(testScriptDirectoryParam);
    }

    public static void discardThreadLocalParameters() {
        if (THREAD_LOCAL_PARAMETER_OUTPUT_RECEIVER.get() == null) {
            throw new IllegalStateException();
        }
        THREAD_LOCAL_PARAMETER_OUTPUT_RECEIVER.set(null);
        THREAD_LOCAL_PARAMETER_BUILD_ID.set(null);
    }

    public synchronized void beforeExecution(Scenario newScenario) {
        Assert.assertNull((Object)this.initialScenarioObject);
        Assert.assertNull((Object)this.initialExecutionThread);
        this.initialScenarioObject = newScenario;
        this.initialExecutionThread = Thread.currentThread();
        this.outputReceiver.addOutput("> Starting test scenario \"" + newScenario.getName() + "\"");
    }

    public synchronized void afterExecution(Scenario finishedScenario) {
        if (!finishedScenario.getId().equals(this.initialScenarioObject.getId())) {
            throw new IllegalArgumentException("Before and after calls provided different scenario ids");
        }
        if (Thread.currentThread() != this.initialExecutionThread) {
            this.log.warn((Object)"Unexpected threading behavior: The before and after methods were called from different threads");
        }
        if (this.initialScenarioObject.isFailed()) {
            this.outputReceiver.addOutput("*** Error in test scenario \"" + this.initialScenarioObject.getName() + "\"; dumping any captured StdOut/StdErr output");
            this.initialScenarioObject.log("*** Error in test scenario \"" + this.initialScenarioObject.getName() + "\"; dumping any captured StdOut/StdErr output");
            if (this.currentExecutionResult != null) {
                String logLine;
                for (String line : this.currentExecutionResult.stdoutLines) {
                    logLine = "[StdOut] " + line;
                    this.initialScenarioObject.log(logLine);
                    this.log.error((Object)logLine);
                }
                for (String line : this.currentExecutionResult.stderrLines) {
                    logLine = "[StdErr] " + line;
                    this.initialScenarioObject.log(logLine);
                    this.log.error((Object)logLine);
                }
            }
        } else {
            this.outputReceiver.addOutput("< Completed test scenario \"" + this.initialScenarioObject.getName() + "\"");
        }
    }

    public TextOutputReceiver getOutputReceiver() {
        return this.outputReceiver;
    }

    public String getBuildUnderTestId() {
        return this.buildUnderTestId;
    }

    public String getScenarioName() {
        return this.initialScenarioObject.getName();
    }

    public File getTestScriptLocation() {
        return this.testScriptLocation;
    }

    public ManagedInstance getLastInstanceWithSingleCommandExecution() {
        return this.lastInstanceWithSingleCommandExecution;
    }

    public void setLastInstanceWithSingleCommandExecution(ManagedInstance lastInstanceWithSingleCommandExecution) {
        this.lastInstanceWithSingleCommandExecution = lastInstanceWithSingleCommandExecution;
    }

    public void putInstance(String id, ManagedInstance instance) {
        this.instancesById.put(id, instance);
    }

    public ManagedInstance getInstanceFromId(String id) {
        return this.instancesById.get(id);
    }

    public Map<String, ManagedInstance> getInstancesById() {
        return this.instancesById;
    }

    public void addInstance(ManagedInstance instance) {
        this.enabledInstances.add(instance);
    }

    public Set<ManagedInstance> getEnabledInstances() {
        return this.enabledInstances;
    }

    public void setEnabledInstances(Set<ManagedInstance> enabledInstances) {
        this.enabledInstances = enabledInstances;
    }
}

