/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.common;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ShutdownHooks {
    private static final ShutdownHooks sharedInstance = new ShutdownHooks();
    private Map<String, Runnable> hooksById = new HashMap<String, Runnable>();
    private final Log log = LogFactory.getLog(this.getClass());

    private ShutdownHooks() {
    }

    public static synchronized void register(String id, Runnable runnable) {
        ShutdownHooks.sharedInstance.hooksById.put("id", runnable);
    }

    public static synchronized void execute() {
        for (Runnable hook : ShutdownHooks.sharedInstance.hooksById.values()) {
            try {
                hook.run();
            }
            catch (RuntimeException e) {
                ShutdownHooks.sharedInstance.log.error((Object)"Error while executing shutdown hook", (Throwable)e);
            }
        }
        ShutdownHooks.sharedInstance.hooksById = null;
    }
}

