/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.log.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.management.WorkflowHostSetListener;
import de.rcenvironment.core.gui.log.internal.LogContentProvider;
import de.rcenvironment.core.gui.log.internal.LogLabelProvider;
import de.rcenvironment.core.gui.log.internal.LogModel;
import de.rcenvironment.core.gui.log.internal.LogTableColumnSorter;
import de.rcenvironment.core.gui.log.internal.LogTableFilter;
import de.rcenvironment.core.gui.log.internal.Messages;
import de.rcenvironment.core.gui.resources.api.ColorManager;
import de.rcenvironment.core.gui.resources.api.ColorSource;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardColors;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.utils.common.ClipboardHelper;
import de.rcenvironment.core.gui.utils.incubator.TableColumnMinimalWidthControlListener;
import de.rcenvironment.core.log.SerializableLogEntry;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.text.WordUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class LogView
extends ViewPart {
    public static final String ID = "de.rcenvironment.rce.gui.log.view";
    private static LogView myInstance;
    private static final int TEXT_AREA_WORD_WRAP_WIDTH = 180;
    private static final boolean ERROR_PRESELECTED = true;
    private static final boolean INFO_PRESELECTED = true;
    private static final boolean WARN_PRESELECTED = true;
    private static final int COLUMN_WIDTH_BUNDLE = 250;
    private static final int COLUMN_WIDTH_PLATFORM = 250;
    private static final int COLUMN_WIDTH_LEVEL = 70;
    private static final int COLUMN_WIDTH_MESSAGE = 250;
    private static final int COLUMN_WIDTH_TIME = 140;
    private static final int NO_SPACE = 0;
    private static final int PLATFORM_WIDTH = 250;
    private static final int TEXT_WIDTH = 250;
    private Button myCheckboxError;
    private Button myCheckboxInfo;
    private Button myCheckboxWarn;
    private Combo myPlatformCombo;
    private LogTableFilter myListenerAndFilter;
    private LogTableColumnSorter myTableColumnSorter;
    private TableViewer myLogEntryTableViewer;
    private Text myMessageTextArea;
    private Text mySearchTextField;
    private Label searchWarning;
    private SerializableLogEntry displayedLogEntry;
    private boolean scrollLocked = false;
    private boolean adjustedSearchMessage = false;
    private Action clearAction = null;
    private Action copyAction = null;
    private Action scrollLockAction = null;
    private final LogModel.Listener listener = new LogModel.Listener(){

        @Override
        public void handleLogEntryAdded(final SerializableLogEntry logEntry) {
            if (!LogView.this.myLogEntryTableViewer.getTable().isDisposed() && !LogView.this.myLogEntryTableViewer.getTable().getDisplay().isDisposed()) {
                LogView.this.myLogEntryTableViewer.getTable().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).LogView.this.myLogEntryTableViewer.getTable().isDisposed() && logEntry.getPlatformIdentifer().equals(LogView.this.getPlatform())) {
                            (this).LogView.this.myLogEntryTableViewer.add((Object)logEntry);
                            if (!LogView.this.isScrollLocked()) {
                                (this).LogView.this.myLogEntryTableViewer.reveal((Object)logEntry);
                            }
                        }
                    }
                });
            }
        }

        @Override
        public void handleLogEntryRemoved(final SerializableLogEntry logEntry) {
            LogView.this.myLogEntryTableViewer.getTable().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!(this).LogView.this.myLogEntryTableViewer.getTable().isDisposed() && logEntry.getPlatformIdentifer().equals(LogView.this.getPlatform())) {
                        (this).LogView.this.myLogEntryTableViewer.remove((Object)logEntry);
                    }
                }
            });
            if (logEntry.equals((Object)LogView.this.getDisplayedLogEntry())) {
                LogView.this.myLogEntryTableViewer.getTable().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).LogView.this.myMessageTextArea.isDisposed()) {
                            LogView.this.displayLogEntry(null);
                        }
                    }
                });
            }
        }
    };
    private ServiceRegistryPublisherAccess serviceRegistryAccess;
    private Display display;

    public LogView() {
        myInstance = this;
    }

    public static LogView getInstance() {
        return myInstance;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite filterComposite = new Composite(parent, 0);
        filterComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        filterComposite.setLayout((Layout)new RowLayout());
        this.createLevelArrangement(filterComposite);
        this.createPlatformListingArrangement(filterComposite);
        this.createSearchArrangement(filterComposite);
        Composite sashComposite = new Composite(parent, 0);
        sashComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        sashComposite.setLayout((Layout)new GridLayout(1, false));
        SashForm sashForm = new SashForm(sashComposite, 66048);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTableArrangement((Composite)sashForm);
        this.createTableDynamics();
        this.createTextAreaArrangement((Composite)sashForm);
        sashForm.setWeights(new int[]{3, 1});
        sashForm.setSashWidth(7);
        this.myTableColumnSorter = new LogTableColumnSorter();
        this.myLogEntryTableViewer.setSorter((ViewerSorter)this.myTableColumnSorter);
        this.myListenerAndFilter = new LogTableFilter(this, this.myLogEntryTableViewer);
        this.mySearchTextField.addKeyListener((KeyListener)this.myListenerAndFilter);
        this.myCheckboxError.addSelectionListener((SelectionListener)this.myListenerAndFilter);
        this.myCheckboxInfo.addSelectionListener((SelectionListener)this.myListenerAndFilter);
        this.myCheckboxWarn.addSelectionListener((SelectionListener)this.myListenerAndFilter);
        this.myPlatformCombo.addSelectionListener((SelectionListener)this.myListenerAndFilter);
        this.myLogEntryTableViewer.addFilter((ViewerFilter)this.myListenerAndFilter);
        this.initActions();
        Action[] actionArray = this.createToolbarActions();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            this.getViewSite().getActionBars().getToolBarManager().add((IAction)action);
            ++n2;
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.myLogEntryTableViewer);
        this.hookContextMenu();
        this.myLogEntryTableViewer.getTable().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent arg0) {
                if (LogView.this.myLogEntryTableViewer.getSelection().isEmpty() || LogView.this.myLogEntryTableViewer.getTable().getItemCount() == 0) {
                    LogView.this.copyAction.setEnabled(false);
                } else {
                    LogView.this.copyAction.setEnabled(true);
                }
            }
        });
        this.display = parent.getShell().getDisplay();
        this.registerWorkflowHostSetListener();
    }

    private void registerWorkflowHostSetListener() {
        this.serviceRegistryAccess = ServiceRegistry.createPublisherAccessFor((Object)((Object)this));
        this.serviceRegistryAccess.registerService(WorkflowHostSetListener.class, (Object)new WorkflowHostSetListener(){

            public void onReachableWorkflowHostsChanged(Set<InstanceNodeSessionId> reachableWfHosts, Set<InstanceNodeSessionId> addedWfHosts, Set<InstanceNodeSessionId> removedWfHosts) {
                final List<InstanceNodeSessionId> nodeIds = LogModel.getInstance().updateListOfLogSources();
                LogView.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LogView.this.refreshPlatformCombo(nodeIds);
                    }
                });
            }
        });
    }

    private void asyncRefresh(final InstanceNodeSessionId platform) {
        this.myLogEntryTableViewer.getTable().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (!LogView.this.myLogEntryTableViewer.getTable().isDisposed()) {
                        try {
                            if (platform.equals(LogView.this.getPlatform())) {
                                LogView.this.displayLogEntry(null);
                                LogView.this.myLogEntryTableViewer.getTable().clearAll();
                                LogView.this.myLogEntryTableViewer.refresh();
                            }
                        }
                        catch (SWTException e) {
                            if (LogView.this.myLogEntryTableViewer.getTable().isDisposed()) break block4;
                            throw e;
                        }
                    }
                }
            }
        });
    }

    public boolean getErrorSelection() {
        return this.myCheckboxError.getSelection();
    }

    public boolean getInfoSelection() {
        return this.myCheckboxInfo.getSelection();
    }

    public boolean getWarnSelection() {
        return this.myCheckboxWarn.getSelection();
    }

    public InstanceNodeSessionId getPlatform() {
        return (InstanceNodeSessionId)this.myPlatformCombo.getData(this.myPlatformCombo.getItem(this.myPlatformCombo.getSelectionIndex()));
    }

    public String getSearchText() {
        boolean setVisible = false;
        boolean containsRow = false;
        String ret = "";
        if (this.adjustedSearchMessage) {
            this.adjustedSearchMessage = false;
            setVisible = true;
        }
        block0: do {
            containsRow = false;
            int inRow = 0;
            int rowStartIdx = 0;
            ret = this.mySearchTextField.getText().toString();
            int i = 0;
            while (i < ret.length()) {
                if (ret.charAt(i) == '*') {
                    if (inRow == 0) {
                        rowStartIdx = i;
                    }
                    ++inRow;
                } else {
                    inRow = 0;
                }
                if (inRow > 1) {
                    setVisible = true;
                    containsRow = true;
                    this.mySearchTextField.setText(String.valueOf(this.mySearchTextField.getText().toString().substring(0, rowStartIdx)) + this.mySearchTextField.getText().toString().substring(i, ret.length()));
                    this.mySearchTextField.setSelection(rowStartIdx + 1);
                    this.adjustedSearchMessage = true;
                    continue block0;
                }
                ++i;
            }
        } while (containsRow);
        this.searchWarning.setVisible(setVisible);
        return ret;
    }

    public void setFocus() {
        this.myLogEntryTableViewer.getControl().setFocus();
    }

    private void createLevelArrangement(Composite filterComposite) {
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 0;
        filterComposite.setLayout((Layout)rowLayout);
        this.myCheckboxError = new Button(filterComposite, 32);
        this.myCheckboxError.setText(Messages.error);
        this.myCheckboxError.setSelection(true);
        this.myCheckboxWarn = new Button(filterComposite, 32);
        this.myCheckboxWarn.setText(Messages.warn);
        this.myCheckboxWarn.setSelection(true);
        this.myCheckboxInfo = new Button(filterComposite, 32);
        this.myCheckboxInfo.setText(Messages.info);
        this.myCheckboxInfo.setSelection(true);
    }

    private void createPlatformListingArrangement(Composite platformComposite) {
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 0;
        platformComposite.setLayout((Layout)rowLayout);
        this.myPlatformCombo = new Combo(platformComposite, 12);
        for (InstanceNodeSessionId nodeId : LogModel.getInstance().updateListOfLogSources()) {
            this.myPlatformCombo.add(nodeId.getAssociatedDisplayName());
            this.myPlatformCombo.setData(nodeId.getAssociatedDisplayName(), (Object)nodeId);
        }
        this.myPlatformCombo.select(0);
        this.myPlatformCombo.setLayoutData((Object)new RowData(250, -1));
        LogModel.getInstance().setSelectedLogSource((InstanceNodeSessionId)this.myPlatformCombo.getData(this.myPlatformCombo.getItem(this.myPlatformCombo.getSelectionIndex())));
    }

    private void createSearchArrangement(Composite searchComposite) {
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 7;
        rowLayout.center = true;
        rowLayout.fill = true;
        searchComposite.setLayout((Layout)rowLayout);
        this.mySearchTextField = new Text(searchComposite, 128);
        this.mySearchTextField.setMessage(Messages.search);
        this.mySearchTextField.setSize(250, -1);
        this.mySearchTextField.setLayoutData((Object)new RowData(250, -1));
        Composite warningComp = new Composite(searchComposite, 0);
        warningComp.setLayout((Layout)rowLayout);
        this.searchWarning = new Label(warningComp, 0x1000800);
        this.searchWarning.setVisible(false);
        this.searchWarning.setBackground(ColorManager.getInstance().getSharedColor((ColorSource)StandardColors.RCE_GERALDINE));
        this.searchWarning.setFont(new Font(null, new FontData("TimesNewRoman", 8, 1)));
        this.searchWarning.setText(" Only one ' * ' in a row allowed ");
    }

    private void createTableArrangement(Composite tableComposite) {
        tableComposite.setLayout((Layout)new GridLayout());
        this.myLogEntryTableViewer = new TableViewer(tableComposite, 66306);
        this.myLogEntryTableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        String[] columnTitles = new String[]{Messages.level, Messages.message, Messages.bundle, Messages.platform, Messages.timestamp};
        int[] bounds = new int[]{70, 250, 250, 250, 140};
        int i = 0;
        while (i < columnTitles.length) {
            final int index = i;
            TableViewerColumn viewerColumn = new TableViewerColumn(this.myLogEntryTableViewer, 0);
            final TableColumn column = viewerColumn.getColumn();
            column.setText(columnTitles[i]);
            column.setWidth(bounds[i]);
            column.setResizable(true);
            column.setMoveable(true);
            column.addControlListener((ControlListener)new TableColumnMinimalWidthControlListener());
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LogView.this.myTableColumnSorter.setColumn(index);
                    int direction = LogView.this.myLogEntryTableViewer.getTable().getSortDirection();
                    direction = LogView.this.myLogEntryTableViewer.getTable().getSortColumn() == column ? (direction == 128 ? 1024 : 128) : 128;
                    LogView.this.myLogEntryTableViewer.getTable().setSortDirection(direction);
                    LogView.this.myLogEntryTableViewer.getTable().setSortColumn(column);
                    LogView.this.myLogEntryTableViewer.getTable().clearAll();
                    LogView.this.myLogEntryTableViewer.refresh();
                }
            });
            ++i;
        }
        this.myLogEntryTableViewer.setContentProvider((IContentProvider)new LogContentProvider());
        this.myLogEntryTableViewer.setLabelProvider((IBaseLabelProvider)new LogLabelProvider());
        this.myLogEntryTableViewer.setInput((Object)LogModel.getInstance());
        final Table table = this.myLogEntryTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableItem[] selection = table.getSelection();
                if (selection.length > 0 && selection[0].getData() instanceof SerializableLogEntry) {
                    SerializableLogEntry log = (SerializableLogEntry)selection[0].getData();
                    LogView.this.displayLogEntry(log);
                }
            }
        });
        this.myLogEntryTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    LogView.this.displayLogEntry(null);
                }
            }
        });
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)this.clearAction);
        menuManager.add((IAction)this.copyAction);
        Menu menu = menuManager.createContextMenu((Control)this.myLogEntryTableViewer.getTable());
        this.myLogEntryTableViewer.getTable().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.myLogEntryTableViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.myLogEntryTableViewer);
    }

    private void createTableDynamics() {
        LogModel.getInstance().addListener(this.listener);
    }

    private SerializableLogEntry getDisplayedLogEntry() {
        return this.displayedLogEntry;
    }

    protected void displayLogEntry(SerializableLogEntry logEntry) {
        StringBuilder builder = new StringBuilder();
        if (logEntry != null) {
            builder.append(logEntry.getMessage().replaceAll("#RCEn", "\n"));
            if (logEntry.getException() != null) {
                if (builder.length() == 0) {
                    builder.append("(no message)");
                }
                if (logEntry.getException() != null && !logEntry.getException().isEmpty()) {
                    if (builder.charAt(builder.length() - 1) == ':') {
                        builder.append(" ");
                    } else {
                        builder.append(": ");
                    }
                    builder.append(logEntry.getException());
                }
            }
        }
        String text = builder.toString();
        text = WordUtils.wrap((String)text, (int)180, (String)"\n", (boolean)false);
        this.myMessageTextArea.setText(text);
        this.displayedLogEntry = logEntry;
    }

    public void dispose() {
        LogModel.getInstance().removeListener(this.listener);
        super.dispose();
        if (this.serviceRegistryAccess != null) {
            this.serviceRegistryAccess.dispose();
        }
    }

    private void createTextAreaArrangement(Composite textAreaComposite) {
        textAreaComposite.setLayout((Layout)new GridLayout(1, false));
        this.myMessageTextArea = new Text(textAreaComposite, 2818);
        this.myMessageTextArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.myMessageTextArea.setEditable(false);
    }

    private Action[] createToolbarActions() {
        return new Action[]{this.scrollLockAction, this.clearAction};
    }

    protected void clear() {
        LogModel.getInstance().clear();
        this.asyncRefresh(this.getPlatform());
    }

    protected void setScrollLocked(boolean scrollLocked) {
        this.scrollLocked = scrollLocked;
    }

    public boolean isScrollLocked() {
        return this.scrollLocked;
    }

    protected ImageDescriptor getScrollLockImageDescriptor() {
        ImageDescriptor result = this.isScrollLocked() ? ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.SCROLLOCK_ENABLED) : ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.SCROLLOCK_DISABLED);
        return result;
    }

    private void refreshPlatformCombo(List<InstanceNodeSessionId> nodeIds) {
        this.myPlatformCombo.removeAll();
        for (InstanceNodeSessionId nodeId : nodeIds) {
            this.myPlatformCombo.add(nodeId.getAssociatedDisplayName());
            this.myPlatformCombo.setData(nodeId.getAssociatedDisplayName(), (Object)nodeId);
        }
        LogModel logModel = LogModel.getInstance();
        logModel.updateListOfLogSources();
        InstanceNodeSessionId currentPlatform = logModel.getCurrentLogSource();
        if (currentPlatform != null) {
            String[] items = this.myPlatformCombo.getItems();
            int i = 0;
            while (i < items.length) {
                if (this.myPlatformCombo.getData(items[i]).equals(currentPlatform)) {
                    this.myPlatformCombo.select(i);
                    return;
                }
                ++i;
            }
        }
        this.myPlatformCombo.select(0);
        logModel.setSelectedLogSource((InstanceNodeSessionId)this.myPlatformCombo.getData(this.myPlatformCombo.getItem(0)));
        this.asyncRefresh(logModel.getCurrentLogSource());
    }

    private void initActions() {
        this.clearAction = new Action(Messages.clear, ImageDescriptor.createFromImage((Image)PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"))){

            public void run() {
                LogView.this.clear();
            }
        };
        this.copyAction = new Action(Messages.copy, ImageDescriptor.createFromImage((Image)PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY"))){

            public void run() {
                ISelection selection = LogView.this.myLogEntryTableViewer.getSelection();
                ArrayList<SerializableLogEntry> logEntries = new ArrayList<SerializableLogEntry>();
                if (selection != null && selection instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)selection;
                    for (SerializableLogEntry logEntry : sel) {
                        logEntries.add(logEntry);
                    }
                }
                StringBuilder sb = new StringBuilder();
                for (SerializableLogEntry logEntry : logEntries) {
                    sb.append(String.valueOf(logEntry.toString()) + System.getProperty("line.separator"));
                }
                if (sb.length() > 0) {
                    ClipboardHelper.setContent((String)sb.toString());
                }
            }
        };
        this.scrollLockAction = new Action(Messages.scrollLock, 2){
            {
                this.setImageDescriptor(LogView.this.getScrollLockImageDescriptor());
            }

            public void run() {
                LogView.this.setScrollLocked(!LogView.this.isScrollLocked());
                this.setImageDescriptor(LogView.this.getScrollLockImageDescriptor());
            }
        };
    }
}

